/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.special;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.base.trait.IGenericImplTrait;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.CommonsLinkedHashSet;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.css.media.CSSMediaList;
import com.helger.css.media.ICSSMediaList;
import com.helger.html.hc.special.IHCSpecialNodes;
import com.helger.html.hc.special.InlineCSSList;
import com.helger.html.js.CollectingJSCodeProvider;
import com.helger.html.js.IHasJSCode;
import com.helger.html.resource.css.ICSSCodeProvider;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractHCSpecialNodes<IMPLTYPE extends AbstractHCSpecialNodes<IMPLTYPE>>
implements IHCSpecialNodes,
IGenericImplTrait<IMPLTYPE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractHCSpecialNodes.class);
    private final ICommonsOrderedMap<ICSSMediaList, ICommonsOrderedSet<String>> m_aExternalCSSs = new CommonsLinkedHashMap();
    private final InlineCSSList m_aInlineCSSBeforeExternal = new InlineCSSList();
    private final InlineCSSList m_aInlineCSSAfterExternal = new InlineCSSList();
    private final ICommonsOrderedSet<String> m_aExternalJSs = new CommonsLinkedHashSet();
    private final CollectingJSCodeProvider m_aInlineJSBeforeExternal = new CollectingJSCodeProvider();
    private final CollectingJSCodeProvider m_aInlineJSAfterExternal = new CollectingJSCodeProvider();

    public void clear() {
        this.m_aExternalCSSs.clear();
        this.m_aInlineCSSBeforeExternal.clear();
        this.m_aInlineCSSAfterExternal.clear();
        this.m_aExternalJSs.clear();
        this.m_aInlineJSBeforeExternal.reset();
        this.m_aInlineJSAfterExternal.reset();
    }

    @Override
    public boolean isEmpty() {
        return this.m_aExternalCSSs.isEmpty() && this.m_aInlineCSSBeforeExternal.isEmpty() && this.m_aInlineCSSAfterExternal.isEmpty() && this.m_aExternalJSs.isEmpty() && this.m_aInlineJSBeforeExternal.isEmpty() && this.m_aInlineJSAfterExternal.isEmpty();
    }

    @Nonnull
    protected ICSSMediaList getSafeCSSMediaList(@Nullable ICSSMediaList iCSSMediaList) {
        if (iCSSMediaList != null && !iCSSMediaList.hasNoMediaOrAll()) {
            return iCSSMediaList;
        }
        return new CSSMediaList();
    }

    @Nonnull
    public IMPLTYPE addExternalCSS(@Nullable ICSSMediaList iCSSMediaList2, @Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"CSSURI");
        ICSSMediaList iCSSMediaList3 = this.getSafeCSSMediaList(iCSSMediaList2);
        if (((ICommonsOrderedSet)this.m_aExternalCSSs.computeIfAbsent((Object)iCSSMediaList3, iCSSMediaList -> new CommonsLinkedHashSet())).addObject((Object)string).isUnchanged()) {
            LOGGER.warn("Duplicate CSS URI '" + string + "' with media list '" + String.valueOf(iCSSMediaList3) + "' ignored");
        }
        return (IMPLTYPE)((AbstractHCSpecialNodes)this.thisAsT());
    }

    @Override
    public boolean hasExternalCSSs() {
        return !this.m_aExternalCSSs.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<ICSSMediaList, ICommonsList<String>> getAllExternalCSSs() {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        for (Map.Entry entry : this.m_aExternalCSSs.entrySet()) {
            commonsLinkedHashMap.put((Object)((ICSSMediaList)entry.getKey()), (Object)((ICommonsOrderedSet)entry.getValue()).getCopyAsList());
        }
        return commonsLinkedHashMap;
    }

    @Nonnull
    public IMPLTYPE addInlineCSSBeforeExternal(@Nullable ICSSMediaList iCSSMediaList, @Nonnull CharSequence charSequence) {
        ValueEnforcer.notNull((Object)charSequence, (String)"InlineCSS");
        this.m_aInlineCSSBeforeExternal.addInlineCSS(iCSSMediaList, charSequence);
        return (IMPLTYPE)((AbstractHCSpecialNodes)this.thisAsT());
    }

    @Override
    public boolean hasInlineCSSBeforeExternal() {
        return this.m_aInlineCSSBeforeExternal.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ICSSCodeProvider> getAllInlineCSSBeforeExternal() {
        return this.m_aInlineCSSBeforeExternal.getAll();
    }

    @Nonnull
    public IMPLTYPE addInlineCSSAfterExternal(@Nullable ICSSMediaList iCSSMediaList, @Nonnull CharSequence charSequence) {
        ValueEnforcer.notNull((Object)charSequence, (String)"InlineCSS");
        this.m_aInlineCSSAfterExternal.addInlineCSS(iCSSMediaList, charSequence);
        return (IMPLTYPE)((AbstractHCSpecialNodes)this.thisAsT());
    }

    @Override
    public boolean hasInlineCSSAfterExternal() {
        return this.m_aInlineCSSAfterExternal.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ICSSCodeProvider> getAllInlineCSSAfterExternal() {
        return this.m_aInlineCSSAfterExternal.getAll();
    }

    @Nonnull
    public IMPLTYPE addExternalJS(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"JSURI");
        if (!this.m_aExternalJSs.add((Object)string)) {
            LOGGER.warn("Duplicate JS URI '" + string + "' ignored");
        }
        return (IMPLTYPE)((AbstractHCSpecialNodes)this.thisAsT());
    }

    @Override
    public boolean hasExternalJSs() {
        return this.m_aExternalJSs.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllExternalJSs() {
        return this.m_aExternalJSs.getCopyAsList();
    }

    @Nonnull
    public IMPLTYPE addInlineJSBeforeExternal(@Nonnull IHasJSCode iHasJSCode) {
        ValueEnforcer.notNull((Object)iHasJSCode, (String)"InlineJS");
        this.m_aInlineJSBeforeExternal.appendFlattened(iHasJSCode);
        return (IMPLTYPE)((AbstractHCSpecialNodes)this.thisAsT());
    }

    @Override
    public boolean hasInlineJSBeforeExternal() {
        return this.m_aInlineJSBeforeExternal.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public CollectingJSCodeProvider getInlineJSBeforeExternal() {
        return this.m_aInlineJSBeforeExternal.getClone();
    }

    @Nonnull
    public IMPLTYPE addInlineJSAfterExternal(@Nonnull IHasJSCode iHasJSCode) {
        ValueEnforcer.notNull((Object)iHasJSCode, (String)"InlineJS");
        this.m_aInlineJSAfterExternal.appendFlattened(iHasJSCode);
        return (IMPLTYPE)((AbstractHCSpecialNodes)this.thisAsT());
    }

    @Override
    public boolean hasInlineJSAfterExternal() {
        return this.m_aInlineJSAfterExternal.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public CollectingJSCodeProvider getInlineJSAfterExternal() {
        return this.m_aInlineJSAfterExternal.getClone();
    }

    @Nonnull
    public IMPLTYPE addAll(@Nonnull IHCSpecialNodes iHCSpecialNodes) {
        ValueEnforcer.notNull((Object)iHCSpecialNodes, (String)"SpecialNodes");
        for (Object object : iHCSpecialNodes.getAllExternalCSSs().entrySet()) {
            for (String string : (ICommonsList)object.getValue()) {
                this.addExternalCSS((ICSSMediaList)object.getKey(), string);
            }
        }
        for (Object object : iHCSpecialNodes.getAllInlineCSSBeforeExternal()) {
            this.addInlineCSSBeforeExternal(object.getMediaList(), object.getCSSCode());
        }
        for (Object object : iHCSpecialNodes.getAllInlineCSSAfterExternal()) {
            this.addInlineCSSAfterExternal(object.getMediaList(), object.getCSSCode());
        }
        for (Object object : iHCSpecialNodes.getAllExternalJSs()) {
            this.addExternalJS((String)object);
        }
        this.addInlineJSBeforeExternal(iHCSpecialNodes.getInlineJSBeforeExternal());
        this.addInlineJSAfterExternal(iHCSpecialNodes.getInlineJSAfterExternal());
        return (IMPLTYPE)((AbstractHCSpecialNodes)this.thisAsT());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractHCSpecialNodes abstractHCSpecialNodes = (AbstractHCSpecialNodes)object;
        return this.m_aExternalCSSs.equals(abstractHCSpecialNodes.m_aExternalCSSs) && this.m_aInlineCSSBeforeExternal.equals(abstractHCSpecialNodes.m_aInlineCSSBeforeExternal) && this.m_aInlineCSSAfterExternal.equals(abstractHCSpecialNodes.m_aInlineCSSAfterExternal) && this.m_aExternalJSs.equals(abstractHCSpecialNodes.m_aExternalJSs) && this.m_aInlineJSBeforeExternal.equals(abstractHCSpecialNodes.m_aInlineJSBeforeExternal) && this.m_aInlineJSAfterExternal.equals(abstractHCSpecialNodes.m_aInlineJSAfterExternal);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aExternalCSSs).append((Object)this.m_aInlineCSSBeforeExternal).append((Object)this.m_aInlineCSSAfterExternal).append(this.m_aExternalJSs).append((Object)this.m_aInlineJSBeforeExternal).append((Object)this.m_aInlineJSAfterExternal).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIf("externalCSS", this.m_aExternalCSSs, CollectionHelper::isNotEmpty).append("inlineCSSBeforeExternal", (Object)this.m_aInlineCSSBeforeExternal).append("inlineCSSAfterExternal", (Object)this.m_aInlineCSSAfterExternal).appendIf("externalJS", this.m_aExternalJSs, CollectionHelper::isNotEmpty).append("inlineJSBeforeExternal", (Object)this.m_aInlineJSBeforeExternal).append("inlineJSAfterExternal", (Object)this.m_aInlineJSBeforeExternal).getToString();
    }
}

