/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.impl;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.debug.GlobalDebug;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EContinue;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.ICommonsIterable;
import com.helger.collection.commons.ICommonsList;
import com.helger.html.EHTMLVersion;
import com.helger.html.hc.EHCNodeState;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCCustomizer;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.config.HCConsistencyChecker;
import com.helger.xml.microdom.IMicroNode;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

@NotThreadSafe
public abstract class AbstractHCNode
implements IHCNode {
    private static final boolean DEBUG_NODE_STATE = GlobalDebug.isDebugMode();
    private EHCNodeState m_eNodeState = EHCNodeState.INITIAL;

    @OverrideOnDemand
    public boolean hasChildren() {
        return false;
    }

    @Nonnegative
    @OverrideOnDemand
    public int getChildCount() {
        return 0;
    }

    @Nullable
    @OverrideOnDemand
    public ICommonsList<? extends IHCNode> getAllChildren() {
        return null;
    }

    @Nullable
    @OverrideOnDemand
    public ICommonsIterable<? extends IHCNode> getChildren() {
        return null;
    }

    public void forAllChildren(@Nonnull Consumer<? super IHCNode> consumer) {
    }

    @Nonnull
    public EContinue forAllChildrenBreakable(@Nonnull Function<? super IHCNode, EContinue> function) {
        return EContinue.CONTINUE;
    }

    public void forAllChildren(@Nonnull Predicate<? super IHCNode> predicate, @Nonnull Consumer<? super IHCNode> consumer) {
    }

    public <DSTTYPE> void forAllChildrenMapped(@Nonnull Predicate<? super IHCNode> predicate, @Nonnull Function<? super IHCNode, ? extends DSTTYPE> function, @Nonnull Consumer<? super DSTTYPE> consumer) {
    }

    @Nullable
    @OverrideOnDemand
    public IHCNode getChildAtIndex(@Nonnegative int n) {
        return null;
    }

    @Nullable
    @OverrideOnDemand
    public IHCNode getFirstChild() {
        return null;
    }

    @Nullable
    public IHCNode findFirstChild(@Nonnull Predicate<? super IHCNode> predicate) {
        return null;
    }

    @Nullable
    public <DSTTYPE> DSTTYPE findFirstChildMapped(@Nonnull Predicate<? super IHCNode> predicate, @Nonnull Function<? super IHCNode, ? extends DSTTYPE> function) {
        return null;
    }

    @Nullable
    @OverrideOnDemand
    public IHCNode getLastChild() {
        return null;
    }

    @Override
    @Nonnull
    public EHCNodeState getNodeState() {
        return this.m_eNodeState;
    }

    private final void _ensureNodeState(@Nonnull EHCNodeState eHCNodeState) {
        ValueEnforcer.notNull((Object)((Object)eHCNodeState), (String)"NodeState");
    }

    public final void internalSetNodeState(@Nonnull EHCNodeState eHCNodeState) {
        if (DEBUG_NODE_STATE) {
            ValueEnforcer.notNull((Object)((Object)eHCNodeState), (String)"NodeState");
            EHCNodeState eHCNodeState2 = this.getNodeState();
            if (eHCNodeState2.isAfter(eHCNodeState)) {
                HCConsistencyChecker.consistencyError("The new node state is invalid. Got " + String.valueOf((Object)eHCNodeState) + " but having " + String.valueOf((Object)eHCNodeState2));
            }
        }
        this.m_eNodeState = eHCNodeState;
    }

    @OverrideOnDemand
    protected void onCustomizeNode(@Nonnull IHCCustomizer iHCCustomizer, @Nonnull EHTMLVersion eHTMLVersion, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
        iHCCustomizer.customizeNode(this, eHTMLVersion, iHCHasChildrenMutable);
    }

    @Override
    public final void customizeNode(@Nullable IHCCustomizer iHCCustomizer, @Nonnull EHTMLVersion eHTMLVersion, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
        if (this.m_eNodeState.isBefore(EHCNodeState.CUSTOMIZED)) {
            this._ensureNodeState(EHCNodeState.INITIAL);
            if (iHCCustomizer != null) {
                this.onCustomizeNode(iHCCustomizer, eHTMLVersion, iHCHasChildrenMutable);
            }
            this.internalSetNodeState(EHCNodeState.CUSTOMIZED);
        }
    }

    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    protected void onFinalizeNodeState(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
    }

    @Override
    public final void finalizeNodeState(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
        if (this.m_eNodeState.isBefore(EHCNodeState.FINALIZED)) {
            this._ensureNodeState(EHCNodeState.CUSTOMIZED);
            this.onFinalizeNodeState(iHCConversionSettingsToNode, iHCHasChildrenMutable);
            this.internalSetNodeState(EHCNodeState.FINALIZED);
        }
    }

    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    protected void onConsistencyCheck(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
    }

    @Override
    public final void consistencyCheck(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        if (this.m_eNodeState.isBefore(EHCNodeState.CONSISTENCY_CHECKED)) {
            this._ensureNodeState(EHCNodeState.FINALIZED);
            if (iHCConversionSettingsToNode.areConsistencyChecksEnabled()) {
                this.onConsistencyCheck(iHCConversionSettingsToNode);
            }
            this.internalSetNodeState(EHCNodeState.CONSISTENCY_CHECKED);
        }
    }

    @Override
    @OverrideOnDemand
    public boolean canConvertToMicroNode(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        return true;
    }

    @OverrideOnDemand
    protected void onRegisterExternalResources(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, boolean bl) {
    }

    @Override
    public final void registerExternalResources(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, boolean bl) {
        if (this.m_eNodeState.isBefore(EHCNodeState.RESOURCES_REGISTERED)) {
            this._ensureNodeState(EHCNodeState.CONSISTENCY_CHECKED);
            if (bl || this.canConvertToMicroNode(iHCConversionSettingsToNode)) {
                this.onRegisterExternalResources(iHCConversionSettingsToNode, bl);
            }
            this.internalSetNodeState(EHCNodeState.RESOURCES_REGISTERED);
        }
    }

    @Nullable
    @OverrideOnDemand
    protected abstract IMicroNode internalConvertToMicroNode(@Nonnull IHCConversionSettingsToNode var1);

    @Override
    @Nullable
    public final IMicroNode convertToMicroNode(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        this._ensureNodeState(EHCNodeState.RESOURCES_REGISTERED);
        if (!this.canConvertToMicroNode(iHCConversionSettingsToNode)) {
            return null;
        }
        return this.internalConvertToMicroNode(iHCConversionSettingsToNode);
    }

    @Override
    @Nonnull
    @OverrideOnDemand
    public String getPlainText() {
        return "";
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("NodeState", (Enum)this.m_eNodeState).getToString();
    }
}

