/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.tabular;

import com.helger.annotation.CheckForSigned;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.misc.DevelopersNote;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsSet;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.IHCElement;
import com.helger.html.hc.html.tabular.HCColGroup;
import com.helger.html.hc.html.tabular.HCRow;
import com.helger.html.hc.html.tabular.HCTBody;
import com.helger.html.hc.html.tabular.HCTFoot;
import com.helger.html.hc.html.tabular.HCTHead;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.html.hc.impl.HCTextNode;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Comparator;

public interface IHCTable<IMPLTYPE extends IHCTable<IMPLTYPE>>
extends IHCElement<IMPLTYPE> {
    @Nonnull
    public HCTHead getHead();

    @Nonnull
    public IMPLTYPE setHead(@Nonnull HCTHead var1);

    @Nonnull
    public HCTBody getBody();

    @Nonnull
    public IMPLTYPE setBody(@Nonnull HCTBody var1);

    @Nonnull
    public HCTFoot getFoot();

    @Nonnull
    public IMPLTYPE setFoot(@Nonnull HCTFoot var1);

    @CheckForSigned
    public int getCellSpacing();

    @Nonnull
    public IMPLTYPE setCellSpacing(int var1);

    @CheckForSigned
    public int getCellPadding();

    @Nonnull
    public IMPLTYPE setCellPadding(int var1);

    @Nullable
    public HCColGroup getColGroup();

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsList<? extends IHCCol<?>> getAllColumns() {
        HCColGroup hCColGroup = this.getColGroup();
        return hCColGroup != null ? hCColGroup.getAllColumns() : new CommonsArrayList();
    }

    @Nonnull
    public IMPLTYPE addColumn(@Nullable IHCCol<?> var1);

    @Nonnull
    public IMPLTYPE addColumnAt(@Nonnegative int var1, @Nullable IHCCol<?> var2);

    @Nonnull
    @Deprecated(forRemoval=false)
    @DevelopersNote(value="Use addColumn")
    default public IMPLTYPE addColumns(@Nullable IHCCol<?> iHCCol) {
        return this.addColumn(iHCCol);
    }

    @Nonnull
    default public IMPLTYPE addColumns(IHCCol<?> ... iHCColArray) {
        if (iHCColArray != null) {
            for (IHCCol<?> iHCCol : iHCColArray) {
                this.addColumn(iHCCol);
            }
        }
        return (IMPLTYPE)((IHCTable)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE addColumns(@Nullable Iterable<? extends IHCCol<?>> iterable) {
        if (iterable != null) {
            for (IHCCol<?> iHCCol : iterable) {
                this.addColumn(iHCCol);
            }
        }
        return (IMPLTYPE)((IHCTable)this.thisAsT());
    }

    @Nonnull
    public IMPLTYPE removeColumnAt(@Nonnegative int var1);

    @Nonnull
    public IMPLTYPE removeAllColumns();

    @Nonnegative
    public int getColumnCount();

    @Nullable
    default public String getHeaderID() {
        return this.getHead().getID();
    }

    @Nonnull
    default public IMPLTYPE setHeaderID(@Nullable String string) {
        this.getHead().setID(string);
        return (IMPLTYPE)((IHCTable)this.thisAsT());
    }

    default public boolean hasHeaderID() {
        return this.getHead().hasID();
    }

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsSet<ICSSClassProvider> getAllHeaderClasses() {
        return this.getHead().getAllClasses();
    }

    @Nonnull
    default public String getAllHeaderClassesAsString() {
        return this.getHead().getAllClassesAsString();
    }

    @Nonnull
    default public IMPLTYPE addHeaderClass(@Nonnull ICSSClassProvider iCSSClassProvider) {
        this.getHead().addClass(iCSSClassProvider);
        return (IMPLTYPE)((IHCTable)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE removeHeaderClass(@Nonnull ICSSClassProvider iCSSClassProvider) {
        this.getHead().removeClass(iCSSClassProvider);
        return (IMPLTYPE)((IHCTable)this.thisAsT());
    }

    default public boolean hasHeaderClasses() {
        return this.getHead().hasAnyClass();
    }

    default public boolean hasHeaderRows() {
        return this.getHead().hasChildren();
    }

    @Nonnegative
    default public int getHeaderRowCount() {
        return this.getHead().getChildCount();
    }

    @Nullable
    default public HCRow getFirstHeaderRow() {
        return (HCRow)this.getHead().getFirstChild();
    }

    @Nullable
    default public HCRow getHeaderRowAtIndex(@Nonnegative int n) {
        return (HCRow)this.getHead().getChildAtIndex(n);
    }

    @Nullable
    default public HCRow getLastHeaderRow() {
        return (HCRow)this.getHead().getLastChild();
    }

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsList<HCRow> getAllHeaderRows() {
        return this.getHead().getAllChildren();
    }

    @Nonnull
    default public HCRow addHeaderRow() {
        return this.getHead().addRow();
    }

    @Nonnull
    default public HCRow addHeaderRowAt(@Nonnegative int n) {
        return this.getHead().addRowAt(n);
    }

    @Nonnull
    default public IMPLTYPE addHeaderRow(@Nullable HCRow hCRow) {
        this.getHead().addChild(hCRow);
        return (IMPLTYPE)((IHCTable)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE addHeaderRowAt(@Nonnegative int n, @Nullable HCRow hCRow) {
        this.getHead().addChildAt(n, hCRow);
        return (IMPLTYPE)((IHCTable)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE removeHeaderRowAt(@Nonnegative int n) {
        this.getHead().removeChildAt(n);
        return (IMPLTYPE)((IHCTable)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE removeAllHeaderRows() {
        this.getHead().removeAllChildren();
        return (IMPLTYPE)((IHCTable)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE sortAllHeaderRows(@Nonnull Comparator<? super HCRow> comparator) {
        this.getHead().sortAllChildren(comparator);
        return (IMPLTYPE)((IHCTable)this.thisAsT());
    }

    @Nullable
    default public String getFooterID() {
        return this.getFoot().getID();
    }

    @Nonnull
    default public IMPLTYPE setFooterID(@Nullable String string) {
        this.getFoot().setID(string);
        return (IMPLTYPE)((IHCTable)this.thisAsT());
    }

    default public boolean hasFooterID() {
        return this.getFoot().hasID();
    }

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsSet<ICSSClassProvider> getAllFooterClasses() {
        return this.getFoot().getAllClasses();
    }

    @Nonnull
    default public String getAllFooterClassesAsString() {
        return this.getFoot().getAllClassesAsString();
    }

    @Nonnull
    default public IMPLTYPE addFooterClass(@Nonnull ICSSClassProvider iCSSClassProvider) {
        this.getFoot().addClass(iCSSClassProvider);
        return (IMPLTYPE)((IHCTable)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE removeFooterClass(@Nonnull ICSSClassProvider iCSSClassProvider) {
        this.getFoot().removeClass(iCSSClassProvider);
        return (IMPLTYPE)((IHCTable)this.thisAsT());
    }

    default public boolean hasFooterClasses() {
        return this.getFoot().hasAnyClass();
    }

    default public boolean hasFooterRows() {
        return this.getFoot().hasChildren();
    }

    @Nonnegative
    default public int getFooterRowCount() {
        return this.getFoot().getChildCount();
    }

    @Nullable
    default public HCRow getFirstFooterRow() {
        return (HCRow)this.getFoot().getFirstChild();
    }

    @Nullable
    default public HCRow getFooterRowAtIndex(@Nonnegative int n) {
        return (HCRow)this.getFoot().getChildAtIndex(n);
    }

    @Nullable
    default public HCRow getLastFooterRow() {
        return (HCRow)this.getFoot().getLastChild();
    }

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsList<HCRow> getAllFooterRows() {
        return this.getFoot().getAllChildren();
    }

    @Nonnull
    default public HCRow addFooterRow() {
        return this.getFoot().addRow();
    }

    @Nonnull
    default public HCRow addFooterRowAt(@Nonnegative int n) {
        return this.getFoot().addRowAt(n);
    }

    @Nonnull
    default public IMPLTYPE addFooterRow(@Nullable HCRow hCRow) {
        this.getFoot().addChild(hCRow);
        return (IMPLTYPE)((IHCTable)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE addFooterRowAt(@Nonnegative int n, @Nullable HCRow hCRow) {
        this.getFoot().addChildAt(n, hCRow);
        return (IMPLTYPE)((IHCTable)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE removeFooterRowAt(@Nonnegative int n) {
        this.getFoot().removeChildAt(n);
        return (IMPLTYPE)((IHCTable)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE removeAllFooterRows() {
        this.getFoot().removeAllChildren();
        return (IMPLTYPE)((IHCTable)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE sortAllFooterRows(@Nonnull Comparator<? super HCRow> comparator) {
        this.getFoot().sortAllChildren(comparator);
        return (IMPLTYPE)((IHCTable)this.thisAsT());
    }

    @Nullable
    default public String getBodyID() {
        return this.getBody().getID();
    }

    @Nonnull
    default public IMPLTYPE setBodyID(@Nullable String string) {
        this.getBody().setID(string);
        return (IMPLTYPE)((IHCTable)this.thisAsT());
    }

    default public boolean hasBodyID() {
        return this.getBody().hasID();
    }

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsSet<ICSSClassProvider> getAllBodyClasses() {
        return this.getBody().getAllClasses();
    }

    @Nonnull
    default public String getAllBodyClassesAsString() {
        return this.getBody().getAllClassesAsString();
    }

    @Nonnull
    default public IMPLTYPE addBodyClass(@Nonnull ICSSClassProvider iCSSClassProvider) {
        this.getBody().addClass(iCSSClassProvider);
        return (IMPLTYPE)((IHCTable)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE removeBodyClass(@Nonnull ICSSClassProvider iCSSClassProvider) {
        this.getBody().removeClass(iCSSClassProvider);
        return (IMPLTYPE)((IHCTable)this.thisAsT());
    }

    default public boolean hasBodyClasses() {
        return this.getBody().hasAnyClass();
    }

    default public boolean hasBodyRows() {
        return this.getBody().hasChildren();
    }

    @Nonnegative
    default public int getBodyRowCount() {
        return this.getBody().getChildCount();
    }

    @Nullable
    default public HCRow getFirstBodyRow() {
        return (HCRow)this.getBody().getFirstChild();
    }

    @Nullable
    default public HCRow getBodyRowAtIndex(@Nonnegative int n) {
        return (HCRow)this.getBody().getChildAtIndex(n);
    }

    @Nullable
    default public HCRow getLastBodyRow() {
        return (HCRow)this.getBody().getLastChild();
    }

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsList<HCRow> getAllBodyRows() {
        return this.getBody().getAllChildren();
    }

    @Nonnull
    default public HCRow addBodyRow() {
        return this.getBody().addRow();
    }

    @Nonnull
    default public HCRow addBodyRowAt(@Nonnegative int n) {
        return this.getBody().addRowAt(n);
    }

    @Nonnull
    default public IMPLTYPE addBodyRow(@Nullable HCRow hCRow) {
        this.getBody().addChild(hCRow);
        return (IMPLTYPE)((IHCTable)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE addBodyRowAt(@Nonnegative int n, @Nullable HCRow hCRow) {
        this.getBody().addChildAt(n, hCRow);
        return (IMPLTYPE)((IHCTable)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE removeBodyRowAt(@Nonnegative int n) {
        this.getBody().removeChildAt(n);
        return (IMPLTYPE)((IHCTable)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE removeAllBodyRows() {
        this.getBody().removeAllChildren();
        return (IMPLTYPE)((IHCTable)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE sortAllBodyRows(@Nonnull Comparator<? super HCRow> comparator) {
        this.getBody().sortAllChildren(comparator);
        return (IMPLTYPE)((IHCTable)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE setSpanningHeaderContent(@Nullable String string) {
        return this.setSpanningHeaderContent(HCTextNode.createOnDemand(string));
    }

    @Nonnull
    default public IMPLTYPE setSpanningHeaderContent(@Nullable IHCNode iHCNode) {
        this.removeAllHeaderRows();
        return this.addSpanningHeaderContent(iHCNode);
    }

    @Nonnull
    default public IMPLTYPE addSpanningHeaderContent(@Nullable String string) {
        return this.addSpanningHeaderContent(HCTextNode.createOnDemand(string));
    }

    @Nonnull
    default public IMPLTYPE addSpanningHeaderContent(@Nullable IHCNode iHCNode) {
        this.addHeaderRow().addAndReturnCell(iHCNode).setColspan(this.getColumnCount());
        return (IMPLTYPE)((IHCTable)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE addSpanningBodyContent(@Nullable String string) {
        return this.addSpanningBodyContent(HCTextNode.createOnDemand(string));
    }

    @Nonnull
    default public IMPLTYPE addSpanningBodyContent(@Nullable IHCNode iHCNode) {
        this.addBodyRow().addAndReturnCell(iHCNode).setColspan(this.getColumnCount());
        return (IMPLTYPE)((IHCTable)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE setSpanningFooterContent(@Nullable String string) {
        return this.setSpanningFooterContent(HCTextNode.createOnDemand(string));
    }

    @Nonnull
    default public IMPLTYPE setSpanningFooterContent(@Nullable IHCNode iHCNode) {
        this.removeAllFooterRows();
        return this.addSpanningFooterContent(iHCNode);
    }

    @Nonnull
    default public IMPLTYPE addSpanningFooterContent(@Nullable String string) {
        return this.addSpanningFooterContent(HCTextNode.createOnDemand(string));
    }

    @Nonnull
    default public IMPLTYPE addSpanningFooterContent(@Nullable IHCNode iHCNode) {
        this.addFooterRow().addAndReturnCell(iHCNode).setColspan(this.getColumnCount());
        return (IMPLTYPE)((IHCTable)this.thisAsT());
    }

    public void checkInternalConsistency();
}

