/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.tabular;

import com.helger.annotation.CheckForSigned;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.html.AbstractHCElement;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.xml.microdom.IMicroElement;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public abstract class AbstractHCCol<IMPLTYPE extends AbstractHCCol<IMPLTYPE>>
extends AbstractHCElement<IMPLTYPE>
implements IHCCol<IMPLTYPE> {
    private String m_sWidth;
    private int m_nSpan = -1;

    public AbstractHCCol() {
        super(EHTMLElement.COL);
    }

    public AbstractHCCol(@Nonnegative int n) {
        this();
        this.setWidth(n);
    }

    @Override
    @Nullable
    public final String getWidth() {
        return this.m_sWidth;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setWidth(@Nullable String string) {
        this.m_sWidth = string;
        return (IMPLTYPE)((AbstractHCCol)this.thisAsT());
    }

    @Override
    @CheckForSigned
    public final int getSpan() {
        return this.m_nSpan;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setSpan(int n) {
        this.m_nSpan = n;
        return (IMPLTYPE)((AbstractHCCol)this.thisAsT());
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void fillMicroElement(IMicroElement iMicroElement, IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        if (StringHelper.isNotEmpty((String)this.m_sWidth)) {
            iMicroElement.setAttribute(CHTMLAttributes.WIDTH, this.m_sWidth);
        }
        if (this.m_nSpan > 0) {
            iMicroElement.setAttribute(CHTMLAttributes.SPAN, this.m_nSpan);
        }
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).appendIfNotNull("width", (Object)this.m_sWidth).append("span", this.m_nSpan).getToString();
    }
}

