/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.metadata;

import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.html.AbstractHCElement;
import com.helger.html.hc.html.HC_Target;
import com.helger.url.ISimpleURL;
import com.helger.xml.microdom.IMicroElement;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class HCBase
extends AbstractHCElement<HCBase> {
    private ISimpleURL m_aHref;
    private HC_Target m_aTarget;

    public HCBase() {
        super(EHTMLElement.BASE);
    }

    @Nullable
    public final ISimpleURL getHref() {
        return this.m_aHref;
    }

    @Nonnull
    public final HCBase setHref(@Nullable ISimpleURL iSimpleURL) {
        this.m_aHref = iSimpleURL;
        return this;
    }

    @Nullable
    public final HC_Target getTarget() {
        return this.m_aTarget;
    }

    @Nonnull
    public final HCBase setTarget(@Nullable HC_Target hC_Target) {
        this.m_aTarget = hC_Target;
        return this;
    }

    @Override
    public boolean canConvertToMicroNode(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        return this.m_aHref != null || this.m_aTarget != null;
    }

    @Override
    protected void fillMicroElement(IMicroElement iMicroElement, IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        if (this.m_aHref != null) {
            iMicroElement.setAttribute(CHTMLAttributes.HREF, this.m_aHref.getWithCharset(iHCConversionSettingsToNode.getCharset()).getAsString());
        }
        if (this.m_aTarget != null) {
            iMicroElement.setAttribute(CHTMLAttributes.TARGET, this.m_aTarget.getAttrValue());
        }
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("href", (Object)this.m_aHref).append("target", (Object)this.m_aTarget).getToString();
    }
}

