/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.links;

import com.helger.annotation.Nonempty;
import com.helger.base.lang.EnumHelper;
import com.helger.base.string.StringHelper;
import com.helger.html.hc.html.IHCHasHTMLAttributeValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public enum EHCReferrerPolicy implements IHCHasHTMLAttributeValue
{
    NONE(""),
    NO_REFERRER("no-referrer"),
    NO_REFERRER_WHEN_DOWNGRADE("no-referrer-when-downgrade"),
    SAME_ORIGIN("same-origin"),
    ORIGIN("origin"),
    STRICT_ORIGIN("strict-origin"),
    ORIGIN_WHEN_CROSS_ORIGIN("origin-when-cross-origin"),
    STRICT_ORIGIN_WHEN_CROSS_ORIGIN("strict-origin-when-cross-origin"),
    UNSAFE_URL("unsafe-url");

    @Nonnull
    public static final EHCReferrerPolicy DEFAULT;
    private final String m_sAttrValue;

    private EHCReferrerPolicy(String string2) {
        this.m_sAttrValue = string2;
    }

    @Nonnull
    @Nonempty
    public String getAttrValue() {
        return this.m_sAttrValue;
    }

    @Nullable
    public static EHCReferrerPolicy getFromAttrValueOrNull(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        return (EHCReferrerPolicy)EnumHelper.findFirst(EHCReferrerPolicy.class, eHCReferrerPolicy -> eHCReferrerPolicy.hasAttrValue(string));
    }

    static {
        DEFAULT = STRICT_ORIGIN_WHEN_CROSS_ORIGIN;
    }
}

