/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.forms;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.forms.IHCControl;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.function.Consumer;

@Immutable
public final class HCCtrlHelper {
    private HCCtrlHelper() {
    }

    @Nullable
    public static IHCControl<?> getFirstHCControl(@Nullable IHCNode iHCNode) {
        if (iHCNode != null) {
            if (iHCNode instanceof IHCControl) {
                return (IHCControl)iHCNode;
            }
            if (iHCNode.hasChildren()) {
                for (IHCNode iHCNode2 : iHCNode.getAllChildren()) {
                    IHCControl<?> iHCControl = HCCtrlHelper.getFirstHCControl(iHCNode2);
                    if (iHCControl == null) continue;
                    return iHCControl;
                }
            }
        }
        return null;
    }

    public static void getAllHCControls(@Nullable IHCNode iHCNode2, @Nonnull Consumer<? super IHCControl<?>> consumer) {
        ValueEnforcer.notNull(consumer, (String)"Consumer");
        if (iHCNode2 != null) {
            if (iHCNode2 instanceof IHCControl) {
                consumer.accept((IHCControl)iHCNode2);
            }
            iHCNode2.forAllChildren(iHCNode -> HCCtrlHelper.getAllHCControls(iHCNode, consumer));
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<IHCControl<?>> getAllHCControls(@Nullable IHCNode iHCNode) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        HCCtrlHelper.getAllHCControls(iHCNode, arg_0 -> ((ICommonsList)commonsArrayList).add(arg_0));
        return commonsArrayList;
    }

    public static void getAllHCControls(@Nullable Iterable<? extends IHCNode> iterable, @Nonnull Consumer<? super IHCControl<?>> consumer) {
        ValueEnforcer.notNull(consumer, (String)"TargetList");
        if (iterable != null) {
            for (IHCNode iHCNode : iterable) {
                HCCtrlHelper.getAllHCControls(iHCNode, consumer);
            }
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<IHCControl<?>> getAllHCControls(@Nullable Iterable<? extends IHCNode> iterable) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        HCCtrlHelper.getAllHCControls(iterable, arg_0 -> ((ICommonsList)commonsArrayList).add(arg_0));
        return commonsArrayList;
    }
}

