/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.hc.html.IHCHasHTMLAttributeValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.function.Function;

@Immutable
public class HC_Target
implements IHCHasHTMLAttributeValue {
    public static final HC_Target BLANK = new HC_Target("_blank");
    public static final HC_Target SELF = new HC_Target("_self");
    public static final HC_Target PARENT = new HC_Target("_parent");
    public static final HC_Target TOP = new HC_Target("_top");
    private final String m_sName;

    public HC_Target(@Nonnull @Nonempty String string) {
        this.m_sName = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
    }

    @Nonnull
    @Nonempty
    public final String getName() {
        return this.m_sName;
    }

    @Nonnull
    @Nonempty
    public final String getAttrValue() {
        return this.getName();
    }

    public String toString() {
        return new ToStringGenerator((Object)super.toString()).append("name", (Object)this.m_sName).getToString();
    }

    @Nullable
    public static HC_Target getFromName(@Nonnull String string2, @Nullable HC_Target hC_Target) {
        return HC_Target.getFromName(string2, (String string) -> hC_Target);
    }

    @Nullable
    public static HC_Target getFromName(@Nonnull String string, @Nonnull Function<String, ? extends HC_Target> function) {
        if (BLANK.getAttrValue().equalsIgnoreCase(string)) {
            return BLANK;
        }
        if (SELF.getAttrValue().equalsIgnoreCase(string)) {
            return SELF;
        }
        if (PARENT.getAttrValue().equalsIgnoreCase(string)) {
            return PARENT;
        }
        if (TOP.getAttrValue().equalsIgnoreCase(string)) {
            return TOP;
        }
        return function.apply(string);
    }
}

