/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EContinue;
import com.helger.base.wrapper.Wrapper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.HCHelper;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.IHCElement;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@Immutable
public final class HCHTMLHelper {
    private HCHTMLHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<IHCElement<?>> recursiveGetAllChildrenWithTagName(@Nonnull IHCNode iHCNode, EHTMLElement ... eHTMLElementArray) {
        ValueEnforcer.notNull((Object)iHCNode, (String)"Owner");
        ValueEnforcer.notEmpty((Object[])eHTMLElementArray, (String)"Elements");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        HCHelper.iterateChildrenNonBreakable(iHCNode, (arg_0, arg_1) -> HCHTMLHelper.lambda$recursiveGetAllChildrenWithTagName$0(eHTMLElementArray, (ICommonsList)commonsArrayList, arg_0, arg_1));
        return commonsArrayList;
    }

    @Nullable
    public static IHCElement<?> recursiveGetFirstChildWithDifferentTagName(@Nonnull IHCNode iHCNode3, EHTMLElement ... eHTMLElementArray) {
        ValueEnforcer.notNull((Object)iHCNode3, (String)"Owner");
        ValueEnforcer.notEmpty((Object[])eHTMLElementArray, (String)"Elements");
        Wrapper wrapper = new Wrapper();
        HCHelper.iterateChildrenNoCopy(iHCNode3, (iHCNode, iHCNode2) -> {
            if (iHCNode2 instanceof IHCElement) {
                IHCElement iHCElement = (IHCElement)iHCNode2;
                String string = iHCElement.getTagName();
                boolean bl = false;
                for (EHTMLElement eHTMLElement : eHTMLElementArray) {
                    if (!string.equalsIgnoreCase(eHTMLElement.getElementName())) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    wrapper.set((Object)iHCElement);
                    return EContinue.BREAK;
                }
            }
            return EContinue.CONTINUE;
        });
        return (IHCElement)wrapper.get();
    }

    public static boolean recursiveContainsChildWithDifferentTagName(@Nonnull IHCNode iHCNode, EHTMLElement ... eHTMLElementArray) {
        return HCHTMLHelper.recursiveGetFirstChildWithDifferentTagName(iHCNode, eHTMLElementArray) != null;
    }

    @Nullable
    public static IHCElement<?> recursiveGetFirstChildWithTagName(@Nonnull IHCNode iHCNode3, EHTMLElement ... eHTMLElementArray) {
        ValueEnforcer.notNull((Object)iHCNode3, (String)"Owner");
        ValueEnforcer.notEmpty((Object[])eHTMLElementArray, (String)"Elements");
        Wrapper wrapper = new Wrapper();
        HCHelper.iterateChildrenNoCopy(iHCNode3, (iHCNode, iHCNode2) -> {
            if (iHCNode2 instanceof IHCElement) {
                IHCElement iHCElement = (IHCElement)iHCNode2;
                String string = iHCElement.getTagName();
                for (EHTMLElement eHTMLElement : eHTMLElementArray) {
                    if (!string.equalsIgnoreCase(eHTMLElement.getElementName())) continue;
                    wrapper.set((Object)iHCElement);
                    return EContinue.BREAK;
                }
            }
            return EContinue.CONTINUE;
        });
        return (IHCElement)wrapper.get();
    }

    public static boolean recursiveContainsChildWithTagName(@Nonnull IHCNode iHCNode, EHTMLElement ... eHTMLElementArray) {
        return HCHTMLHelper.recursiveGetFirstChildWithTagName(iHCNode, eHTMLElementArray) != null;
    }

    private static /* synthetic */ void lambda$recursiveGetAllChildrenWithTagName$0(EHTMLElement[] eHTMLElementArray, ICommonsList iCommonsList, IHCNode iHCNode, IHCNode iHCNode2) {
        if (iHCNode2 instanceof IHCElement) {
            IHCElement iHCElement = (IHCElement)iHCNode2;
            String string = iHCElement.getTagName();
            for (EHTMLElement eHTMLElement : eHTMLElementArray) {
                if (!string.equalsIgnoreCase(eHTMLElement.getElementName())) continue;
                iCommonsList.add((Object)iHCElement);
                break;
            }
        }
    }
}

