/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.ext;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.property.ECSSProperty;
import com.helger.css.propertyvalue.ICSSValue;
import com.helger.html.hc.html.IHCHasCSSStyles;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class HCHasCSSStyles
implements IHCHasCSSStyles<HCHasCSSStyles> {
    private ICommonsOrderedMap<ECSSProperty, ICSSValue> m_aStyles;

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsOrderedMap<ECSSProperty, ICSSValue> getAllStyles() {
        return this.m_aStyles.getClone();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<ICSSValue> getAllStyleValues() {
        return this.m_aStyles == null ? new CommonsArrayList() : new CommonsArrayList(this.m_aStyles.values());
    }

    @Override
    @Nullable
    public final ICSSValue getStyleValue(@Nullable ECSSProperty eCSSProperty) {
        return eCSSProperty == null || this.m_aStyles == null ? null : (ICSSValue)this.m_aStyles.get((Object)eCSSProperty);
    }

    @Override
    public final boolean containsStyle(@Nullable ECSSProperty eCSSProperty) {
        return this.m_aStyles != null && this.m_aStyles.containsKey((Object)eCSSProperty);
    }

    @Override
    public final boolean hasStyle(@Nullable ICSSValue iCSSValue) {
        if (iCSSValue == null || this.m_aStyles == null) {
            return false;
        }
        ECSSProperty eCSSProperty = iCSSValue.getProp();
        return EqualsHelper.equals((Object)this.m_aStyles.get((Object)eCSSProperty), (Object)iCSSValue);
    }

    @Override
    public final boolean hasAnyStyle() {
        return this.m_aStyles != null && !this.m_aStyles.isEmpty();
    }

    @Override
    @Nonnull
    public final HCHasCSSStyles addStyle(@Nullable ICSSValue iCSSValue) {
        if (iCSSValue != null) {
            if (this.m_aStyles == null) {
                this.m_aStyles = new CommonsLinkedHashMap();
            }
            this.m_aStyles.put((Object)iCSSValue.getProp(), (Object)iCSSValue);
        }
        return this;
    }

    @Override
    @Nonnull
    public final HCHasCSSStyles removeStyle(@Nonnull ECSSProperty eCSSProperty) {
        if (this.m_aStyles != null) {
            this.m_aStyles.remove((Object)eCSSProperty);
        }
        return this;
    }

    @Override
    @Nonnull
    public final HCHasCSSStyles removeAllStyles() {
        this.m_aStyles.clear();
        return this;
    }

    @Override
    @Nullable
    public final String getAllStylesAsString(@Nonnull ICSSWriterSettings iCSSWriterSettings) {
        if (this.m_aStyles == null || this.m_aStyles.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (ICSSValue iCSSValue : this.m_aStyles.values()) {
            stringBuilder.append(iCSSValue.getAsCSSString(iCSSWriterSettings, 0));
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIf("Styles", this.m_aStyles, CollectionHelper::isNotEmpty).getToString();
    }
}

