/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.config;

import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.debug.GlobalDebug;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.log.ConditionalLogger;
import com.helger.base.spi.ServiceLoaderHelper;
import com.helger.base.system.ENewLineMode;
import com.helger.html.EHTMLVersion;
import com.helger.html.hc.IHCConversionSettings;
import com.helger.html.hc.config.DefaultHCOnDocumentReadyProvider;
import com.helger.html.hc.config.EHCScriptInlineMode;
import com.helger.html.hc.config.EHCStyleInlineMode;
import com.helger.html.hc.config.HCConversionSettings;
import com.helger.html.hc.config.IHCOnDocumentReadyProvider;
import com.helger.html.hc.config.IHCSettingsProviderSPI;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import jakarta.annotation.Nonnull;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class HCSettings {
    public static final EHTMLVersion DEFAULT_HTML_VERSION = EHTMLVersion.HTML5;
    public static final boolean DEFAULT_AUTO_COMPLETE_OFF_FOR_PASSWORD_EDITS = !GlobalDebug.isDebugMode();
    public static final EHCScriptInlineMode DEFAULT_SCRIPT_INLINE_MODE = EHCScriptInlineMode.PLAIN_TEXT_NO_ESCAPE;
    public static final EHCStyleInlineMode DEFAULT_STYLE_MODE = EHCStyleInlineMode.PLAIN_TEXT_NO_ESCAPE;
    public static final boolean DEFAULT_OUT_OF_BAND_NODE_DEBUGGING = false;
    public static final boolean DEFAULT_SCRIPTS_IN_BODY = true;
    public static final boolean DEFAULT_USE_NONCE_ATTRIBUTES_IN_SCRIPTS = false;
    public static final boolean DEFAULT_USE_NONCE_ATTRIBUTES_IN_STYLES = false;
    public static final boolean DEFAULT_USE_REGULAR_RESOURCES = GlobalDebug.isDebugMode();
    private static final Logger LOGGER = LoggerFactory.getLogger(HCSettings.class);
    private static final ConditionalLogger CONDLOG = new ConditionalLogger(LOGGER, false);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static HCConversionSettings s_aConversionSettings = new HCConversionSettings(DEFAULT_HTML_VERSION);
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bAutoCompleteOffForPasswordEdits = DEFAULT_AUTO_COMPLETE_OFF_FOR_PASSWORD_EDITS;
    @GuardedBy(value="RW_LOCK")
    private static int s_nTextAreaDefaultRows = -1;
    @GuardedBy(value="RW_LOCK")
    private static IHCOnDocumentReadyProvider s_aOnDocumentReadyProvider = new DefaultHCOnDocumentReadyProvider();
    @GuardedBy(value="RW_LOCK")
    private static EHCScriptInlineMode s_eScriptInlineMode = DEFAULT_SCRIPT_INLINE_MODE;
    @GuardedBy(value="RW_LOCK")
    private static EHCStyleInlineMode s_eStyleInlineMode = DEFAULT_STYLE_MODE;
    @GuardedBy(value="RW_LOCK")
    private static ENewLineMode s_eNewLineMode = ENewLineMode.DEFAULT;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bOOBDebugging = false;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bScriptsInBody = true;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bUseRegularResources = DEFAULT_USE_REGULAR_RESOURCES;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bUseNonceInScript = false;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bUseNonceInStyle = false;

    private HCSettings() {
    }

    public static boolean isSilentMode() {
        return CONDLOG.isDisabled();
    }

    public static boolean setSilentMode(boolean bl) {
        return !CONDLOG.setEnabled(!bl);
    }

    public static void setConversionSettings(@Nonnull HCConversionSettings hCConversionSettings) {
        ValueEnforcer.notNull((Object)hCConversionSettings, (String)"ConversionSettings");
        RW_LOCK.writeLocked(() -> {
            s_aConversionSettings = hCConversionSettings;
        });
    }

    @Nonnull
    @ReturnsMutableObject
    public static HCConversionSettings getMutableConversionSettings() {
        return (HCConversionSettings)RW_LOCK.readLockedGet(() -> s_aConversionSettings);
    }

    @Nonnull
    public static IHCConversionSettings getConversionSettings() {
        return HCSettings.getMutableConversionSettings();
    }

    @Nonnull
    public static HCConversionSettings getConversionSettingsWithoutNamespaces() {
        HCConversionSettings hCConversionSettings = HCSettings.getMutableConversionSettings().getClone();
        hCConversionSettings.getXMLWriterSettings().setEmitNamespaces(false);
        return hCConversionSettings;
    }

    @Nonnull
    public static Charset getHTMLCharset() {
        return HCSettings.getConversionSettings().getXMLWriterSettings().getCharset();
    }

    public static void setDefaultHTMLVersion(@Nonnull EHTMLVersion eHTMLVersion) {
        ValueEnforcer.notNull((Object)((Object)eHTMLVersion), (String)"HTMLVersion");
        EHTMLVersion eHTMLVersion2 = HCSettings.getConversionSettings().getHTMLVersion();
        HCSettings.getMutableConversionSettings().setHTMLVersion(eHTMLVersion);
        HCSettings.getMutableConversionSettings().setXMLWriterSettings((IXMLWriterSettings)HCConversionSettings.createDefaultXMLWriterSettings(eHTMLVersion));
        if (!eHTMLVersion.equals((Object)eHTMLVersion2)) {
            CONDLOG.info(() -> "Default HTML version changed from " + String.valueOf((Object)eHTMLVersion2) + " to " + String.valueOf((Object)eHTMLVersion));
        }
        if (eHTMLVersion.isAtLeastHTML5()) {
            if (HCSettings.getScriptInlineMode() != EHCScriptInlineMode.PLAIN_TEXT_NO_ESCAPE) {
                HCSettings.setScriptInlineMode(EHCScriptInlineMode.PLAIN_TEXT_NO_ESCAPE);
            }
        } else if (HCSettings.getScriptInlineMode() != DEFAULT_SCRIPT_INLINE_MODE) {
            HCSettings.setScriptInlineMode(DEFAULT_SCRIPT_INLINE_MODE);
        }
    }

    public static boolean isAutoCompleteOffForPasswordEdits() {
        return RW_LOCK.readLockedBoolean(() -> s_bAutoCompleteOffForPasswordEdits);
    }

    public static void setAutoCompleteOffForPasswordEdits(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bAutoCompleteOffForPasswordEdits = bl;
        });
        CONDLOG.info(() -> "Default @autocomplete for <input type=password> set to " + (bl ? "off" : "on"));
    }

    public static int getTextAreaDefaultRows() {
        return RW_LOCK.readLockedInt(() -> s_nTextAreaDefaultRows);
    }

    public static void setTextAreaDefaultRows(int n) {
        RW_LOCK.writeLocked(() -> {
            s_nTextAreaDefaultRows = n;
        });
        CONDLOG.info(() -> "Default <textarea> rows set to " + n);
    }

    @Nonnull
    public static IHCOnDocumentReadyProvider getOnDocumentReadyProvider() {
        return (IHCOnDocumentReadyProvider)RW_LOCK.readLockedGet(() -> s_aOnDocumentReadyProvider);
    }

    public static void setOnDocumentReadyProvider(@Nonnull IHCOnDocumentReadyProvider iHCOnDocumentReadyProvider) {
        ValueEnforcer.notNull((Object)iHCOnDocumentReadyProvider, (String)"OnDocumentReadyProvider");
        RW_LOCK.writeLocked(() -> {
            s_aOnDocumentReadyProvider = iHCOnDocumentReadyProvider;
        });
        CONDLOG.info(() -> "Default JS onDocumentReady provider set to " + String.valueOf(iHCOnDocumentReadyProvider));
    }

    @Nonnull
    public static EHCScriptInlineMode getScriptInlineMode() {
        return (EHCScriptInlineMode)((Object)RW_LOCK.readLockedGet(() -> s_eScriptInlineMode));
    }

    public static void setScriptInlineMode(@Nonnull EHCScriptInlineMode eHCScriptInlineMode) {
        ValueEnforcer.notNull((Object)((Object)eHCScriptInlineMode), (String)"Mode");
        EHCScriptInlineMode eHCScriptInlineMode2 = HCSettings.getScriptInlineMode();
        RW_LOCK.writeLocked(() -> {
            s_eScriptInlineMode = eHCScriptInlineMode;
        });
        if (!eHCScriptInlineMode.equals((Object)eHCScriptInlineMode2)) {
            CONDLOG.info(() -> "Default <script> mode changed from " + String.valueOf((Object)eHCScriptInlineMode2) + " to " + String.valueOf((Object)eHCScriptInlineMode));
        }
    }

    @Nonnull
    public static EHCStyleInlineMode getStyleInlineMode() {
        return (EHCStyleInlineMode)((Object)RW_LOCK.readLockedGet(() -> s_eStyleInlineMode));
    }

    public static void setStyleInlineMode(@Nonnull EHCStyleInlineMode eHCStyleInlineMode) {
        ValueEnforcer.notNull((Object)((Object)eHCStyleInlineMode), (String)"mode");
        EHCStyleInlineMode eHCStyleInlineMode2 = HCSettings.getStyleInlineMode();
        RW_LOCK.writeLocked(() -> {
            s_eStyleInlineMode = eHCStyleInlineMode;
        });
        if (!eHCStyleInlineMode.equals((Object)eHCStyleInlineMode2)) {
            CONDLOG.info(() -> "Default <style> mode changed from " + String.valueOf((Object)eHCStyleInlineMode2) + " to " + String.valueOf((Object)eHCStyleInlineMode));
        }
    }

    @Nonnull
    public static ENewLineMode getNewLineMode() {
        return (ENewLineMode)RW_LOCK.readLockedGet(() -> s_eNewLineMode);
    }

    public static void setNewLineMode(@Nonnull ENewLineMode eNewLineMode) {
        ValueEnforcer.notNull((Object)eNewLineMode, (String)"NewLineMode");
        ENewLineMode eNewLineMode2 = HCSettings.getNewLineMode();
        RW_LOCK.writeLocked(() -> {
            s_eNewLineMode = eNewLineMode;
        });
        if (!eNewLineMode.equals((Object)eNewLineMode2)) {
            CONDLOG.info(() -> "Default new line mode changed from " + String.valueOf(eNewLineMode2) + " to " + String.valueOf(eNewLineMode));
        }
    }

    public static boolean isOutOfBandDebuggingEnabled() {
        return RW_LOCK.readLockedBoolean(() -> s_bOOBDebugging);
    }

    public static void setOutOfBandDebuggingEnabled(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bOOBDebugging = bl;
        });
        CONDLOG.info(() -> "Default out-of-band debugging " + (bl ? "enabled" : "disabled"));
    }

    public static boolean isScriptsInBody() {
        return RW_LOCK.readLockedBoolean(() -> s_bScriptsInBody);
    }

    public static void setScriptsInBody(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bScriptsInBody = bl;
        });
        CONDLOG.info(() -> "Default put <scripts>s in " + (bl ? "<body>" : "<head>"));
    }

    public static boolean isUseRegularResources() {
        return RW_LOCK.readLockedBoolean(() -> s_bUseRegularResources);
    }

    public static void setUseRegularResources(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bUseRegularResources = bl;
        });
        CONDLOG.info(() -> "Default using " + (bl ? "regular" : "minified") + " resources");
    }

    public static boolean isUseNonceInScript() {
        return RW_LOCK.readLockedBoolean(() -> s_bUseNonceInScript);
    }

    public static void setUseNonceInScript(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bUseNonceInScript = bl;
        });
        CONDLOG.info(() -> "The 'nonce' attribute will" + (bl ? "" : " not") + " be used for <script> elements");
    }

    public static boolean isUseNonceInStyle() {
        return RW_LOCK.readLockedBoolean(() -> s_bUseNonceInStyle);
    }

    public static void setUseNonceInStyle(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bUseNonceInStyle = bl;
        });
        CONDLOG.info(() -> "The 'nonce' attribute will" + (bl ? "" : " not") + " be used for <style> elements");
    }

    static {
        for (IHCSettingsProviderSPI iHCSettingsProviderSPI : ServiceLoaderHelper.getAllSPIImplementations(IHCSettingsProviderSPI.class)) {
            iHCSettingsProviderSPI.initHCSettings();
        }
    }
}

