/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc;

import com.helger.annotation.CheckReturnValue;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.misc.DevelopersNote;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.trait.IGenericImplTrait;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.IHCNodeList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Comparator;

public interface IHCHasChildrenMutable<IMPLTYPE extends IHCHasChildrenMutable<IMPLTYPE, CHILDTYPE>, CHILDTYPE extends IHCNode>
extends IHCNode,
IGenericImplTrait<IMPLTYPE> {
    @Nonnull
    public IMPLTYPE addChild(@Nullable CHILDTYPE var1);

    @Nonnull
    default public IMPLTYPE setChild(@Nullable CHILDTYPE CHILDTYPE) {
        this.removeAllChildren();
        return this.addChild(CHILDTYPE);
    }

    @Nonnull
    public IMPLTYPE addChildAt(@Nonnegative int var1, @Nullable CHILDTYPE var2);

    @Deprecated(forRemoval=false)
    @DevelopersNote(value="Use addChild instead")
    default public IMPLTYPE addChildren(@Nullable CHILDTYPE CHILDTYPE) {
        return this.addChild(CHILDTYPE);
    }

    @Nonnull
    default public IMPLTYPE addChildren(CHILDTYPE ... CHILDTYPEArray) {
        if (CHILDTYPEArray != null) {
            for (CHILDTYPE CHILDTYPE : CHILDTYPEArray) {
                this.addChild(CHILDTYPE);
            }
        }
        return (IMPLTYPE)((IHCHasChildrenMutable)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE addChildrenAt(@Nonnegative int n, CHILDTYPE ... CHILDTYPEArray) {
        ValueEnforcer.isBetweenInclusive((int)n, (String)"Index", (int)0, (int)this.getChildCount());
        if (CHILDTYPEArray != null) {
            int n2 = n;
            for (CHILDTYPE CHILDTYPE : CHILDTYPEArray) {
                this.addChildAt(n2++, CHILDTYPE);
            }
        }
        return (IMPLTYPE)((IHCHasChildrenMutable)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE addChildren(@Nullable Iterable<? extends CHILDTYPE> iterable) {
        if (iterable != null) {
            for (IHCNode iHCNode : iterable) {
                this.addChild(iHCNode);
            }
        }
        return (IMPLTYPE)((IHCHasChildrenMutable)this.thisAsT());
    }

    @Nonnull
    default public IMPLTYPE addChildrenAt(@Nonnegative int n, @Nullable Iterable<? extends CHILDTYPE> iterable) {
        ValueEnforcer.isBetweenInclusive((int)n, (String)"Index", (int)0, (int)this.getChildCount());
        if (iterable != null) {
            int n2 = n;
            for (IHCNode iHCNode : iterable) {
                this.addChildAt(n2++, iHCNode);
            }
        }
        return (IMPLTYPE)((IHCHasChildrenMutable)this.thisAsT());
    }

    @Nullable
    @CheckReturnValue
    default public <V extends CHILDTYPE> V addAndReturnChild(@Nullable V v) {
        this.addChild(v);
        return v;
    }

    @Nullable
    @CheckReturnValue
    default public <V extends CHILDTYPE> V addAndReturnChildAt(@Nonnegative int n, @Nullable V v) {
        this.addChildAt(n, v);
        return v;
    }

    @Nonnull
    public IMPLTYPE removeChildAt(@Nonnegative int var1);

    @Nonnull
    public IMPLTYPE removeChild(@Nullable CHILDTYPE var1);

    @Nonnull
    public IMPLTYPE removeAllChildren();

    @Nonnull
    public IMPLTYPE sortAllChildren(@Nonnull Comparator<? super CHILDTYPE> var1);

    @Nonnull
    public IHCNodeList<?> getAllChildrenAsNodeList();
}

