/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.datatables.plugins;

import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.jquery.JQuery;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.IJSStatement;
import com.helger.html.jscode.JSAnonymousFunction;
import com.helger.html.jscode.JSAssocArray;
import com.helger.html.jscode.JSExpr;
import com.helger.html.jscode.JSLet;
import com.helger.html.jscode.JSPackage;
import com.helger.html.resource.css.ICSSPathProvider;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.photon.app.html.PhotonCSS;
import com.helger.photon.app.html.PhotonJS;
import com.helger.photon.uictrls.datatables.DataTables;
import com.helger.photon.uictrls.datatables.EDataTablesCSSPathProvider;
import com.helger.photon.uictrls.datatables.EDataTablesJSPathProvider;
import com.helger.photon.uictrls.datatables.plugins.AbstractDataTablesPlugin;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class DataTablesPluginScroller
extends AbstractDataTablesPlugin {
    public static final String PLUGIN_NAME = "scroller";
    public static final double DEFAULT_BOUNDARY_SCALE = 0.5;
    public static final int DEFAULT_DISPLAY_BUFFER = 9;
    public static final boolean DEFAULT_LOADING_INDICATOR = false;
    public static final String DEFAULT_ROW_HEIGHT = "auto";
    public static final int DEFAULT_SERVER_WAIT = 200;
    private Double m_aBoundaryScale;
    private Integer m_aDisplayBuffer;
    private boolean m_bLoadingIndicator = false;
    private String m_sRowHeight = "auto";
    private Integer m_aServerWait;

    public DataTablesPluginScroller() {
        super(PLUGIN_NAME);
    }

    @Nonnull
    public DataTablesPluginScroller setBoundaryScale(double d) {
        return this.setBoundaryScale((Double)d);
    }

    @Nonnull
    public DataTablesPluginScroller setBoundaryScale(@Nullable Double d) {
        this.m_aBoundaryScale = d;
        return this;
    }

    @Nonnull
    public DataTablesPluginScroller setDisplayBuffer(int n) {
        return this.setDisplayBuffer((Integer)n);
    }

    @Nonnull
    public DataTablesPluginScroller setDisplayBuffer(@Nullable Integer n) {
        this.m_aDisplayBuffer = n;
        return this;
    }

    @Nonnull
    public DataTablesPluginScroller setLoadingIndicator(boolean bl) {
        this.m_bLoadingIndicator = bl;
        return this;
    }

    @Nonnull
    public DataTablesPluginScroller setRowHeight(int n) {
        this.m_sRowHeight = Integer.toString(n);
        return this;
    }

    @Nonnull
    public DataTablesPluginScroller setRowHeightAuto() {
        this.m_sRowHeight = DEFAULT_ROW_HEIGHT;
        return this;
    }

    @Nonnull
    public DataTablesPluginScroller setServerWait(int n) {
        return this.setServerWait((Integer)n);
    }

    @Nonnull
    public DataTablesPluginScroller setServerWait(@Nullable Integer n) {
        this.m_aServerWait = n;
        return this;
    }

    @Override
    public boolean canBeApplied(@Nonnull DataTables dataTables) {
        return dataTables.isPaging();
    }

    @Override
    public void finalizeDataTablesSettings(@Nonnull DataTables dataTables) {
        dataTables.setDeferRender(true);
    }

    @Override
    @Nullable
    public IJSExpression getInitParams() {
        JSAssocArray jSAssocArray = new JSAssocArray();
        if (this.m_aBoundaryScale != null) {
            jSAssocArray.add("boundaryScale", this.m_aBoundaryScale.doubleValue());
        }
        if (this.m_aDisplayBuffer != null) {
            jSAssocArray.add("displayBuffer", this.m_aDisplayBuffer.intValue());
        }
        if (this.m_bLoadingIndicator) {
            jSAssocArray.add("loadingIndicator", this.m_bLoadingIndicator);
        }
        if (!this.m_sRowHeight.equals(DEFAULT_ROW_HEIGHT)) {
            jSAssocArray.add("rowHeight", this.m_sRowHeight);
        }
        if (this.m_aServerWait != null) {
            jSAssocArray.add("serverWait", this.m_aServerWait.intValue());
        }
        if (jSAssocArray.isEmpty()) {
            return JSExpr.TRUE;
        }
        return jSAssocArray;
    }

    @Override
    public void addInitJS(@Nonnull DataTables dataTables, @Nonnull JSPackage jSPackage, @Nonnull JSLet jSLet) {
        jSPackage.add((IJSStatement)JQuery.jQueryWindow().on("resize", (IJSExpression)new JSAnonymousFunction((IJSStatement)jSLet.invoke("fnAdjustColumnSizing"))));
    }

    @Override
    public void registerExternalResources(IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        PhotonCSS.registerCSSIncludeForThisRequest((ICSSPathProvider)EDataTablesCSSPathProvider.DATATABLES_SCROLLER);
        PhotonJS.registerJSIncludeForThisRequest((IJSPathProvider)EDataTablesJSPathProvider.DATATABLES_SCROLLER);
    }
}

