/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.datatables.plugins;

import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSAssocArray;
import com.helger.html.jscode.JSExpr;
import com.helger.html.resource.css.ICSSPathProvider;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.photon.app.html.PhotonCSS;
import com.helger.photon.app.html.PhotonJS;
import com.helger.photon.uictrls.datatables.EDataTablesCSSPathProvider;
import com.helger.photon.uictrls.datatables.EDataTablesJSPathProvider;
import com.helger.photon.uictrls.datatables.plugins.AbstractDataTablesPlugin;
import com.helger.photon.uictrls.datatables.plugins.EDTPFixedColumnsHeightMatch;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class DataTablesPluginFixedColumns
extends AbstractDataTablesPlugin {
    public static final String PLUGIN_NAME = "fixedColumns";
    public static final EDTPFixedColumnsHeightMatch DEFAULT_HEIGHT_MATCH = EDTPFixedColumnsHeightMatch.SEMI_AUTO;
    public static final int DEFAULT_LEFT_COLUMNS = 1;
    public static final int DEFAULT_RIGHT_COLUMNS = 0;
    private EDTPFixedColumnsHeightMatch m_eHeightMatch;
    private Integer m_aLeftColumns;
    private Integer m_aRightColumns;

    public DataTablesPluginFixedColumns() {
        super(PLUGIN_NAME);
    }

    @Nonnull
    public DataTablesPluginFixedColumns setHeightMatch(@Nullable EDTPFixedColumnsHeightMatch eDTPFixedColumnsHeightMatch) {
        this.m_eHeightMatch = eDTPFixedColumnsHeightMatch;
        return this;
    }

    @Nonnull
    public DataTablesPluginFixedColumns setLeftColumns(int n) {
        return this.setLeftColumns((Integer)n);
    }

    @Nonnull
    public DataTablesPluginFixedColumns setLeftColumns(@Nullable Integer n) {
        this.m_aLeftColumns = n;
        return this;
    }

    @Nonnull
    public DataTablesPluginFixedColumns setRightColumns(int n) {
        return this.setRightColumns((Integer)n);
    }

    @Nonnull
    public DataTablesPluginFixedColumns setRightColumns(@Nullable Integer n) {
        this.m_aRightColumns = n;
        return this;
    }

    @Override
    @Nullable
    public IJSExpression getInitParams() {
        JSAssocArray jSAssocArray = new JSAssocArray();
        if (this.m_eHeightMatch != null) {
            jSAssocArray.add("heightMatch", this.m_eHeightMatch.getName());
        }
        if (this.m_aLeftColumns != null) {
            jSAssocArray.add("leftColumns", this.m_aLeftColumns.intValue());
        }
        if (this.m_aRightColumns != null) {
            jSAssocArray.add("rightColumns", this.m_aRightColumns.intValue());
        }
        if (jSAssocArray.isEmpty()) {
            return JSExpr.TRUE;
        }
        return jSAssocArray;
    }

    @Override
    public void registerExternalResources(IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        PhotonJS.registerJSIncludeForThisRequest((IJSPathProvider)EDataTablesJSPathProvider.DATATABLES_FIXED_HEADER);
        PhotonCSS.registerCSSIncludeForThisRequest((ICSSPathProvider)EDataTablesCSSPathProvider.DATATABLES_FIXED_HEADER);
    }
}

