/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.datatables.plugins;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringReplace;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.ICommonsSet;
import com.helger.datetime.EDTType;
import com.helger.datetime.format.EDTFormatterMode;
import com.helger.datetime.format.PDTFormatter;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.IJSStatement;
import com.helger.html.jscode.JSInvocation;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.photon.app.html.PhotonJS;
import com.helger.photon.uicore.EUICoreJSPathProvider;
import com.helger.photon.uictrls.datatables.DataTables;
import com.helger.photon.uictrls.datatables.EDataTablesJSPathProvider;
import com.helger.photon.uictrls.datatables.column.EDTColType;
import com.helger.photon.uictrls.datatables.plugins.AbstractDataTablesPlugin;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.format.FormatStyle;
import java.util.Locale;
import java.util.Set;

public class DataTablesPluginClientSortingDate
extends AbstractDataTablesPlugin {
    public static final String PLUGIN_NAME = "clientSortingDate";
    private final ICommonsSet<EDTColType> m_aDateTimeTypes;

    public DataTablesPluginClientSortingDate(@Nonnull @Nonempty Set<EDTColType> set) {
        super(PLUGIN_NAME);
        ValueEnforcer.notEmptyNoNullValue(set, (String)"DateTimeTypes");
        this.m_aDateTimeTypes = new CommonsHashSet(set);
    }

    @Override
    public boolean canBeApplied(@Nonnull DataTables dataTables) {
        return dataTables.isClientSide();
    }

    @Nonnull
    private static String _fixFormatter(@Nonnull String string) {
        String string2 = string;
        string2 = StringReplace.replaceAll((String)string2, (char)'y', (char)'Y');
        string2 = StringReplace.replaceAll((String)string2, (char)'d', (char)'D');
        return string2;
    }

    @Override
    public void finalizeDataTablesSettings(@Nonnull DataTables dataTables) {
        dataTables.setJSBeforeModifier(jSPackage -> {
            Locale locale = dataTables.getDisplayLocale();
            for (EDTColType eDTColType : this.m_aDateTimeTypes) {
                EDTType eDTType = null;
                switch (eDTColType) {
                    case DATE: {
                        eDTType = EDTType.LOCAL_DATE;
                        break;
                    }
                    case TIME: {
                        eDTType = EDTType.LOCAL_TIME;
                        break;
                    }
                    case DATETIME: {
                        eDTType = EDTType.LOCAL_DATE_TIME;
                    }
                }
                if (eDTType == null) continue;
                jSPackage.add((IJSStatement)((JSInvocation)DataTables.invokeDataTablesMoment().arg(DataTablesPluginClientSortingDate._fixFormatter(PDTFormatter.getPattern((EDTType)eDTType, (Locale)locale, (FormatStyle)FormatStyle.MEDIUM, (EDTFormatterMode)EDTFormatterMode.PARSE)))).arg(locale.toString()));
            }
        });
    }

    @Override
    public void registerExternalResources(IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        PhotonJS.registerJSIncludeForThisRequest((IJSPathProvider)EUICoreJSPathProvider.MOMENT_WITH_LOCALES);
        PhotonJS.registerJSIncludeForThisRequest((IJSPathProvider)EDataTablesJSPathProvider.DATATABLES_SORTING_MOMENT);
    }

    @Override
    @Nullable
    public IJSExpression getInitParams() {
        return null;
    }
}

