/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.datatables.column;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.ext.HCHasCSSClasses;
import com.helger.html.hc.html.IHCHasCSSClasses;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSAnonymousFunction;
import com.helger.html.jscode.JSArray;
import com.helger.html.jscode.JSAssocArray;
import com.helger.html.jscode.JSExpr;
import com.helger.photon.uictrls.datatables.EDataTablesOrderDirectionType;
import com.helger.photon.uictrls.datatables.column.DTCol;
import com.helger.photon.uictrls.datatables.column.DTOrderSpec;
import com.helger.photon.uictrls.datatables.column.EDataTablesColumnType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;

public class DataTablesColumnDef
implements IHCHasCSSClasses<DataTablesColumnDef> {
    public static final String DEFAULT_CELLTYPE = "td";
    public static final boolean DEFAULT_ORDERABLE = true;
    public static final boolean DEFAULT_SEARCHABLE = true;
    public static final boolean DEFAULT_VISIBLE = true;
    private final int[] m_aTargets;
    private String m_sCellType = "td";
    private final HCHasCSSClasses m_aClassNames = new HCHasCSSClasses();
    private String m_sContentPadding;
    private JSAnonymousFunction m_aCreatedCell;
    private IJSExpression m_aData;
    private String m_sDefaultContent;
    private String m_sName;
    private boolean m_bOrderable = true;
    private int[] m_aOrderData;
    private String m_sOrderDataType;
    private ICommonsList<EDataTablesOrderDirectionType> m_aOrderSequence = new CommonsArrayList((Object[])new EDataTablesOrderDirectionType[]{EDataTablesOrderDirectionType.ASC, EDataTablesOrderDirectionType.DESC});
    private IJSExpression m_aRender;
    private boolean m_bSearchable = true;
    private String m_sTitle;
    private EDataTablesColumnType m_eType;
    private boolean m_bVisible = true;
    private String m_sWidth;
    private final DTOrderSpec m_aOrderSpec;

    public DataTablesColumnDef(@Nonnegative int n) {
        ValueEnforcer.isGE0((int)n, (String)"Target");
        this.m_aTargets = new int[]{n};
        this.m_aOrderSpec = new DTOrderSpec();
    }

    public DataTablesColumnDef(int ... nArray) {
        ValueEnforcer.notEmpty((int[])nArray, (String)"Targets");
        for (int n : nArray) {
            ValueEnforcer.isGE0((int)n, (String)"Target");
        }
        this.m_aTargets = ArrayHelper.getCopy((int[])nArray);
        this.m_aOrderSpec = new DTOrderSpec();
    }

    public DataTablesColumnDef(@Nonnegative int n, @Nonnull DTCol dTCol) {
        ValueEnforcer.isGE0((int)n, (String)"Target");
        this.m_aTargets = new int[]{n};
        this.addClasses((Iterable)dTCol.getAllClasses());
        this.setName(dTCol.getName());
        this.setOrderable(dTCol.isOrderable());
        this.setOrderData(dTCol.getDataSort());
        this.setSearchable(dTCol.isSearchable());
        this.setVisible(dTCol.isVisible());
        if (!dTCol.isVisible()) {
            this.setWidth("0");
        } else if (!dTCol.isStar()) {
            this.setWidth(dTCol.getWidth());
        }
        this.m_aOrderSpec = dTCol.getOrderSpec();
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public int[] getAllTargets() {
        return ArrayHelper.getCopy((int[])this.m_aTargets);
    }

    public boolean hasTarget(int n) {
        return ArrayHelper.contains((int[])this.m_aTargets, (int)n);
    }

    @Nonnull
    @Nonempty
    public String getCellType() {
        return this.m_sCellType;
    }

    @Nonnull
    public DataTablesColumnDef setCellType(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"CellType");
        this.m_sCellType = string;
        return this;
    }

    public boolean containsClass(@Nullable ICSSClassProvider iCSSClassProvider) {
        return this.m_aClassNames.containsClass(iCSSClassProvider);
    }

    @Nonnull
    public DataTablesColumnDef addClass(@Nullable ICSSClassProvider iCSSClassProvider) {
        this.m_aClassNames.addClass(iCSSClassProvider);
        return this;
    }

    @Nonnull
    public DataTablesColumnDef removeClass(@Nullable ICSSClassProvider iCSSClassProvider) {
        this.m_aClassNames.removeClass(iCSSClassProvider);
        return this;
    }

    @Nonnull
    public DataTablesColumnDef removeAllClasses() {
        this.m_aClassNames.removeAllClasses();
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<ICSSClassProvider> getAllClasses() {
        return this.m_aClassNames.getAllClasses();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<String> getAllClassNames() {
        return this.m_aClassNames.getAllClassNames();
    }

    @Nullable
    public String getAllClassesAsString() {
        return this.m_aClassNames.getAllClassesAsString();
    }

    public boolean hasAnyClass() {
        return this.m_aClassNames.hasAnyClass();
    }

    @Nullable
    public String getContentPadding() {
        return this.m_sContentPadding;
    }

    @Nonnull
    public DataTablesColumnDef setContentPadding(@Nullable String string) {
        this.m_sContentPadding = string;
        return this;
    }

    @Nullable
    public JSAnonymousFunction getCreatedCell() {
        return this.m_aCreatedCell;
    }

    @Nonnull
    public DataTablesColumnDef setCreatedCell(@Nullable JSAnonymousFunction jSAnonymousFunction) {
        this.m_aCreatedCell = jSAnonymousFunction;
        return this;
    }

    @Nullable
    public IJSExpression getData() {
        return this.m_aData;
    }

    @Nonnull
    public DataTablesColumnDef setData(@Nonnegative int n) {
        return this.setData((IJSExpression)JSExpr.lit((int)n));
    }

    @Nonnull
    public DataTablesColumnDef setData(@Nonnull @Nonempty String string) {
        return this.setData((IJSExpression)JSExpr.lit((String)string));
    }

    @Nonnull
    public DataTablesColumnDef setDataNull() {
        return this.setData(JSExpr.NULL);
    }

    @Nonnull
    public DataTablesColumnDef setData(@Nullable IJSExpression iJSExpression) {
        this.m_aData = iJSExpression;
        return this;
    }

    @Nullable
    public String getDefaultContent() {
        return this.m_sDefaultContent;
    }

    @Nonnull
    public DataTablesColumnDef setDefaultContent(@Nullable String string) {
        this.m_sDefaultContent = string;
        return this;
    }

    @Nullable
    public String getName() {
        return this.m_sName;
    }

    @Nonnull
    public DataTablesColumnDef setName(@Nullable String string) {
        this.m_sName = string;
        return this;
    }

    public boolean isOrderable() {
        return this.m_bOrderable;
    }

    @Nonnull
    public DataTablesColumnDef setOrderable(boolean bl) {
        this.m_bOrderable = bl;
        return this;
    }

    @Nullable
    @ReturnsMutableCopy
    public int[] getOrderData() {
        return ArrayHelper.getCopy((int[])this.m_aOrderData);
    }

    @Nonnull
    public DataTablesColumnDef setOrderData(int ... nArray) {
        this.m_aOrderData = ArrayHelper.getCopy((int[])nArray);
        return this;
    }

    @Nullable
    public String getOrderDataType() {
        return this.m_sOrderDataType;
    }

    @Nonnull
    public DataTablesColumnDef setOrderDataType(@Nullable String string) {
        this.m_sOrderDataType = string;
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<EDataTablesOrderDirectionType> getOrderSequence() {
        return new CommonsArrayList(this.m_aOrderSequence);
    }

    @Nonnull
    public DataTablesColumnDef setOrderSequence(EDataTablesOrderDirectionType ... eDataTablesOrderDirectionTypeArray) {
        this.m_aOrderSequence = ArrayHelper.isEmpty((Object[])eDataTablesOrderDirectionTypeArray) ? null : new CommonsArrayList((Object[])eDataTablesOrderDirectionTypeArray);
        return this;
    }

    @Nonnull
    public DataTablesColumnDef setOrderSequence(@Nullable List<EDataTablesOrderDirectionType> list) {
        this.m_aOrderSequence = CollectionHelper.isEmpty(list) ? null : new CommonsArrayList(list);
        return this;
    }

    @Nullable
    public IJSExpression getRender() {
        return this.m_aRender;
    }

    @Nonnull
    public DataTablesColumnDef setRender(@Nullable IJSExpression iJSExpression) {
        this.m_aRender = iJSExpression;
        return this;
    }

    public boolean isSearchable() {
        return this.m_bSearchable;
    }

    @Nonnull
    public DataTablesColumnDef setSearchable(boolean bl) {
        this.m_bSearchable = bl;
        return this;
    }

    @Nullable
    public String getTitle() {
        return this.m_sTitle;
    }

    @Nonnull
    public DataTablesColumnDef setTitle(@Nullable String string) {
        this.m_sTitle = string;
        return this;
    }

    @Nullable
    public EDataTablesColumnType getType() {
        return this.m_eType;
    }

    @Nonnull
    public DataTablesColumnDef setType(@Nullable EDataTablesColumnType eDataTablesColumnType) {
        this.m_eType = eDataTablesColumnType;
        return this;
    }

    public boolean isVisible() {
        return this.m_bVisible;
    }

    @Nonnull
    public DataTablesColumnDef setVisible(boolean bl) {
        this.m_bVisible = bl;
        return this;
    }

    @Nullable
    public String getWidth() {
        return this.m_sWidth;
    }

    @Nonnull
    public DataTablesColumnDef setWidth(@Nullable String string) {
        this.m_sWidth = string;
        return this;
    }

    @Nonnull
    public DTOrderSpec getOrderSpec() {
        return this.m_aOrderSpec;
    }

    @Nonnull
    public JSAssocArray getAsJS() {
        String string;
        JSAssocArray jSAssocArray = new JSAssocArray();
        jSAssocArray.add("targets", (IJSExpression)new JSArray().addAll(this.m_aTargets));
        if (!this.m_sCellType.equals(DEFAULT_CELLTYPE)) {
            jSAssocArray.add("cellType", this.m_sCellType);
        }
        if (StringHelper.isNotEmpty((String)(string = this.getAllClassesAsString()))) {
            jSAssocArray.add("className", string);
        }
        if (StringHelper.isNotEmpty((String)this.m_sContentPadding)) {
            jSAssocArray.add("contentPadding", this.m_sContentPadding);
        }
        if (this.m_aCreatedCell != null) {
            jSAssocArray.add("createdCell", (IJSExpression)this.m_aCreatedCell);
        }
        if (this.m_aData != null) {
            jSAssocArray.add("data", this.m_aData);
        }
        if (this.m_sDefaultContent != null) {
            jSAssocArray.add("defaultContent", this.m_sDefaultContent);
        }
        if (StringHelper.isNotEmpty((String)this.m_sName)) {
            jSAssocArray.add("name", this.m_sName);
        }
        if (!this.m_bOrderable) {
            jSAssocArray.add("orderable", this.m_bOrderable);
        }
        if (ArrayHelper.isNotEmpty((int[])this.m_aOrderData)) {
            jSAssocArray.add("orderData", (IJSExpression)new JSArray().addAll(this.m_aOrderData));
        }
        if (StringHelper.isNotEmpty((String)this.m_sOrderDataType)) {
            jSAssocArray.add("orderDataType", this.m_sOrderDataType);
        }
        if (this.m_aOrderSequence != null && !this.m_aOrderSequence.isEmpty()) {
            JSArray jSArray = new JSArray();
            for (EDataTablesOrderDirectionType eDataTablesOrderDirectionType : this.m_aOrderSequence) {
                jSArray.add(eDataTablesOrderDirectionType.getName());
            }
            jSAssocArray.add("orderSequence", (IJSExpression)jSArray);
        }
        if (this.m_aRender != null) {
            jSAssocArray.add("render", this.m_aRender);
        }
        if (!this.m_bSearchable) {
            jSAssocArray.add("searchable", this.m_bSearchable);
        }
        if (this.m_sTitle != null) {
            jSAssocArray.add("title", this.m_sTitle);
        }
        if (this.m_eType != null) {
            jSAssocArray.add("type", this.m_eType.getName());
        }
        if (!this.m_bVisible) {
            jSAssocArray.add("visible", this.m_bVisible);
        }
        if (StringHelper.isNotEmpty((String)this.m_sWidth)) {
            jSAssocArray.add("width", this.m_sWidth);
        }
        return jSAssocArray;
    }
}

