/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.datatables.column;

import com.helger.base.compare.CompareHelper;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.photon.uictrls.datatables.column.IComparableExtractor;
import com.helger.text.compare.ComparatorHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Comparator;
import java.util.Locale;
import java.util.function.Function;

public class DTOrderSpec {
    public static final boolean DEFAULT_COLLATING = true;
    private IComparableExtractor<?> m_aComparableExtractor;
    private boolean m_bCollating = true;
    private Locale m_aDisplayLocale;
    private transient Comparator<String> m_aComparator;

    public void setFrom(@Nonnull DTOrderSpec dTOrderSpec) {
        this.m_aComparableExtractor = dTOrderSpec.m_aComparableExtractor;
        this.m_bCollating = dTOrderSpec.m_bCollating;
        this.m_aDisplayLocale = dTOrderSpec.m_aDisplayLocale;
        this.m_aComparator = dTOrderSpec.m_aComparator;
    }

    @Nullable
    public IComparableExtractor<?> getComparableExtractor() {
        return this.m_aComparableExtractor;
    }

    @Nonnull
    public <T extends Comparable<? super T>> DTOrderSpec setComparableExtractor(@Nullable Function<String, String> function, @Nullable IComparableExtractor<T> iComparableExtractor) {
        IComparableExtractor iComparableExtractor2;
        this.m_aComparableExtractor = function == null ? iComparableExtractor : (iComparableExtractor2 = string -> (Comparable)iComparableExtractor.apply(string == null ? null : (String)function.apply((String)string)));
        this.m_aComparator = null;
        return this;
    }

    public boolean isCollating() {
        return this.m_bCollating;
    }

    @Nonnull
    public DTOrderSpec setCollating(boolean bl) {
        if (bl != this.m_bCollating) {
            this.m_bCollating = bl;
            this.m_aComparator = null;
        }
        return this;
    }

    @Nullable
    public Locale getDisplayLocale() {
        return this.m_aDisplayLocale;
    }

    @Nonnull
    public DTOrderSpec setDisplayLocale(@Nonnull Locale locale) {
        if (!EqualsHelper.equals((Object)locale, (Object)this.m_aDisplayLocale)) {
            this.m_aDisplayLocale = locale;
            this.m_aComparator = null;
        }
        return this;
    }

    @Nonnull
    public Comparator<String> getComparator() {
        Comparator comparator = this.m_aComparator;
        if (comparator == null) {
            IComparableExtractor<?> iComparableExtractor = this.m_aComparableExtractor;
            if (iComparableExtractor != null) {
                comparator = (string, string2) -> {
                    Comparable comparable = (Comparable)iComparableExtractor.apply(string);
                    Comparable comparable2 = (Comparable)iComparableExtractor.apply(string2);
                    return CompareHelper.compare((Comparable)comparable, (Comparable)comparable2, (boolean)true);
                };
            } else {
                Locale locale = this.m_aDisplayLocale;
                comparator = this.m_bCollating && locale != null ? ComparatorHelper.getComparatorCollating((Locale)locale) : Comparator.naturalOrder();
            }
            this.m_aComparator = comparator;
        }
        return comparator;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ComparableExtractor", this.m_aComparableExtractor).append("Collating", this.m_bCollating).append("DisplayLocale", (Object)this.m_aDisplayLocale).append("Comparator", this.m_aComparator).getToString();
    }
}

