/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.datatables.column;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.datetime.format.EDTFormatterMode;
import com.helger.datetime.format.PDTFormatter;
import com.helger.datetime.format.PDTFromString;
import com.helger.masterdata.currency.CurrencyHelper;
import com.helger.masterdata.currency.ECurrency;
import com.helger.photon.uictrls.datatables.column.IComparableExtractor;
import com.helger.text.locale.LocaleParser;
import jakarta.annotation.Nonnull;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;

@Immutable
public final class ComparatorDT {
    private ComparatorDT() {
    }

    @Nonnull
    public static IComparableExtractor<BigDecimal> getExtractorBigDecimal(@Nonnull Locale locale) {
        return string -> StringHelper.isEmpty((String)string) ? null : LocaleParser.parseBigDecimal((String)string, (Locale)locale, null);
    }

    @Nonnull
    public static IComparableExtractor<BigDecimal> getExtractorCurrencyFormat(@Nonnull ECurrency eCurrency) {
        return string -> StringHelper.isEmpty((String)string) ? null : CurrencyHelper.parseCurrencyFormat((ECurrency)eCurrency, (String)string, null);
    }

    @Nonnull
    public static IComparableExtractor<BigDecimal> getExtractorCurrencyValueFormat(@Nonnull ECurrency eCurrency) {
        return string -> StringHelper.isEmpty((String)string) ? null : CurrencyHelper.parseValueFormat((ECurrency)eCurrency, (String)string, null);
    }

    @Nonnull
    public static IComparableExtractor<BigInteger> getExtractorBigInteger(@Nonnull Locale locale) {
        return string -> StringHelper.isEmpty((String)string) ? null : LocaleParser.parseBigDecimal((String)string, (Locale)locale, (BigDecimal)BigDecimal.ZERO).toBigIntegerExact();
    }

    @Nonnull
    public static IComparableExtractor<LocalDate> getExtractorDate(@Nonnull Locale locale) {
        return ComparatorDT.getExtractorDate(PDTFormatter.getFormatterDate((FormatStyle)FormatStyle.MEDIUM, (Locale)locale, (EDTFormatterMode)EDTFormatterMode.PARSE));
    }

    @Nonnull
    public static IComparableExtractor<LocalDate> getExtractorDate(@Nonnull DateTimeFormatter dateTimeFormatter) {
        return string -> StringHelper.isEmpty((String)string) ? null : (LocalDate)ValueEnforcer.notNull((Object)PDTFromString.getLocalDateFromString((String)string, (DateTimeFormatter)dateTimeFormatter), () -> "Failed to parse date '" + string + "' using formatter " + String.valueOf(dateTimeFormatter));
    }

    @Nonnull
    public static IComparableExtractor<LocalTime> getExtractorTime(@Nonnull Locale locale) {
        return ComparatorDT.getExtractorTime(PDTFormatter.getFormatterTime((FormatStyle)FormatStyle.MEDIUM, (Locale)locale, (EDTFormatterMode)EDTFormatterMode.PARSE));
    }

    @Nonnull
    public static IComparableExtractor<LocalTime> getExtractorTime(@Nonnull DateTimeFormatter dateTimeFormatter) {
        return string -> StringHelper.isEmpty((String)string) ? null : (LocalTime)ValueEnforcer.notNull((Object)PDTFromString.getLocalTimeFromString((String)string, (DateTimeFormatter)dateTimeFormatter), () -> "Failed to parse time '" + string + "' with formatter " + String.valueOf(dateTimeFormatter));
    }

    @Nonnull
    public static IComparableExtractor<LocalDateTime> getExtractorDateTime(@Nonnull Locale locale) {
        return ComparatorDT.getExtractorDateTime(PDTFormatter.getFormatterDateTime((FormatStyle)FormatStyle.MEDIUM, (Locale)locale, (EDTFormatterMode)EDTFormatterMode.PARSE));
    }

    @Nonnull
    public static IComparableExtractor<LocalDateTime> getExtractorDateTime(@Nonnull DateTimeFormatter dateTimeFormatter) {
        return string -> StringHelper.isEmpty((String)string) ? null : (LocalDateTime)ValueEnforcer.notNull((Object)PDTFromString.getLocalDateTimeFromString((String)string, (DateTimeFormatter)dateTimeFormatter), () -> "Failed to parse datetime '" + string + "' with formatter " + String.valueOf(dateTimeFormatter));
    }

    @Nonnull
    public static IComparableExtractor<Duration> getExtractorDuration() {
        return string -> StringHelper.isEmpty((String)string) ? null : (Duration)ValueEnforcer.notNull((Object)PDTFromString.getDurationFromString((String)string), () -> "Failed to parse duration '" + string + "'");
    }
}

