/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.datatables.ajax;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.photon.uictrls.datatables.ajax.DTSSRequestDataOrderColumn;
import com.helger.photon.uictrls.datatables.ajax.DataTablesServerData;
import com.helger.photon.uictrls.datatables.column.DTOrderSpec;
import jakarta.annotation.Nonnull;
import java.util.Locale;

final class DataTablesServerSortState {
    private final ICommonsList<DTSSRequestDataOrderColumn> m_aOrderColumns;

    DataTablesServerSortState(@Nonnull DataTablesServerData dataTablesServerData, @Nonnull Locale locale) {
        this(dataTablesServerData, (ICommonsList<DTSSRequestDataOrderColumn>)new CommonsArrayList(0), locale);
    }

    public DataTablesServerSortState(@Nonnull DataTablesServerData dataTablesServerData, @Nonnull ICommonsList<DTSSRequestDataOrderColumn> iCommonsList, @Nonnull Locale locale) {
        ValueEnforcer.notNull((Object)dataTablesServerData, (String)"ServerData");
        ValueEnforcer.notNull(iCommonsList, (String)"OrderColumns");
        ValueEnforcer.notNull((Object)locale, (String)"DisplayLocale");
        this.m_aOrderColumns = iCommonsList;
        for (DTSSRequestDataOrderColumn dTSSRequestDataOrderColumn : iCommonsList) {
            DTOrderSpec dTOrderSpec = dataTablesServerData.getColumnOrderSpec(dTSSRequestDataOrderColumn.getColumnIndex());
            if (dTOrderSpec == null) {
                dTOrderSpec = new DTOrderSpec();
            }
            dTOrderSpec.setDisplayLocale(locale);
            dTSSRequestDataOrderColumn.setOrderSpec(dTOrderSpec);
        }
    }

    @Nonnegative
    public int getSortingCols() {
        return this.m_aOrderColumns.size();
    }

    @Nonnull
    @ReturnsMutableObject(value="speed")
    public ICommonsList<DTSSRequestDataOrderColumn> directGetAllOrderColumns() {
        return this.m_aOrderColumns;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        DataTablesServerSortState dataTablesServerSortState = (DataTablesServerSortState)object;
        return this.m_aOrderColumns.equals(dataTablesServerSortState.m_aOrderColumns);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aOrderColumns).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("OrderColumns", this.m_aOrderColumns).getToString();
    }
}

