/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.datatables.ajax;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.array.ArrayHelper;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.base.type.ObjectType;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.html.hc.IHCConversionSettings;
import com.helger.html.hc.IHCCustomizer;
import com.helger.html.hc.config.HCConversionSettings;
import com.helger.html.hc.ext.HCCustomizerAutoFocusFirstCtrl;
import com.helger.html.hc.html.tabular.HCRow;
import com.helger.html.hc.html.tabular.IHCTable;
import com.helger.html.hc.impl.HCCustomizerList;
import com.helger.photon.app.html.PhotonHTMLHelper;
import com.helger.photon.core.uistate.IHasUIState;
import com.helger.photon.uictrls.datatables.EDataTablesFilterType;
import com.helger.photon.uictrls.datatables.ajax.ComparatorDataTablesServerDataRow;
import com.helger.photon.uictrls.datatables.ajax.DataTablesServerDataRow;
import com.helger.photon.uictrls.datatables.ajax.DataTablesServerSortState;
import com.helger.photon.uictrls.datatables.column.DTOrderSpec;
import com.helger.photon.uictrls.datatables.column.DataTablesColumnDef;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataTablesServerData
implements IHasUIState {
    public static final ObjectType OT_DATATABLES = new ObjectType("datatables");
    public static final IHCConversionSettings DEFAULT_CONVERSION_SETTINGS = DataTablesServerData.createConversionSettings();
    private static final Logger LOGGER = LoggerFactory.getLogger(DataTablesServerData.class);
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private final DTOrderSpec[] m_aColumns;
    @GuardedBy(value="m_aRWLock")
    private final ICommonsList<DataTablesServerDataRow> m_aRows;
    private final Locale m_aDisplayLocale;
    @GuardedBy(value="m_aRWLock")
    private DataTablesServerSortState m_aServerSortState;
    private final EDataTablesFilterType m_eFilterType;

    public DataTablesServerData(@Nonnull IHCTable<?> iHCTable, @Nonnull List<DataTablesColumnDef> list, @Nonnull Locale locale, @Nonnull EDataTablesFilterType eDataTablesFilterType) {
        int n;
        ValueEnforcer.notNull(iHCTable, (String)"Table");
        ValueEnforcer.notNull(list, (String)"Columns");
        ValueEnforcer.notNull((Object)locale, (String)"DisplayLocale");
        ValueEnforcer.notNull((Object)((Object)eDataTablesFilterType), (String)"FilterType");
        int n2 = iHCTable.getColumnCount();
        this.m_aColumns = new DTOrderSpec[n2];
        for (DataTablesColumnDef object : list) {
            DTOrderSpec dTOrderSpec = object.getOrderSpec();
            for (int n3 : object.getAllTargets()) {
                if (n3 < 0 || n3 >= n2) {
                    throw new IllegalArgumentException("DataTablesColumn is targeting illegal column index " + n3 + "; " + (String)(n2 > 0 ? "must be >= 0 and < " + n2 : "no columns are present") + " in table '" + iHCTable.getID() + "'");
                }
                this.m_aColumns[n3] = dTOrderSpec;
            }
        }
        for (n = 0; n < n2; ++n) {
            if (this.m_aColumns[n] != null) continue;
            this.m_aColumns[n] = new DTOrderSpec().setDisplayLocale(locale);
        }
        this.m_aRows = new CommonsArrayList(iHCTable.getBodyRowCount());
        n = 0;
        for (DTOrderSpec dTOrderSpec : iHCTable.getAllBodyRows()) {
            this.m_aRows.add((Object)new DataTablesServerDataRow((HCRow)dTOrderSpec));
            n += dTOrderSpec.getCellCount();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Having ServerSide DataTables with " + iHCTable.getBodyRowCount() + " rows and a total of " + n + " cells");
        }
        this.m_aDisplayLocale = locale;
        this.m_aServerSortState = new DataTablesServerSortState(this, locale);
        this.m_eFilterType = eDataTablesFilterType;
    }

    @Nonnull
    public static IHCConversionSettings createConversionSettings() {
        HCConversionSettings hCConversionSettings = PhotonHTMLHelper.getHCConversionSettingsWithNonce();
        hCConversionSettings.getMutableXMLWriterSettings().setEmitNamespaces(false);
        IHCCustomizer iHCCustomizer = hCConversionSettings.getCustomizer();
        if (iHCCustomizer instanceof HCCustomizerAutoFocusFirstCtrl) {
            hCConversionSettings.setCustomizer(null);
        } else if (iHCCustomizer instanceof HCCustomizerList) {
            ((HCCustomizerList)iHCCustomizer).removeAllCustomizersOfClass(HCCustomizerAutoFocusFirstCtrl.class);
        }
        return hCConversionSettings;
    }

    @Nonnull
    public ObjectType getObjectType() {
        return OT_DATATABLES;
    }

    public boolean hasServerSortState(@Nonnull DataTablesServerSortState dataTablesServerSortState) {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aServerSortState.equals(dataTablesServerSortState));
    }

    public void setServerSortStateAndSort(@Nonnull DataTablesServerSortState dataTablesServerSortState) {
        ValueEnforcer.notNull((Object)dataTablesServerSortState, (String)"NewServerSortState");
        ComparatorDataTablesServerDataRow comparatorDataTablesServerDataRow = new ComparatorDataTablesServerDataRow(dataTablesServerSortState);
        this.m_aRWLock.writeLocked(() -> this.lambda$setServerSortStateAndSort$1(dataTablesServerSortState, (Comparator)((Object)comparatorDataTablesServerDataRow)));
    }

    @Nonnegative
    public int getRowCount() {
        return this.m_aRWLock.readLockedInt(() -> this.m_aRows.size());
    }

    public void forEachRow(Consumer<? super DataTablesServerDataRow> consumer) {
        this.m_aRWLock.readLocked(() -> this.m_aRows.forEach(consumer));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<DataTablesServerDataRow> getAllRows() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> this.m_aRows.getClone());
    }

    @Nullable
    public DataTablesServerDataRow getRowOfID(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        return (DataTablesServerDataRow)this.m_aRWLock.readLockedGet(() -> (DataTablesServerDataRow)this.m_aRows.findFirst(dataTablesServerDataRow -> string.equals(dataTablesServerDataRow.getRowID())));
    }

    @Nonnull
    public Locale getDisplayLocale() {
        return this.m_aDisplayLocale;
    }

    @Nullable
    public DTOrderSpec getColumnOrderSpec(@Nonnegative int n) {
        return (DTOrderSpec)ArrayHelper.getSafeElement((Object[])this.m_aColumns, (int)n);
    }

    @Nonnull
    public EDataTablesFilterType getFilterType() {
        return this.m_eFilterType;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("columnCount", this.m_aColumns.length).append("rowCount", this.m_aRows.size()).append("displayLocale", (Object)this.m_aDisplayLocale).append("filterType", (Enum)this.m_eFilterType).getToString();
    }

    private /* synthetic */ void lambda$setServerSortStateAndSort$1(DataTablesServerSortState dataTablesServerSortState, Comparator comparator) {
        this.m_aServerSortState = dataTablesServerSortState;
        this.m_aRows.sort(comparator);
    }
}

