/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.datatables.ajax;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.ICommonsList;
import com.helger.html.hc.special.IHCSpecialNodes;
import com.helger.json.IHasJson;
import com.helger.json.IJsonObject;
import com.helger.json.JsonObject;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@Immutable
public final class DTSSResponseData
implements IHasJson {
    private final int m_nDraw;
    private final int m_nTotalRecords;
    private final int m_nTotalDisplayRecords;
    private final ICommonsList<IJsonObject> m_aData;
    private final IHCSpecialNodes m_aSpecialNodes;
    private final String m_sErrorMsg;

    public DTSSResponseData(int n, int n2, int n3, @Nullable ICommonsList<IJsonObject> iCommonsList, @Nullable String string, @Nonnull IHCSpecialNodes iHCSpecialNodes) {
        ValueEnforcer.notNull((Object)iHCSpecialNodes, (String)"SpecialNodes");
        this.m_nDraw = n;
        this.m_nTotalRecords = n2;
        this.m_nTotalDisplayRecords = n3;
        this.m_aData = iCommonsList;
        this.m_sErrorMsg = string;
        this.m_aSpecialNodes = iHCSpecialNodes;
    }

    public int getDraw() {
        return this.m_nDraw;
    }

    public int getTotalRecords() {
        return this.m_nTotalRecords;
    }

    public int getTotalDisplayRecords() {
        return this.m_nTotalDisplayRecords;
    }

    @Nullable
    @ReturnsMutableCopy
    public ICommonsList<IJsonObject> getData() {
        return this.m_aData == null ? null : (ICommonsList)this.m_aData.getClone();
    }

    @Nullable
    public String getErrorMessage() {
        return this.m_sErrorMsg;
    }

    @Nonnull
    public IJsonObject getAsJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add((Object)"draw", (Object)Integer.toString(this.m_nDraw));
        jsonObject.add((Object)"recordsTotal", this.m_nTotalRecords);
        jsonObject.add((Object)"recordsFiltered", this.m_nTotalDisplayRecords);
        if (this.m_aData != null) {
            jsonObject.add((Object)"data", this.m_aData);
        } else {
            jsonObject.add((Object)"error", (Object)this.m_sErrorMsg);
        }
        return jsonObject;
    }

    @Nonnull
    public IHCSpecialNodes getSpecialNodes() {
        return this.m_aSpecialNodes;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Draw", this.m_nDraw).append("TotalRecords", this.m_nTotalRecords).append("TotalDisplayRecords", this.m_nTotalDisplayRecords).append("Data", this.m_aData).append("ErrorMsg", (Object)this.m_sErrorMsg).append("SpecialNodes", (Object)this.m_aSpecialNodes).getToString();
    }
}

