/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.datatables.ajax;

import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.json.IJson;
import com.helger.json.IJsonObject;
import com.helger.photon.ajax.executor.IAjaxExecutor;
import com.helger.photon.app.PhotonUnifiedResponse;
import com.helger.photon.uictrls.datatables.DataTables;
import com.helger.servlet.response.ResponseHelperSettings;
import com.helger.text.locale.LocaleCache;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import jakarta.annotation.Nonnull;
import java.util.Locale;

public class AjaxExecutorDataTablesI18N
implements IAjaxExecutor {
    public static final String REQUEST_PARAM_LANGUAGE_ID = "language";
    private final Locale m_aDefaultLocale;

    public AjaxExecutorDataTablesI18N() {
        this(Locale.US);
    }

    public AjaxExecutorDataTablesI18N(@Nonnull Locale locale) {
        ValueEnforcer.notNull((Object)locale, (String)"DefaultLocale");
        if (StringHelper.isEmpty((String)locale.getLanguage())) {
            throw new IllegalArgumentException("defaultLocale muts have a language: " + String.valueOf(locale));
        }
        this.m_aDefaultLocale = locale;
    }

    @OverrideOnDemand
    protected IJsonObject getText(@Nonnull Locale locale) {
        return DataTables.createLanguageJson(locale);
    }

    public void handleRequest(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull PhotonUnifiedResponse photonUnifiedResponse) throws Exception {
        String string = iRequestWebScopeWithoutResponse.params().getAsString((Object)REQUEST_PARAM_LANGUAGE_ID);
        Locale locale = LocaleCache.getInstance().getLocale(string);
        if (locale == null) {
            locale = this.m_aDefaultLocale;
        }
        IJsonObject iJsonObject = this.getText(locale);
        photonUnifiedResponse.json((IJson)iJsonObject);
        photonUnifiedResponse.enableCaching(ResponseHelperSettings.getExpirationSeconds());
    }
}

