/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.datatables.ajax;

import com.helger.base.array.ArrayHelper;
import com.helger.base.compare.ESortOrder;
import com.helger.base.string.StringParser;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.helper.CollectionSort;
import com.helger.html.hc.special.HCSpecialNodes;
import com.helger.html.hc.special.IHCSpecialNodes;
import com.helger.json.IJson;
import com.helger.json.IJsonObject;
import com.helger.json.JsonObject;
import com.helger.photon.ajax.executor.IAjaxExecutor;
import com.helger.photon.app.PhotonUnifiedResponse;
import com.helger.photon.core.uistate.UIStateRegistry;
import com.helger.photon.uictrls.datatables.EDataTablesFilterType;
import com.helger.photon.uictrls.datatables.EDataTablesOrderDirectionType;
import com.helger.photon.uictrls.datatables.ajax.DTSSRequestData;
import com.helger.photon.uictrls.datatables.ajax.DTSSRequestDataColumn;
import com.helger.photon.uictrls.datatables.ajax.DTSSRequestDataOrderColumn;
import com.helger.photon.uictrls.datatables.ajax.DTSSRequestDataSearch;
import com.helger.photon.uictrls.datatables.ajax.DTSSResponseData;
import com.helger.photon.uictrls.datatables.ajax.DataTablesServerData;
import com.helger.photon.uictrls.datatables.ajax.DataTablesServerDataCell;
import com.helger.photon.uictrls.datatables.ajax.DataTablesServerDataRow;
import com.helger.photon.uictrls.datatables.ajax.DataTablesServerSortState;
import com.helger.servlet.request.IRequestParamMap;
import com.helger.typeconvert.impl.TypeConverter;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AjaxExecutorDataTables
implements IAjaxExecutor {
    public static final String OBJECT_ID = "object";
    private static final String DRAW = "draw";
    private static final String START = "start";
    private static final String LENGTH = "length";
    private static final String SEARCH_VALUE = "search[value]";
    private static final String SEARCH_REGEX = "search[regex]";
    private static final String ORDER = "order";
    private static final String ORDER_COLUMN = "column";
    private static final String ORDER_DIR = "dir";
    private static final String COLUMNS = "columns";
    private static final String COLUMNS_DATA = "data";
    private static final String COLUMNS_NAME = "name";
    private static final String COLUMNS_SEARCHABLE = "searchable";
    private static final String COLUMNS_ORDERABLE = "orderable";
    private static final String COLUMNS_SEARCH = "search";
    private static final String COLUMNS_SEARCH_VALUE = "value";
    private static final String COLUMNS_SEARCH_REGEX = "regex";
    private static final String DT_ROW_ID = "DT_RowId";
    private static final String DT_ROW_CLASS = "DT_RowClass";
    private static final String DT_ROW_DATA = "DT_RowData";
    private static final String DT_ROW_ATTR = "DT_RowAttr";
    private static final Logger LOGGER = LoggerFactory.getLogger(AjaxExecutorDataTables.class);

    @Nonnull
    public static DTSSRequestData extractDTSRequestData(IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        Object object;
        String string;
        int n = iRequestWebScopeWithoutResponse.params().getAsInt((Object)DRAW);
        int n2 = Math.max(iRequestWebScopeWithoutResponse.params().getAsInt((Object)START, 0), 0);
        int n3 = iRequestWebScopeWithoutResponse.params().getAsInt((Object)LENGTH, -1);
        String string2 = iRequestWebScopeWithoutResponse.params().getAsString((Object)SEARCH_VALUE);
        boolean bl = iRequestWebScopeWithoutResponse.params().getAsBoolean((Object)SEARCH_REGEX, false);
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        IRequestParamMap iRequestParamMap = iRequestWebScopeWithoutResponse.getRequestParamMap().getMap(new String[]{ORDER});
        if (iRequestParamMap != null) {
            IRequestParamMap iRequestParamMap2;
            int n4 = 0;
            while ((iRequestParamMap2 = iRequestParamMap.getMap(new String[]{Integer.toString(n4)})) != null) {
                int n5 = Math.max(TypeConverter.convertToInt((Object)iRequestParamMap2.getString(new String[]{ORDER_COLUMN}), (int)0), 0);
                string = iRequestParamMap2.getString(new String[]{ORDER_DIR});
                object = EDataTablesOrderDirectionType.getSortOrderFromNameOrNull(string);
                commonsArrayList.add((Object)new DTSSRequestDataOrderColumn(n5, (ESortOrder)object));
                ++n4;
            }
        }
        iRequestParamMap = new CommonsArrayList();
        IRequestParamMap iRequestParamMap3 = iRequestWebScopeWithoutResponse.getRequestParamMap().getMap(new String[]{COLUMNS});
        if (iRequestParamMap3 != null) {
            IRequestParamMap iRequestParamMap4;
            int n6 = 0;
            while ((iRequestParamMap4 = iRequestParamMap3.getMap(new String[]{Integer.toString(n6)})) != null) {
                string = iRequestParamMap4.getString(new String[]{COLUMNS_DATA});
                object = iRequestParamMap4.getString(new String[]{COLUMNS_NAME});
                boolean bl2 = StringParser.parseBool((String)iRequestParamMap4.getString(new String[]{COLUMNS_SEARCHABLE}), (boolean)true);
                boolean bl3 = StringParser.parseBool((String)iRequestParamMap4.getString(new String[]{COLUMNS_ORDERABLE}), (boolean)true);
                String string3 = iRequestParamMap4.getString(new String[]{COLUMNS_SEARCH, COLUMNS_SEARCH_VALUE});
                boolean bl4 = StringParser.parseBool((String)iRequestParamMap4.getString(new String[]{COLUMNS_SEARCH, COLUMNS_SEARCH_REGEX}), (boolean)true);
                iRequestParamMap.add((Object)new DTSSRequestDataColumn(string, (String)object, bl2, bl3, string3, bl4));
                ++n6;
            }
        }
        return new DTSSRequestData(n, n2, n3, string2, bl, (ICommonsList<DTSSRequestDataColumn>)iRequestParamMap, (ICommonsList<DTSSRequestDataOrderColumn>)commonsArrayList);
    }

    private static void _sort(@Nonnull DTSSRequestData dTSSRequestData, @Nonnull DataTablesServerData dataTablesServerData) {
        if (dataTablesServerData.getRowCount() > 1) {
            Locale locale = dataTablesServerData.getDisplayLocale();
            DataTablesServerSortState dataTablesServerSortState = new DataTablesServerSortState(dataTablesServerData, dTSSRequestData.directGetAllOrderColumns(), locale);
            if (!dataTablesServerData.hasServerSortState(dataTablesServerSortState)) {
                dataTablesServerData.setServerSortStateAndSort(dataTablesServerSortState);
            }
        }
    }

    @Nonnull
    private static ICommonsList<DataTablesServerDataRow> _filter(@Nonnull DTSSRequestData dTSSRequestData, @Nonnull DataTablesServerData dataTablesServerData) {
        if (!dTSSRequestData.isSearchActive()) {
            return dataTablesServerData.getAllRows();
        }
        Locale locale = dataTablesServerData.getDisplayLocale();
        DTSSRequestDataSearch dTSSRequestDataSearch = dTSSRequestData.getSearch();
        String[] stringArray = dTSSRequestDataSearch.getSearchTexts();
        boolean bl = dTSSRequestDataSearch.isRegEx();
        DTSSRequestDataColumn[] dTSSRequestDataColumnArray = dTSSRequestData.getColumnDataArray();
        EDataTablesFilterType eDataTablesFilterType = dataTablesServerData.getFilterType();
        boolean bl2 = false;
        for (DTSSRequestDataColumn dTSSRequestDataColumn : dTSSRequestDataColumnArray) {
            if (!dTSSRequestDataColumn.isSearchable() || !dTSSRequestDataColumn.getSearch().hasSearchText()) continue;
            bl2 = true;
            if (eDataTablesFilterType != EDataTablesFilterType.ALL_TERMS_PER_ROW) continue;
            LOGGER.error("DataTables has column specific search term - this is not implemented for filter type ALL_TERMS_PER_ROW!");
        }
        int n = dataTablesServerData.getRowCount();
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (bl2) {
            dataTablesServerData.forEachRow(arg_0 -> AjaxExecutorDataTables.lambda$_filter$0(dTSSRequestDataColumnArray, stringArray, bl, locale, (ICommonsList)commonsArrayList, arg_0));
        } else {
            dataTablesServerData.forEachRow(arg_0 -> AjaxExecutorDataTables.lambda$_filter$1(stringArray, dTSSRequestDataColumnArray, bl, locale, eDataTablesFilterType, (ICommonsList)commonsArrayList, arg_0));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("DataTables filtered " + commonsArrayList.size() + " rows out of " + n);
        }
        return commonsArrayList;
    }

    @Nonnull
    private static DTSSResponseData _handleRequest(@Nonnull DTSSRequestData dTSSRequestData, @Nonnull DataTablesServerData dataTablesServerData) {
        JsonObject jsonObject;
        int n;
        AjaxExecutorDataTables._sort(dTSSRequestData, dataTablesServerData);
        ICommonsList<DataTablesServerDataRow> iCommonsList = AjaxExecutorDataTables._filter(dTSSRequestData, dataTablesServerData);
        HCSpecialNodes hCSpecialNodes = new HCSpecialNodes();
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        boolean bl = dTSSRequestData.showAllEntries();
        int n2 = Math.min(dTSSRequestData.getDisplayLength(), dataTablesServerData.getRowCount());
        for (int i = 0; (bl || i < n2) && (n = dTSSRequestData.getDisplayStart() + i) < iCommonsList.size(); ++i) {
            DataTablesServerDataRow dataTablesServerDataRow = (DataTablesServerDataRow)iCommonsList.get(n);
            jsonObject = new JsonObject();
            if (dataTablesServerDataRow.hasRowID()) {
                jsonObject.add((Object)DT_ROW_ID, (Object)dataTablesServerDataRow.getRowID());
            }
            if (dataTablesServerDataRow.hasRowClass()) {
                jsonObject.add((Object)DT_ROW_CLASS, (Object)dataTablesServerDataRow.getRowClass());
            }
            if (dataTablesServerDataRow.hasRowData()) {
                jsonObject.add((Object)DT_ROW_DATA, dataTablesServerDataRow.directGetAllRowData());
            }
            if (dataTablesServerDataRow.hasRowAttr()) {
                jsonObject.add((Object)DT_ROW_ATTR, dataTablesServerDataRow.directGetAllRowAttrs());
            }
            int n3 = 0;
            for (DataTablesServerDataCell dataTablesServerDataCell : dataTablesServerDataRow.directGetAllCells()) {
                jsonObject.add((Object)Integer.toString(n3++), (Object)dataTablesServerDataCell.getHTMLString());
                IHCSpecialNodes iHCSpecialNodes = dataTablesServerDataCell.getSpecialNodes();
                if (iHCSpecialNodes == null) continue;
                hCSpecialNodes.addAll(iHCSpecialNodes);
            }
            commonsArrayList.add((Object)jsonObject);
        }
        n = dataTablesServerData.getRowCount();
        int n4 = iCommonsList.size();
        jsonObject = null;
        return new DTSSResponseData(dTSSRequestData.getDraw(), n, n4, (ICommonsList<IJsonObject>)commonsArrayList, (String)jsonObject, (IHCSpecialNodes)hCSpecialNodes);
    }

    public void handleRequest(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull PhotonUnifiedResponse photonUnifiedResponse) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("DataTables AJAX request: " + String.valueOf(CollectionSort.getSortedByKey((Map)iRequestWebScopeWithoutResponse.params())));
        }
        DTSSRequestData dTSSRequestData = AjaxExecutorDataTables.extractDTSRequestData(iRequestWebScopeWithoutResponse);
        String string = iRequestWebScopeWithoutResponse.params().getAsString((Object)OBJECT_ID);
        DataTablesServerData dataTablesServerData = (DataTablesServerData)UIStateRegistry.getCurrent().getCastedState(DataTablesServerData.OT_DATATABLES, string);
        if (dataTablesServerData == null) {
            LOGGER.error("No such data tables ID: " + string);
            photonUnifiedResponse.createNotFound();
        } else {
            DTSSResponseData dTSSResponseData = AjaxExecutorDataTables._handleRequest(dTSSRequestData, dataTablesServerData);
            photonUnifiedResponse.json((IJson)PhotonUnifiedResponse.HtmlHelper.getResponseAsJSON((IJsonObject)dTSSResponseData.getAsJson(), (IHCSpecialNodes)dTSSResponseData.getSpecialNodes()));
        }
    }

    private static /* synthetic */ void lambda$_filter$1(String[] stringArray, DTSSRequestDataColumn[] dTSSRequestDataColumnArray, boolean bl, Locale locale, EDataTablesFilterType eDataTablesFilterType, ICommonsList iCommonsList, DataTablesServerDataRow dataTablesServerDataRow) {
        BitSet bitSet = new BitSet(stringArray.length);
        int n = 0;
        block4: for (DataTablesServerDataCell dataTablesServerDataCell : dataTablesServerDataRow.directGetAllCells()) {
            DTSSRequestDataColumn dTSSRequestDataColumn = dTSSRequestDataColumnArray[n];
            if (dTSSRequestDataColumn.isSearchable()) {
                if (bl) {
                    dataTablesServerDataCell.matchRegEx(stringArray, bitSet);
                } else {
                    dataTablesServerDataCell.matchPlainTextIgnoreCase(stringArray, locale, bitSet);
                }
                switch (eDataTablesFilterType) {
                    case ALL_TERMS_PER_ROW: {
                        if (bitSet.cardinality() != stringArray.length) break;
                        iCommonsList.add((Object)dataTablesServerDataRow);
                        break block4;
                    }
                    case ANY_TERM_PER_ROW: {
                        if (!bitSet.isEmpty()) {
                            iCommonsList.add((Object)dataTablesServerDataRow);
                            break block4;
                        }
                        bitSet.clear();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled filter type: " + String.valueOf((Object)eDataTablesFilterType));
                    }
                }
            }
            ++n;
        }
    }

    private static /* synthetic */ void lambda$_filter$0(DTSSRequestDataColumn[] dTSSRequestDataColumnArray, String[] stringArray, boolean bl, Locale locale, ICommonsList iCommonsList, DataTablesServerDataRow dataTablesServerDataRow) {
        int n = 0;
        for (DataTablesServerDataCell dataTablesServerDataCell : dataTablesServerDataRow.directGetAllCells()) {
            boolean bl2;
            String[] stringArray2;
            DTSSRequestDataColumn dTSSRequestDataColumn = (DTSSRequestDataColumn)ArrayHelper.getSafeElement((Object[])dTSSRequestDataColumnArray, (int)n);
            if (dTSSRequestDataColumn == null) {
                LOGGER.warn("Invalid columnn index " + n + " for columns " + Arrays.toString(dTSSRequestDataColumnArray));
                continue;
            }
            if (!dTSSRequestDataColumn.isSearchable()) continue;
            DTSSRequestDataSearch dTSSRequestDataSearch = dTSSRequestDataColumn.getSearch();
            if (dTSSRequestDataSearch.hasSearchText()) {
                stringArray2 = dTSSRequestDataSearch.getSearchTexts();
                bl2 = dTSSRequestDataSearch.isRegEx();
            } else {
                stringArray2 = stringArray;
                bl2 = bl;
            }
            if (stringArray2 != null) {
                BitSet bitSet = new BitSet(stringArray2.length);
                if (bl2) {
                    dataTablesServerDataCell.matchRegEx(stringArray2, bitSet);
                } else {
                    dataTablesServerDataCell.matchPlainTextIgnoreCase(stringArray2, locale, bitSet);
                }
                if (!bitSet.isEmpty()) {
                    iCommonsList.add((Object)dataTablesServerDataRow);
                    break;
                }
            }
            ++n;
        }
    }
}

