/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.datatables;

import com.helger.base.compare.ESortOrder;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.name.IHasName;
import com.helger.base.string.StringHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public enum EDataTablesOrderDirectionType implements IHasName
{
    ASC("asc", ESortOrder.ASCENDING),
    DESC("desc", ESortOrder.DESCENDING),
    NONE("", null);

    private final String m_sName;
    private final ESortOrder m_eSortOrder;

    private EDataTablesOrderDirectionType(String string2, ESortOrder eSortOrder) {
        this.m_sName = string2;
        this.m_eSortOrder = eSortOrder;
    }

    @Nonnull
    public String getName() {
        return this.m_sName;
    }

    @Nullable
    public ESortOrder getSortOrder() {
        return this.m_eSortOrder;
    }

    @Nullable
    public static ESortOrder getSortOrderFromNameOrNull(@Nullable String string) {
        if (StringHelper.isNotEmpty((String)string)) {
            for (EDataTablesOrderDirectionType eDataTablesOrderDirectionType : EDataTablesOrderDirectionType.values()) {
                if (!eDataTablesOrderDirectionType.m_sName.equals(string)) continue;
                return eDataTablesOrderDirectionType.m_eSortOrder;
            }
        }
        return null;
    }

    @Nullable
    public static String getNameFromSortOrderOrNull(@Nullable ESortOrder eSortOrder) {
        for (EDataTablesOrderDirectionType eDataTablesOrderDirectionType : EDataTablesOrderDirectionType.values()) {
            if (!EqualsHelper.identityEqual((Object)eDataTablesOrderDirectionType.m_eSortOrder, (Object)eSortOrder)) continue;
            return eDataTablesOrderDirectionType.m_sName;
        }
        return null;
    }
}

