/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.datatables;

import com.helger.annotation.Nonnegative;
import com.helger.base.compare.ESortOrder;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.jscode.JSArray;
import com.helger.photon.uictrls.datatables.EDataTablesOrderDirectionType;
import jakarta.annotation.Nonnull;

public final class DataTablesOrderColumn {
    private final int m_nIndex;
    private final ESortOrder m_eSortOrder;

    public DataTablesOrderColumn(@Nonnegative int n, @Nonnull ESortOrder eSortOrder) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)eSortOrder, (String)"SortOrder");
        this.m_nIndex = n;
        this.m_eSortOrder = eSortOrder;
    }

    @Nonnegative
    public int getIndex() {
        return this.m_nIndex;
    }

    @Nonnull
    public ESortOrder getSortOrder() {
        return this.m_eSortOrder;
    }

    @Nonnull
    public JSArray getAsJS() {
        JSArray jSArray = new JSArray();
        jSArray.add(this.m_nIndex);
        jSArray.add(EDataTablesOrderDirectionType.getNameFromSortOrderOrNull(this.m_eSortOrder));
        return jSArray;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("index", this.m_nIndex).append("sortOrder", (Enum)this.m_eSortOrder).getToString();
    }
}

