/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.datatables;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSArray;
import com.helger.photon.uictrls.datatables.DataTablesLengthMenuItem;
import com.helger.photon.uictrls.datatables.EDataTablesText;
import com.helger.photon.uictrls.datatables.IDataTablesLengthMenu;
import com.helger.text.display.ConstantHasDisplayText;
import com.helger.text.display.IHasDisplayText;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

@NotThreadSafe
public class DataTablesLengthMenu
implements IDataTablesLengthMenu {
    public static final int COUNT_ALL = -1;
    public static final IDataTablesLengthMenu INSTANCE_ALL = new DataTablesLengthMenu().addItemAll();
    public static final IDataTablesLengthMenu INSTANCE_25_50_100_ALL = new DataTablesLengthMenu().addItem(25).addItem(50).addItem(100).addItemAll();
    public static final IDataTablesLengthMenu INSTANCE_10_25_50_100_ALL = new DataTablesLengthMenu().addItem(10).addItem(25).addItem(50).addItem(100).addItemAll();
    private final ICommonsList<DataTablesLengthMenuItem> m_aList = new CommonsArrayList();

    @Nonnull
    public DataTablesLengthMenu addItemAll() {
        return this.addItem(-1, EDataTablesText.ALL);
    }

    @Nonnull
    public DataTablesLengthMenu addItem(int n) {
        return this.addItem(n, (IHasDisplayText)new ConstantHasDisplayText(Integer.toString(n)));
    }

    @Nonnull
    public DataTablesLengthMenu addItem(int n, @Nonnull IHasDisplayText iHasDisplayText) {
        return this.addItem(new DataTablesLengthMenuItem(n, iHasDisplayText));
    }

    @Nonnull
    public DataTablesLengthMenu addItem(@Nonnull DataTablesLengthMenuItem dataTablesLengthMenuItem) {
        ValueEnforcer.notNull((Object)dataTablesLengthMenuItem, (String)"Item");
        this.m_aList.add((Object)dataTablesLengthMenuItem);
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<Integer, String> getAsMap(@Nonnull Locale locale) {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        for (DataTablesLengthMenuItem dataTablesLengthMenuItem : this.m_aList) {
            commonsLinkedHashMap.put((Object)dataTablesLengthMenuItem.getItemCount(), (Object)dataTablesLengthMenuItem.getDisplayText(locale));
        }
        return commonsLinkedHashMap;
    }

    @Override
    public boolean isEmpty() {
        return this.m_aList.isEmpty();
    }

    @Override
    @Nonnegative
    public int getItemCount() {
        return this.m_aList.size();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<DataTablesLengthMenuItem> getAllItems() {
        return (ICommonsList)this.m_aList.getClone();
    }

    @Override
    @Nullable
    public DataTablesLengthMenuItem getItemAtIndex(@Nonnegative int n) {
        return (DataTablesLengthMenuItem)this.m_aList.getAtIndex(n);
    }

    @Override
    @Nullable
    public DataTablesLengthMenuItem getItemWithLeastItemCount() {
        DataTablesLengthMenuItem dataTablesLengthMenuItem = null;
        for (DataTablesLengthMenuItem dataTablesLengthMenuItem2 : this.m_aList) {
            if (dataTablesLengthMenuItem2.isAllItem() || dataTablesLengthMenuItem != null && dataTablesLengthMenuItem2.getItemCount() >= dataTablesLengthMenuItem.getItemCount()) continue;
            dataTablesLengthMenuItem = dataTablesLengthMenuItem2;
        }
        return dataTablesLengthMenuItem;
    }

    @Override
    @Nonnull
    public JSArray getAsJSArray(@Nonnull Locale locale) {
        JSArray jSArray = new JSArray();
        JSArray jSArray2 = new JSArray();
        for (DataTablesLengthMenuItem dataTablesLengthMenuItem : this.m_aList) {
            jSArray.add(dataTablesLengthMenuItem.getItemCount());
            String string = dataTablesLengthMenuItem.getDisplayText(locale);
            if (string != null) {
                jSArray2.add(string);
                continue;
            }
            jSArray2.add(Integer.toString(dataTablesLengthMenuItem.getItemCount()));
        }
        return new JSArray().add((IJSExpression)jSArray).add((IJSExpression)jSArray2);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("List", this.m_aList).getToString();
    }
}

