/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.datatables;

import com.helger.annotation.CheckForSigned;
import com.helger.annotation.Nonempty;
import com.helger.base.array.ArrayHelper;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.EChange;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringImplode;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.html.css.ICSSClassProvider;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTablesDom
implements ICloneable<DataTablesDom> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataTablesDom.class);
    private static final String OPEN_DIV = "<";
    private static final String CLOSE_DIV = ">";
    private final ICommonsList<String> m_aElements;
    private int m_nOpenDivs = 0;
    private int m_nPos = -1;

    public DataTablesDom() {
        this.m_aElements = new CommonsArrayList();
    }

    public DataTablesDom(@Nonnull DataTablesDom dataTablesDom) {
        ValueEnforcer.notNull((Object)dataTablesDom, (String)"Other");
        this.m_aElements = new CommonsArrayList(dataTablesDom.m_aElements);
    }

    @CheckForSigned
    public int getPosition() {
        return this.m_nPos;
    }

    @Nonnull
    public DataTablesDom setPosition(int n) {
        this.m_nPos = n;
        return this;
    }

    @Nonnull
    public DataTablesDom setPositionToEnd() {
        return this.setPosition(this.m_aElements.size());
    }

    @CheckForSigned
    public int indexOf(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return -1;
        }
        return this.m_aElements.indexOf((Object)string);
    }

    public boolean contains(@Nullable String string) {
        return this.indexOf(string) >= 0;
    }

    @Nonnull
    public EChange remove(@Nullable String string) {
        int n = this.indexOf(string);
        if (n < 0) {
            return EChange.UNCHANGED;
        }
        return this.remove(n);
    }

    @Nonnull
    public EChange remove() {
        return this.remove(this.m_nPos);
    }

    @Nonnull
    public EChange remove(int n) {
        if (n < 0 || n >= this.m_aElements.size()) {
            return EChange.UNCHANGED;
        }
        String string = (String)this.m_aElements.remove(n);
        if (string != null && string.startsWith(OPEN_DIV)) {
            --this.m_nOpenDivs;
        }
        return EChange.CHANGED;
    }

    private void _internalAdd(@Nonnull String string) {
        if (this.m_nPos < 0) {
            this.m_aElements.add((Object)string);
        } else {
            this.m_aElements.add(this.m_nPos, (Object)string);
            ++this.m_nPos;
        }
    }

    @Nonnull
    private DataTablesDom _internalOpenDiv(@Nonnull String string) {
        this._internalAdd(string);
        ++this.m_nOpenDivs;
        return this;
    }

    @Nonnull
    public DataTablesDom openDiv() {
        return this._internalOpenDiv(OPEN_DIV);
    }

    @Nullable
    public static String getDivString(@Nullable ICSSClassProvider iCSSClassProvider) {
        String string = iCSSClassProvider == null ? null : iCSSClassProvider.getCSSClass();
        return StringHelper.isEmpty((String)string) ? OPEN_DIV : "<'" + string + "'";
    }

    @Nonnull
    public DataTablesDom openDiv(@Nullable ICSSClassProvider iCSSClassProvider) {
        return this._internalOpenDiv(DataTablesDom.getDivString(iCSSClassProvider));
    }

    @Nullable
    public static String getDivString(ICSSClassProvider ... iCSSClassProviderArray) {
        if (ArrayHelper.isNotEmpty((Object[])iCSSClassProviderArray)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (ICSSClassProvider iCSSClassProvider : iCSSClassProviderArray) {
                String string = iCSSClassProvider.getCSSClass();
                if (!StringHelper.isNotEmpty((String)string)) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(string);
            }
            if (stringBuilder.length() > 0) {
                return "<'" + stringBuilder.toString() + "'";
            }
        }
        return OPEN_DIV;
    }

    @Nonnull
    public DataTablesDom openDiv(ICSSClassProvider ... iCSSClassProviderArray) {
        return this._internalOpenDiv(DataTablesDom.getDivString(iCSSClassProviderArray));
    }

    @Nonnull
    public DataTablesDom openDiv(@Nullable String string) {
        if (StringHelper.isNotEmpty((String)string)) {
            return this._internalOpenDiv("<'" + string + "'");
        }
        return this._internalOpenDiv(OPEN_DIV);
    }

    @Nullable
    public static String getDivStringWithID(@Nullable String string) {
        return StringHelper.isEmpty((String)string) ? OPEN_DIV : "<'#" + string + "'";
    }

    @Nonnull
    public DataTablesDom openDivWithID(@Nullable String string) {
        return this._internalOpenDiv(DataTablesDom.getDivStringWithID(string));
    }

    @Nonnull
    public DataTablesDom closeDiv() {
        this._internalAdd(CLOSE_DIV);
        if (--this.m_nOpenDivs < 0) {
            LOGGER.error("Too many DIVs are closed: " + this.m_nOpenDivs);
        }
        return this;
    }

    @Nonnull
    public DataTablesDom addLengthMenu() {
        this._internalAdd("l");
        return this;
    }

    @Nonnull
    public DataTablesDom addFiltering() {
        this._internalAdd("f");
        return this;
    }

    @Nonnull
    public DataTablesDom addTable() {
        this._internalAdd("t");
        return this;
    }

    @Nonnull
    public DataTablesDom addInformationSummary() {
        this._internalAdd("i");
        return this;
    }

    @Nonnull
    public DataTablesDom addPagination() {
        this._internalAdd("p");
        return this;
    }

    @Nonnull
    public DataTablesDom addProcessing() {
        this._internalAdd("r");
        return this;
    }

    @Nonnull
    public DataTablesDom addCustom(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Str");
        this._internalAdd(string);
        return this;
    }

    @Nonnull
    public String getAsString() {
        if (this.m_nOpenDivs != 0) {
            LOGGER.error("The DIVs are not balanced: " + (this.m_nOpenDivs > 0 ? this.m_nOpenDivs + " DIVs are open!" : this.m_nOpenDivs + " DIVs too many are closed!"));
        }
        return StringImplode.getImploded(this.m_aElements);
    }

    @Nonnull
    public DataTablesDom getClone() {
        return new DataTablesDom(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        DataTablesDom dataTablesDom = (DataTablesDom)object;
        return this.m_aElements.equals(dataTablesDom.m_aElements);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aElements).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("elements", this.m_aElements).append("openDivCount", this.m_nOpenDivs).append("pos", this.m_nPos).getToString();
    }
}

