/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.uictrls.datatables;

import com.helger.annotation.CheckForSigned;
import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.misc.Since;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.clone.CloneHelper;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.id.factory.GlobalIDFactory;
import com.helger.base.state.EChange;
import com.helger.base.state.ETriState;
import com.helger.base.string.StringHelper;
import com.helger.base.trait.IAddableByTrait;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.html.annotation.OutOfBandNode;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.config.HCSettings;
import com.helger.html.hc.html.script.AbstractHCScriptInline;
import com.helger.html.hc.html.tabular.HCColGroup;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.html.hc.html.tabular.IHCTable;
import com.helger.html.jquery.JQuery;
import com.helger.html.jquery.JQueryAjaxBuilder;
import com.helger.html.jquery.JQueryInvocation;
import com.helger.html.js.IHasJSCode;
import com.helger.html.js.JSMarshaller;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.IJSStatement;
import com.helger.html.jscode.JSAnonymousFunction;
import com.helger.html.jscode.JSArray;
import com.helger.html.jscode.JSAssocArray;
import com.helger.html.jscode.JSExpr;
import com.helger.html.jscode.JSInvocation;
import com.helger.html.jscode.JSLet;
import com.helger.html.jscode.JSPackage;
import com.helger.html.resource.css.ICSSPathProvider;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.json.IJson;
import com.helger.json.IJsonObject;
import com.helger.json.JsonObject;
import com.helger.photon.app.html.PhotonCSS;
import com.helger.photon.app.html.PhotonJS;
import com.helger.photon.core.uistate.IHasUIState;
import com.helger.photon.core.uistate.UIStateRegistry;
import com.helger.photon.uicore.js.JSJQueryHelper;
import com.helger.photon.uictrls.datatables.DataTablesDom;
import com.helger.photon.uictrls.datatables.DataTablesLayout;
import com.helger.photon.uictrls.datatables.DataTablesOrder;
import com.helger.photon.uictrls.datatables.DataTablesSettings;
import com.helger.photon.uictrls.datatables.EDataTablesCSSPathProvider;
import com.helger.photon.uictrls.datatables.EDataTablesFilterType;
import com.helger.photon.uictrls.datatables.EDataTablesJSPathProvider;
import com.helger.photon.uictrls.datatables.EDataTablesPagingType;
import com.helger.photon.uictrls.datatables.EDataTablesText;
import com.helger.photon.uictrls.datatables.IDataTablesLengthMenu;
import com.helger.photon.uictrls.datatables.IDataTablesPlugin;
import com.helger.photon.uictrls.datatables.ajax.DataTablesServerData;
import com.helger.photon.uictrls.datatables.column.DTCol;
import com.helger.photon.uictrls.datatables.column.DataTablesColumnDef;
import com.helger.photon.uictrls.datatables.column.EDTColType;
import com.helger.photon.uictrls.datatables.plugins.DataTablesPluginClientSortingDate;
import com.helger.url.ISimpleURL;
import com.helger.url.SimpleURL;
import com.helger.url.data.IURLData;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.text.DecimalFormatSymbols;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OutOfBandNode
public class DataTables
extends AbstractHCScriptInline<DataTables> {
    public static final boolean DEFAULT_AUTOWIDTH = true;
    public static final boolean DEFAULT_DEFER_RENDER = false;
    public static final boolean DEFAULT_INFO = true;
    public static final boolean DEFAULT_JQUERY_UI = false;
    public static final boolean DEFAULT_LENGTH_CHANGE = true;
    public static final boolean DEFAULT_ORDERING = true;
    public static final boolean DEFAULT_PAGING = true;
    public static final boolean DEFAULT_PROCESSING = false;
    public static final boolean DEFAULT_SCROLL_X = false;
    public static final boolean DEFAULT_SEARCHING = true;
    public static final boolean DEFAULT_STATE_SAVE = false;
    public static final boolean DEFAULT_DEFER_LOADING = false;
    public static final boolean DEFAULT_DESTROY = false;
    public static final int DEFAULT_DISPLAY_START = 0;
    public static final int DEFAULT_PAGE_LENGTH = 10;
    public static final EDataTablesPagingType DEFAULT_PAGING_TYPE = EDataTablesPagingType.SIMPLE_NUMBERS;
    public static final boolean DEFAULT_RETRIEVE = false;
    public static final boolean DEFAULT_SCROLL_COLLAPSE = false;
    public static final String EVENT_INIT = "init.dt";
    private static final Logger LOGGER = LoggerFactory.getLogger(DataTables.class);
    private final IHCTable<?> m_aTable;
    private final int m_nGeneratedJSVariableSuffix = GlobalIDFactory.getNewIntID();
    private String m_sJSVariableName = "dt" + this.m_nGeneratedJSVariableSuffix;
    private boolean m_bAutoWidth = true;
    private boolean m_bDeferRender = false;
    private boolean m_bInfo = true;
    private boolean m_bJQueryUI = false;
    private boolean m_bLengthChange = true;
    private boolean m_bOrdering = true;
    private boolean m_bPaging = true;
    private boolean m_bProcessing = false;
    private ETriState m_eScrollX = ETriState.UNDEFINED;
    private IJSExpression m_aScrollY;
    private boolean m_bSearching = true;
    private boolean m_bStateSave = false;
    private JQueryAjaxBuilder m_aAjaxBuilder;
    private JSAnonymousFunction m_aHeaderCallback;
    private JSAnonymousFunction m_aFooterCallback;
    private JSAnonymousFunction m_aInitComplete;
    private boolean m_bDeferLoading = false;
    private boolean m_bDestroy = false;
    private int m_nDisplayStart = 0;
    private DataTablesDom m_aDom;
    private DataTablesLayout m_aLayout;
    private IDataTablesLengthMenu m_aLengthMenu;
    private DataTablesOrder m_aInitialOrder;
    private int m_nPageLength = 10;
    private EDataTablesPagingType m_ePagingType = DEFAULT_PAGING_TYPE;
    private boolean m_bRetrieve = false;
    @Since(value="1.10.8")
    private boolean m_bScrollCollapse = false;
    private final ICommonsList<DataTablesColumnDef> m_aColumnDefs = new CommonsArrayList();
    private Locale m_aDisplayLocale;
    private ISimpleURL m_aTextLoadingURL;
    private String m_sTextLoadingURLLocaleParameterName;
    private final ICommonsOrderedMap<String, IDataTablesPlugin> m_aPlugins = new CommonsLinkedHashMap();
    private boolean m_bGenerateOnDocumentReady = DataTablesSettings.isDefaultGenerateOnDocumentReady();
    private EDataTablesFilterType m_eServerFilterType = EDataTablesFilterType.DEFAULT;
    private transient Consumer<JSPackage> m_aJSBeforeModifier;
    private transient BiConsumer<JSPackage, JSLet> m_aJSAfterModifier;

    public DataTables(@Nonnull IHCTable<?> iHCTable) {
        ValueEnforcer.notNull(iHCTable, (String)"Table");
        ValueEnforcer.notEmpty((CharSequence)iHCTable.getID(), (String)"Table must have an ID to work with DataTables!");
        HCColGroup hCColGroup = iHCTable.getColGroup();
        boolean bl = false;
        IHCNode[] iHCNodeArray = new IHCNode[iHCTable.getColumnCount()];
        if (hCColGroup != null) {
            int n = 0;
            for (IHCCol iHCCol : hCColGroup.getAllColumns()) {
                if (iHCCol instanceof DTCol) {
                    bl = true;
                    iHCNodeArray[n] = ((DTCol)iHCCol).getHeaderNode();
                }
                ++n;
            }
        }
        if (!iHCTable.hasHeaderRows()) {
            if (bl) {
                iHCTable.addHeaderRow().addCells(iHCNodeArray);
            } else {
                LOGGER.warn("Table does not have a header row so DataTables may not be displayed correctly!");
            }
        }
        this.m_aTable = iHCTable;
    }

    @Nonnull
    public final IHCTable<?> getTable() {
        return this.m_aTable;
    }

    @Nonnull
    public final String getTableID() {
        return this.m_aTable.getID();
    }

    public final int getGeneratedJSVariableSuffix() {
        return this.m_nGeneratedJSVariableSuffix;
    }

    @Nonnull
    @Nonempty
    public final String getJSVariableName() {
        return this.m_sJSVariableName;
    }

    @Nonnull
    public DataTables setJSVariableName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"JSVariableName");
        ValueEnforcer.isTrue((boolean)JSMarshaller.isJSIdentifier((String)string), () -> "JS Variable name is not an identifier: " + string);
        this.m_sJSVariableName = string;
        return this;
    }

    public boolean isAutoWidth() {
        return this.m_bAutoWidth;
    }

    @Nonnull
    public DataTables setAutoWidth(boolean bl) {
        this.m_bAutoWidth = bl;
        return this;
    }

    public boolean isDeferRender() {
        return this.m_bDeferRender;
    }

    @Nonnull
    public DataTables setDeferRender(boolean bl) {
        this.m_bDeferRender = bl;
        return this;
    }

    public boolean isInfo() {
        return this.m_bInfo;
    }

    @Nonnull
    public DataTables setInfo(boolean bl) {
        this.m_bInfo = bl;
        return this;
    }

    public boolean isJQueryUI() {
        return this.m_bJQueryUI;
    }

    @Nonnull
    public DataTables setJQueryUI(boolean bl) {
        this.m_bJQueryUI = bl;
        return this;
    }

    public boolean isLengthChange() {
        return this.m_bLengthChange;
    }

    @Nonnull
    public DataTables setLengthChange(boolean bl) {
        this.m_bLengthChange = bl;
        return this;
    }

    public boolean isOrdering() {
        return this.m_bOrdering;
    }

    @Nonnull
    public DataTables setOrdering(boolean bl) {
        this.m_bOrdering = bl;
        return this;
    }

    public boolean isPaging() {
        return this.m_bPaging;
    }

    @Nonnull
    public DataTables setPaging(boolean bl) {
        this.m_bPaging = bl;
        return this;
    }

    public boolean isProcessing() {
        return this.m_bProcessing;
    }

    @Nonnull
    public DataTables setProcessing(boolean bl) {
        this.m_bProcessing = bl;
        return this;
    }

    public boolean isScrollX() {
        return this.m_eScrollX.getAsBooleanValue(false);
    }

    @Nonnull
    public DataTables setScrollX(boolean bl) {
        this.m_eScrollX = ETriState.valueOf((boolean)bl);
        return this;
    }

    @Nullable
    public IJSExpression getScrollY() {
        return this.m_aScrollY;
    }

    @Nonnull
    public DataTables setScrollY(boolean bl) {
        return this.setScrollY((IJSExpression)JSExpr.lit((boolean)bl));
    }

    @Nonnull
    public DataTables setScrollY(int n) {
        return this.setScrollY((IJSExpression)JSExpr.lit((int)n));
    }

    @Nonnull
    public DataTables setScrollY(@Nonnull String string) {
        return this.setScrollY((IJSExpression)JSExpr.lit((String)string));
    }

    @Nonnull
    public DataTables setScrollY(@Nullable IJSExpression iJSExpression) {
        this.m_aScrollY = iJSExpression;
        return this;
    }

    public boolean isSearching() {
        return this.m_bSearching;
    }

    @Nonnull
    public DataTables setSearching(boolean bl) {
        this.m_bSearching = bl;
        return this;
    }

    public boolean isStateSave() {
        return this.m_bStateSave;
    }

    @Nonnull
    public DataTables setStateSave(boolean bl) {
        this.m_bStateSave = bl;
        return this;
    }

    @Nullable
    public JQueryAjaxBuilder getAjaxBuilder() {
        return this.m_aAjaxBuilder;
    }

    @Nonnull
    public DataTables setAjaxBuilder(@Nullable JQueryAjaxBuilder jQueryAjaxBuilder) {
        if (jQueryAjaxBuilder != null) {
            jQueryAjaxBuilder.cache(false).dataType("json");
        }
        this.m_aAjaxBuilder = jQueryAjaxBuilder;
        return this;
    }

    public boolean isServerSide() {
        return this.m_aAjaxBuilder != null;
    }

    public boolean isClientSide() {
        return this.m_aAjaxBuilder == null;
    }

    @Nonnull
    public EDataTablesFilterType getServerFilterType() {
        return this.m_eServerFilterType;
    }

    @Nonnull
    public DataTables setServerFilterType(@Nonnull EDataTablesFilterType eDataTablesFilterType) {
        this.m_eServerFilterType = (EDataTablesFilterType)((Object)ValueEnforcer.notNull((Object)((Object)eDataTablesFilterType), (String)"ServerFilterType"));
        return this;
    }

    @Nullable
    public JSAnonymousFunction getFooterCallback() {
        return this.m_aFooterCallback;
    }

    @Nonnull
    public DataTables setFooterCallback(@Nullable JSAnonymousFunction jSAnonymousFunction) {
        this.m_aFooterCallback = jSAnonymousFunction;
        return this;
    }

    @Nullable
    public JSAnonymousFunction getHeaderCallback() {
        return this.m_aHeaderCallback;
    }

    @Nonnull
    public DataTables setHeaderCallback(@Nullable JSAnonymousFunction jSAnonymousFunction) {
        this.m_aHeaderCallback = jSAnonymousFunction;
        return this;
    }

    @Nullable
    public JSAnonymousFunction getInitComplete() {
        return this.m_aInitComplete;
    }

    @Nonnull
    public DataTables setInitComplete(@Nullable JSAnonymousFunction jSAnonymousFunction) {
        this.m_aInitComplete = jSAnonymousFunction;
        return this;
    }

    public boolean isDeferLoading() {
        return this.m_bDeferLoading;
    }

    @Nonnull
    public DataTables setDeferLoading(boolean bl) {
        this.m_bDeferLoading = bl;
        return this;
    }

    public boolean isDestroy() {
        return this.m_bDestroy;
    }

    @Nonnull
    public DataTables setDestroy(boolean bl) {
        this.m_bDestroy = bl;
        return this;
    }

    @Nonnegative
    public int getDisplayStart() {
        return this.m_nDisplayStart;
    }

    @Nonnull
    public DataTables setDisplayStart(@Nonnegative int n) {
        this.m_nDisplayStart = n;
        return this;
    }

    @Nullable
    @ReturnsMutableCopy
    public DataTablesDom getDom() {
        return (DataTablesDom)CloneHelper.getCloneIfNotNull((ICloneable)this.m_aDom);
    }

    @Nullable
    @ReturnsMutableObject(value="design")
    public DataTablesDom directGetDom() {
        return this.m_aDom;
    }

    @Nonnull
    public DataTables setDom(@Nullable DataTablesDom dataTablesDom) {
        this.m_aDom = (DataTablesDom)CloneHelper.getCloneIfNotNull((ICloneable)dataTablesDom);
        return this;
    }

    @Nullable
    @ReturnsMutableCopy
    public DataTablesLayout getLayout() {
        return (DataTablesLayout)CloneHelper.getCloneIfNotNull((ICloneable)this.m_aLayout);
    }

    @Nullable
    @ReturnsMutableObject(value="design")
    public DataTablesLayout directGetLayout() {
        return this.m_aLayout;
    }

    @Nonnull
    public DataTables setLayout(@Nullable DataTablesLayout dataTablesLayout) {
        this.m_aLayout = (DataTablesLayout)CloneHelper.getCloneIfNotNull((ICloneable)dataTablesLayout);
        return this;
    }

    @Nullable
    public IDataTablesLengthMenu getLengthMenu() {
        return this.m_aLengthMenu;
    }

    @Nonnull
    public DataTables setLengthMenu(@Nullable IDataTablesLengthMenu iDataTablesLengthMenu) {
        this.m_aLengthMenu = iDataTablesLengthMenu;
        if (iDataTablesLengthMenu != null && !iDataTablesLengthMenu.isEmpty()) {
            this.setPageLength(iDataTablesLengthMenu.getItemAtIndex(0).getItemCount());
            this.setLengthChange(iDataTablesLengthMenu.getItemCount() > 1);
            this.setPaging(iDataTablesLengthMenu.getItemCount() > 1);
        }
        return this;
    }

    @Nullable
    public DataTablesOrder getInitialOrder() {
        return this.m_aInitialOrder;
    }

    @Nonnull
    public DataTables setInitialOrder(@Nullable DataTablesOrder dataTablesOrder) {
        this.m_aInitialOrder = dataTablesOrder;
        return this;
    }

    @CheckForSigned
    public int getPageLength() {
        return this.m_nPageLength;
    }

    @Nonnull
    public DataTables setPageLength(int n) {
        this.m_nPageLength = n;
        return this;
    }

    @Nonnull
    public DataTables setPageLengthAll() {
        return this.setPageLength(-1);
    }

    @Nullable
    public EDataTablesPagingType getPagingType() {
        return this.m_ePagingType;
    }

    @Nonnull
    public DataTables setPagingType(@Nullable EDataTablesPagingType eDataTablesPagingType) {
        this.m_ePagingType = eDataTablesPagingType;
        return this;
    }

    public boolean isRetrieve() {
        return this.m_bRetrieve;
    }

    @Nonnull
    public DataTables setRetrieve(boolean bl) {
        this.m_bRetrieve = bl;
        return this;
    }

    public boolean isScrollCollapse() {
        return this.m_bScrollCollapse;
    }

    @Nonnull
    public DataTables setScrollCollapse(boolean bl) {
        this.m_bScrollCollapse = bl;
        return this;
    }

    @Nonnull
    @ReturnsMutableObject
    public ICommonsList<DataTablesColumnDef> columnDefs() {
        return this.m_aColumnDefs;
    }

    @Nullable
    public DataTablesColumnDef findFirstColumnWithTarget(int n) {
        return (DataTablesColumnDef)this.m_aColumnDefs.findFirst(dataTablesColumnDef -> dataTablesColumnDef.hasTarget(n));
    }

    @Nonnull
    public DataTables addColumn(@Nonnull DataTablesColumnDef dataTablesColumnDef) {
        ValueEnforcer.notNull((Object)dataTablesColumnDef, (String)"Column");
        block0: for (int n : dataTablesColumnDef.getAllTargets()) {
            for (DataTablesColumnDef dataTablesColumnDef2 : this.m_aColumnDefs) {
                if (!dataTablesColumnDef2.hasTarget(n)) continue;
                LOGGER.warn("Another DataTablesColumn with target " + n + " is already contained!");
                continue block0;
            }
        }
        this.m_aColumnDefs.add((Object)dataTablesColumnDef);
        return this;
    }

    @Nonnull
    public DataTables addAllColumns(@Nonnull IHCTable<?> iHCTable) {
        ValueEnforcer.notNull(iHCTable, (String)"Table");
        HCColGroup hCColGroup = iHCTable.getColGroup();
        if (hCColGroup != null) {
            int n = 0;
            for (IHCCol iHCCol : hCColGroup.getAllColumns()) {
                DataTablesColumnDef dataTablesColumnDef;
                if (iHCCol instanceof DTCol) {
                    DTCol dTCol = (DTCol)iHCCol;
                    dataTablesColumnDef = new DataTablesColumnDef(n, dTCol);
                    if (dTCol.hasInitialSorting()) {
                        this.setInitialOrder(new DataTablesOrder().addColumn(n, dTCol.getInitialSorting()));
                    }
                } else {
                    dataTablesColumnDef = new DataTablesColumnDef(n);
                    if (!iHCCol.isStar()) {
                        dataTablesColumnDef.setWidth(iHCCol.getWidth());
                    }
                }
                this.addColumn(dataTablesColumnDef);
                ++n;
            }
        }
        return this;
    }

    @Nonnull
    public DataTables setAllColumnsOrderable(boolean bl) {
        for (DataTablesColumnDef dataTablesColumnDef : this.m_aColumnDefs) {
            dataTablesColumnDef.setOrderable(bl);
        }
        return this;
    }

    @Nonnull
    public DataTables setAllColumnsSearchable(boolean bl) {
        for (DataTablesColumnDef dataTablesColumnDef : this.m_aColumnDefs) {
            dataTablesColumnDef.setSearchable(bl);
        }
        return this;
    }

    public boolean hasAnyInvisibleColumn() {
        for (DataTablesColumnDef dataTablesColumnDef : this.m_aColumnDefs) {
            if (dataTablesColumnDef.isVisible()) continue;
            return true;
        }
        return false;
    }

    @Nonnegative
    public int getVisibleColumnCount() {
        int n = 0;
        for (DataTablesColumnDef dataTablesColumnDef : this.m_aColumnDefs) {
            if (!dataTablesColumnDef.isVisible()) continue;
            ++n;
        }
        return n;
    }

    @Nullable
    public Locale getDisplayLocale() {
        return this.m_aDisplayLocale;
    }

    @Nonnull
    public DataTables setDisplayLocale(@Nullable Locale locale) {
        this.m_aDisplayLocale = locale;
        return this;
    }

    @Nullable
    public ISimpleURL getTextLoadingURL() {
        return this.m_aTextLoadingURL;
    }

    @Nullable
    public String getextLoadingURLLocaleParameterName() {
        return this.m_sTextLoadingURLLocaleParameterName;
    }

    @Nonnull
    public DataTables setNoTextLoadingURL() {
        return this.setTextLoadingURL(null, null);
    }

    @Nonnull
    public DataTables setTextLoadingURL(@Nullable ISimpleURL iSimpleURL, @Nullable String string) {
        if (iSimpleURL != null && StringHelper.isEmpty((String)string)) {
            throw new IllegalArgumentException("If a text loading URL is present, a text loading URL locale parameter name must also be present");
        }
        this.m_aTextLoadingURL = iSimpleURL;
        this.m_sTextLoadingURLLocaleParameterName = string;
        return this;
    }

    @Nonnull
    public DataTables addPlugin(@Nonnull IDataTablesPlugin iDataTablesPlugin) {
        ValueEnforcer.notNull((Object)iDataTablesPlugin, (String)"Plugin");
        String string = iDataTablesPlugin.getName();
        if (this.m_aPlugins.containsKey((Object)string)) {
            throw new IllegalArgumentException("A plugin with the name '" + string + "' is already contained!");
        }
        this.m_aPlugins.put((Object)string, (Object)iDataTablesPlugin);
        return this;
    }

    @Nonnull
    public EChange removePlugin(@Nonnull String string) {
        if (StringHelper.isEmpty((String)string)) {
            return EChange.UNCHANGED;
        }
        return EChange.valueOf((this.m_aPlugins.remove((Object)string) != null ? 1 : 0) != 0);
    }

    @Nullable
    public IDataTablesPlugin getPluginOfName(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        return (IDataTablesPlugin)this.m_aPlugins.get((Object)string);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IDataTablesPlugin> getAllPlugins() {
        return this.m_aPlugins.copyOfValues();
    }

    public boolean isGenerateOnDocumentReady() {
        return this.m_bGenerateOnDocumentReady;
    }

    @Nonnull
    public DataTables setGenerateOnDocumentReady(boolean bl) {
        this.m_bGenerateOnDocumentReady = bl;
        return this;
    }

    @Nullable
    public Consumer<JSPackage> getJSBeforeModifier() {
        return this.m_aJSBeforeModifier;
    }

    @Nonnull
    public DataTables setJSBeforeModifier(@Nullable Consumer<JSPackage> consumer) {
        this.m_aJSBeforeModifier = consumer;
        return this;
    }

    @Nullable
    public BiConsumer<JSPackage, JSLet> getJSAfterModifier() {
        return this.m_aJSAfterModifier;
    }

    @Nonnull
    public DataTables setJSAfterModifier(@Nullable BiConsumer<JSPackage, JSLet> biConsumer) {
        this.m_aJSAfterModifier = biConsumer;
        return this;
    }

    @OverrideOnDemand
    protected void modifyParams(@Nonnull JSAssocArray jSAssocArray) {
    }

    @Nonnull
    public static IJsonObject createLanguageJson(@Nonnull Locale locale) {
        ValueEnforcer.notNull((Object)locale, (String)"DisplayLocale");
        JsonObject jsonObject = new JsonObject();
        IJsonObject iJsonObject = (IJsonObject)((IJsonObject)((IJsonObject)new JsonObject().add((Object)"orderable", (Object)EDataTablesText.ARIA_ORDERABLE.getDisplayText(locale))).add((Object)"orderableReverse", (Object)EDataTablesText.ARIA_ORDERABLE_REVERSE.getDisplayText(locale))).add((Object)"orderableRemove", (Object)EDataTablesText.ARIA_ORDERABLE_REMOVE.getDisplayText(locale));
        iJsonObject.add((Object)"paginate", (IAddableByTrait)((IJson)((IJsonObject)((IJsonObject)((IJsonObject)((IJsonObject)new JsonObject().add((Object)"first", (Object)EDataTablesText.PAGINATE_FIRST.getDisplayText(locale))).add((Object)"last", (Object)EDataTablesText.PAGINATE_LAST.getDisplayText(locale))).add((Object)"next", (Object)EDataTablesText.PAGINATE_NEXT.getDisplayText(locale))).add((Object)"previous", (Object)EDataTablesText.PAGINATE_PREVIOUS.getDisplayText(locale))).add((Object)"number", (Object)EDataTablesText.PAGINATE_NUMBER.getDisplayText(locale))));
        jsonObject.add((Object)"aria", (IAddableByTrait)iJsonObject);
        jsonObject.add((Object)"entries", (IAddableByTrait)((IJson)((IJsonObject)new JsonObject().add((Object)"_", (Object)EDataTablesText.ENTRIES_N.getDisplayText(locale))).add((Object)"1", (Object)EDataTablesText.ENTRIES_1.getDisplayText(locale))));
        jsonObject.add((Object)"emptyTable", (Object)EDataTablesText.EMPTY_TABLE.getDisplayText(locale));
        jsonObject.add((Object)"info", (Object)EDataTablesText.INFO.getDisplayText(locale));
        jsonObject.add((Object)"infoEmpty", (Object)EDataTablesText.INFO_EMPTY.getDisplayText(locale));
        jsonObject.add((Object)"infoFiltered", (Object)EDataTablesText.INFO_FILTERED.getDisplayText(locale));
        jsonObject.add((Object)"infoPostFix", (Object)EDataTablesText.INFO_POSTFIX.getDisplayText(locale));
        jsonObject.add((Object)"decimal", DecimalFormatSymbols.getInstance(locale).getDecimalSeparator());
        jsonObject.add((Object)"thousands", (Object)EDataTablesText.THOUSANDS.getDisplayText(locale));
        jsonObject.add((Object)"lLengthMenu", (Object)EDataTablesText.LENGTH_MENU.getDisplayText(locale));
        jsonObject.add((Object)"loadingRecords", (Object)EDataTablesText.LOADING_RECORDS.getDisplayText(locale));
        jsonObject.add((Object)"processing", (Object)EDataTablesText.PROCESSING.getDisplayText(locale));
        jsonObject.add((Object)"search", (Object)EDataTablesText.SEARCH.getDisplayText(locale));
        jsonObject.add((Object)"searchPlaceholder", (Object)EDataTablesText.SEARCH_PLACEHOLDER.getDisplayText(locale));
        jsonObject.add((Object)"url", (Object)"");
        jsonObject.add((Object)"zeroRecords", (Object)EDataTablesText.ZERO_RECORDS.getDisplayText(locale));
        return jsonObject;
    }

    @Nonnull
    public JQueryInvocation invokeDataTables() {
        return JQuery.idRef(this.m_aTable).jqinvoke("dataTable");
    }

    @Nonnull
    public JQueryInvocation invokeDataTablesAPI() {
        return JQuery.idRef(this.m_aTable).jqinvoke("DataTable");
    }

    @Nonnull
    public static JSInvocation invokeDataTablesMoment() {
        return JQuery.fn().ref("dataTable").invoke("moment");
    }

    private void _applyClientSideSortingSettings() {
        if (this.isClientSide()) {
            EnumSet<EDTColType> enumSet = EnumSet.noneOf(EDTColType.class);
            for (IHCCol iHCCol : this.m_aTable.getAllColumns()) {
                EDTColType eDTColType;
                if (!(iHCCol instanceof DTCol) || (eDTColType = ((DTCol)iHCCol).getColType()) == null || !eDTColType.isDateTimeType()) continue;
                enumSet.add(eDTColType);
            }
            if (!enumSet.isEmpty()) {
                this.addPlugin(new DataTablesPluginClientSortingDate(enumSet));
            }
        }
    }

    @OverridingMethodsMustInvokeSuper
    protected void onFinalizeNodeState(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
        Object object5;
        Object object22;
        Object object32;
        this._applyClientSideSortingSettings();
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (Object object32 : this.m_aPlugins.values()) {
            if (object32.canBeApplied(this)) {
                commonsArrayList.add(object32);
                continue;
            }
            LOGGER.warn("Plugin '" + object32.getName() + "' cannot be applied to DataTable '" + this.getTableID() + "'");
        }
        for (Object object32 : commonsArrayList) {
            object32.finalizeDataTablesSettings(this);
        }
        Iterator iterator = new JSAssocArray();
        if (!this.m_bAutoWidth) {
            iterator.add("autoWidth", this.m_bAutoWidth);
        }
        if (this.m_bDeferRender) {
            iterator.add("deferRender", this.m_bDeferRender);
        }
        if (!this.m_bInfo) {
            iterator.add("info", this.m_bInfo);
        }
        if (this.m_bJQueryUI) {
            iterator.add("jQueryUI", this.m_bJQueryUI);
        }
        if (!this.m_bLengthChange) {
            iterator.add("lengthChange", this.m_bLengthChange);
        }
        if (!this.m_bOrdering) {
            iterator.add("ordering", this.m_bOrdering);
        }
        if (!this.m_bPaging) {
            iterator.add("paging", this.m_bPaging);
        }
        if (this.m_bProcessing) {
            iterator.add("processing", this.m_bProcessing);
        }
        if (this.m_eScrollX.isDefined()) {
            iterator.add("scrollX", this.m_eScrollX.getAsBooleanValue(false));
        }
        if (this.m_aScrollY != null) {
            iterator.add("scrollY", this.m_aScrollY);
        }
        if (!this.m_bSearching) {
            iterator.add("searching", this.m_bSearching);
        }
        if (this.m_bStateSave) {
            iterator.add("stateSave", this.m_bStateSave);
        }
        if (this.isServerSide()) {
            iterator.add("serverSide", true);
            object32 = new DataTablesServerData(this.m_aTable, (List<DataTablesColumnDef>)this.m_aColumnDefs, this.m_aDisplayLocale, this.m_eServerFilterType);
            UIStateRegistry.getCurrent().registerState(this.m_aTable.getID(), (IHasUIState)object32);
            this.m_aTable.removeAllBodyRows();
            object22 = new JSAnonymousFunction();
            object5 = object22.param("data");
            Object object4 = object22.param("callback");
            object22.param("settings");
            object22.body().add((IJSStatement)this.m_aAjaxBuilder.getClone().data((IJSExpression)((JQueryInvocation)JQuery.extend().arg((IJSExpression)object5)).arg(this.m_aAjaxBuilder.data())).success(JSJQueryHelper.jqueryAjaxSuccessHandler((IJSExpression)object4, null)).build());
            iterator.add("ajax", (IJSExpression)object22);
            JSJQueryHelper.registerExternalResources();
        } else {
            iterator.add("serverSide", false);
        }
        if (this.m_aFooterCallback != null) {
            iterator.add("footerCallback", (IJSExpression)this.m_aFooterCallback);
        }
        if (this.m_aHeaderCallback != null) {
            iterator.add("headerCallback", (IJSExpression)this.m_aHeaderCallback);
        }
        if (this.m_aInitComplete != null) {
            iterator.add("initComplete", (IJSExpression)this.m_aInitComplete);
        }
        if (this.m_bDeferLoading) {
            iterator.add("deferLoading", this.m_bDeferLoading);
        }
        if (this.m_bDestroy) {
            iterator.add("destroy", this.m_bDestroy);
        }
        if (this.m_nDisplayStart != 0) {
            iterator.add("displayStart", this.m_nDisplayStart);
        }
        if (this.m_aDom != null) {
            iterator.add("dom", this.m_aDom.getAsString());
        }
        if (this.m_aLayout != null) {
            iterator.add("layout", (IJSExpression)this.m_aLayout.getAsJSAssocArray());
        }
        if (this.m_aLengthMenu != null && !this.m_aLengthMenu.isEmpty()) {
            object32 = this.m_aDisplayLocale != null ? this.m_aDisplayLocale : Locale.US;
            iterator.add("lengthMenu", (IJSExpression)this.m_aLengthMenu.getAsJSArray((Locale)object32));
        }
        iterator.add("order", (IJSExpression)(this.m_aInitialOrder != null ? this.m_aInitialOrder.getAsJS() : new JSArray()));
        if (this.m_nPageLength != 10 && this.m_bLengthChange) {
            iterator.add("pageLength", this.m_nPageLength);
        }
        if (this.m_ePagingType != null && this.m_bPaging) {
            iterator.add("pagingType", this.m_ePagingType.getName());
        }
        if (this.m_bRetrieve) {
            iterator.add("retrieve", this.m_bRetrieve);
        }
        if (this.m_bScrollCollapse) {
            iterator.add("scrollCollapse", this.m_bScrollCollapse);
        }
        if (!this.m_aColumnDefs.isEmpty()) {
            object32 = new JSArray();
            for (Object object5 : this.m_aColumnDefs) {
                object32.add((IJSExpression)((DataTablesColumnDef)object5).getAsJS());
            }
            iterator.add("columnDefs", (IJSExpression)object32);
        }
        if (this.m_aDisplayLocale != null) {
            if (this.m_aTextLoadingURL != null) {
                object22 = new SimpleURL((IURLData)this.m_aTextLoadingURL).add(this.m_sTextLoadingURLLocaleParameterName, this.m_aDisplayLocale.getLanguage());
                object32 = (IJsonObject)new JsonObject().add((Object)"url", (Object)object22.getAsString());
            } else {
                object32 = DataTables.createLanguageJson(this.m_aDisplayLocale);
            }
            iterator.add("language", (IJson)object32);
        }
        for (Object object22 : commonsArrayList) {
            object5 = object22.getInitParams();
            if (object5 == null) continue;
            iterator.add(object22.getName(), (IJSExpression)object5);
        }
        if (this.hasAnyInvisibleColumn()) {
            this.m_aTable.removeAllColumns();
        }
        this.modifyParams((JSAssocArray)iterator);
        object32 = new JSPackage();
        if (this.m_aJSBeforeModifier != null) {
            this.m_aJSBeforeModifier.accept((JSPackage)object32);
        }
        object22 = object32.let(this.m_sJSVariableName, (IJSExpression)this.invokeDataTables().arg((IJSExpression)iterator));
        for (Object object4 : commonsArrayList) {
            object4.addInitJS(this, (JSPackage)object32, (JSLet)object22);
        }
        if (this.m_aJSAfterModifier != null) {
            this.m_aJSAfterModifier.accept((JSPackage)object32, (JSLet)object22);
        }
        this.setJSCodeProvider((IHasJSCode)(this.m_bGenerateOnDocumentReady ? HCSettings.getOnDocumentReadyProvider().createOnDocumentReady((IHasJSCode)object32) : object32));
        super.onFinalizeNodeState(iHCConversionSettingsToNode, iHCHasChildrenMutable);
    }

    @OverridingMethodsMustInvokeSuper
    protected void onRegisterExternalResources(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, boolean bl) {
        super.onRegisterExternalResources(iHCConversionSettingsToNode, bl);
        PhotonJS.registerJSIncludeForThisRequest((IJSPathProvider)EDataTablesJSPathProvider.DATATABLES);
        PhotonCSS.registerCSSIncludeForThisRequest((ICSSPathProvider)EDataTablesCSSPathProvider.DATATABLES);
        for (IDataTablesPlugin iDataTablesPlugin : this.m_aPlugins.values()) {
            if (!iDataTablesPlugin.canBeApplied(this)) continue;
            iDataTablesPlugin.registerExternalResources(iHCConversionSettingsToNode);
        }
    }
}

