/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.nav;

import com.helger.html.EHTMLRole;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.IHCElement;
import com.helger.html.hc.html.grouping.AbstractHCLI;
import com.helger.html.hc.impl.HCTextNode;
import com.helger.photon.bootstrap4.CBootstrapCSS;
import com.helger.photon.bootstrap4.dropdown.BootstrapDropdownMenu;
import com.helger.photon.bootstrap4.nav.BootstrapNavLink;
import com.helger.url.ISimpleURL;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class BootstrapNavItem
extends AbstractHCLI<BootstrapNavItem> {
    public static final boolean DEFAULT_ACTIVE = false;
    public static final boolean DEFAULT_DROP_DOWN = false;
    private boolean m_bIsActive = false;
    private boolean m_bIsDropDown = false;

    public final boolean isActive() {
        return this.m_bIsActive;
    }

    @Nonnull
    public final BootstrapNavItem setActive(boolean bl) {
        this.m_bIsActive = bl;
        return this;
    }

    public final boolean isDropDown() {
        return this.m_bIsDropDown;
    }

    @Nonnull
    public BootstrapNavLink addNavLink() {
        return (BootstrapNavLink)this.addAndReturnChild((IHCNode)new BootstrapNavLink());
    }

    @Nonnull
    public BootstrapNavLink addNavLink(@Nullable ISimpleURL iSimpleURL) {
        return (BootstrapNavLink)this.addAndReturnChild((IHCNode)new BootstrapNavLink(iSimpleURL));
    }

    public void addNavDropDown(@Nonnull String string, @Nonnull BootstrapDropdownMenu bootstrapDropdownMenu) {
        this.addNavDropDown((IHCNode)new HCTextNode(string), bootstrapDropdownMenu);
    }

    public void addNavDropDown(@Nonnull IHCNode iHCNode, @Nonnull BootstrapDropdownMenu bootstrapDropdownMenu) {
        BootstrapNavLink bootstrapNavLink = new BootstrapNavLink();
        ((BootstrapNavLink)((BootstrapNavLink)bootstrapNavLink.addClass(CBootstrapCSS.DROPDOWN_TOGGLE)).ensureID()).setRole(EHTMLRole.BUTTON);
        bootstrapNavLink.customAttrs().setDataAttr("toggle", "dropdown");
        bootstrapNavLink.customAttrs().setAriaHasPopup(true);
        bootstrapNavLink.customAttrs().setAriaExpanded(true);
        bootstrapNavLink.addChild(iHCNode);
        bootstrapDropdownMenu.customAttrs().setAriaLabeledBy((IHCElement)bootstrapNavLink);
        this.addChild((IHCNode)bootstrapNavLink);
        this.addChild((IHCNode)bootstrapDropdownMenu);
        this.m_bIsDropDown = true;
    }

    protected void onFinalizeNodeState(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
        super.onFinalizeNodeState(iHCConversionSettingsToNode, iHCHasChildrenMutable);
        this.addClass(CBootstrapCSS.NAV_ITEM);
        if (this.m_bIsActive) {
            this.addClass(CBootstrapCSS.ACTIVE);
        }
        if (this.m_bIsDropDown) {
            this.addClass(CBootstrapCSS.DROPDOWN);
        }
    }
}

