/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.grid;

import com.helger.html.css.ICSSClassProvider;
import com.helger.photon.bootstrap4.CBootstrapCSS;
import com.helger.photon.bootstrap4.grid.EBootstrapGridType;
import com.helger.photon.bootstrap4.grid.IBootstrapGridElement;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public enum EBootstrapGridXL implements IBootstrapGridElement
{
    XL_1(1, CBootstrapCSS.COL_XL_1, CBootstrapCSS.OFFSET_XL_1),
    XL_2(2, CBootstrapCSS.COL_XL_2, CBootstrapCSS.OFFSET_XL_2),
    XL_3(3, CBootstrapCSS.COL_XL_3, CBootstrapCSS.OFFSET_XL_3),
    XL_4(4, CBootstrapCSS.COL_XL_4, CBootstrapCSS.OFFSET_XL_4),
    XL_5(5, CBootstrapCSS.COL_XL_5, CBootstrapCSS.OFFSET_XL_5),
    XL_6(6, CBootstrapCSS.COL_XL_6, CBootstrapCSS.OFFSET_XL_6),
    XL_7(7, CBootstrapCSS.COL_XL_7, CBootstrapCSS.OFFSET_XL_7),
    XL_8(8, CBootstrapCSS.COL_XL_8, CBootstrapCSS.OFFSET_XL_8),
    XL_9(9, CBootstrapCSS.COL_XL_9, CBootstrapCSS.OFFSET_XL_9),
    XL_10(10, CBootstrapCSS.COL_XL_10, CBootstrapCSS.OFFSET_XL_10),
    XL_11(11, CBootstrapCSS.COL_XL_11, CBootstrapCSS.OFFSET_XL_11),
    XL_12(12, CBootstrapCSS.COL_XL_12, null),
    AUTO(-2, CBootstrapCSS.COL_XL_AUTO, null),
    EVENLY(-3, CBootstrapCSS.COL_XL, null);

    private final int m_nParts;
    private final ICSSClassProvider m_aCSSClass;
    private final ICSSClassProvider m_aCSSClassOffset;

    private EBootstrapGridXL(@Nullable int n2, ICSSClassProvider iCSSClassProvider, ICSSClassProvider iCSSClassProvider2) {
        this.m_nParts = n2;
        this.m_aCSSClass = iCSSClassProvider;
        this.m_aCSSClassOffset = iCSSClassProvider2;
    }

    @Override
    @Nonnull
    public EBootstrapGridType getGridType() {
        return EBootstrapGridType.XL;
    }

    @Override
    public int getParts() {
        return this.m_nParts;
    }

    @Nullable
    public String getCSSClass() {
        return this.m_aCSSClass == null ? null : this.m_aCSSClass.getCSSClass();
    }

    @Nullable
    public ICSSClassProvider getCSSClassOffset() {
        return this.m_aCSSClassOffset;
    }

    @Override
    public boolean isMax() {
        return this == XL_12;
    }

    @Nullable
    public static EBootstrapGridXL getFromParts(int n) {
        switch (n) {
            case 1: {
                return XL_1;
            }
            case 2: {
                return XL_2;
            }
            case 3: {
                return XL_3;
            }
            case 4: {
                return XL_4;
            }
            case 5: {
                return XL_5;
            }
            case 6: {
                return XL_6;
            }
            case 7: {
                return XL_7;
            }
            case 8: {
                return XL_8;
            }
            case 9: {
                return XL_9;
            }
            case 10: {
                return XL_10;
            }
            case 11: {
                return XL_11;
            }
            case 12: {
                return XL_12;
            }
            case -2: {
                return AUTO;
            }
            case -3: {
                return EVENLY;
            }
        }
        return null;
    }
}

