/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.form;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.diagnostics.error.IError;
import com.helger.diagnostics.error.list.IErrorList;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.IHCElement;
import com.helger.html.hc.html.IHCElementWithChildren;
import com.helger.html.hc.html.forms.AbstractHCCheckBox;
import com.helger.html.hc.html.forms.AbstractHCRadioButton;
import com.helger.html.hc.html.forms.EHCInputType;
import com.helger.html.hc.html.forms.HCCtrlHelper;
import com.helger.html.hc.html.forms.IHCControl;
import com.helger.html.hc.html.forms.IHCInput;
import com.helger.html.hc.html.forms.IHCTextArea;
import com.helger.html.hc.html.grouping.AbstractHCDiv;
import com.helger.html.hc.html.grouping.HCDiv;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.photon.bootstrap4.CBootstrapCSS;
import com.helger.photon.bootstrap4.form.BootstrapFormGroup;
import com.helger.photon.bootstrap4.form.BootstrapFormHelper;
import com.helger.photon.bootstrap4.form.IBootstrapFormGroupContainer;
import com.helger.photon.bootstrap4.form.IBootstrapFormGroupRenderer;
import com.helger.photon.bootstrap4.grid.BootstrapRow;
import com.helger.photon.uicore.html.formlabel.HCFormLabel;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Iterator;
import java.util.Locale;

@NotThreadSafe
public class DefaultBootstrapFormGroupRenderer
implements IBootstrapFormGroupRenderer {
    private boolean m_bUseIcons = false;
    private boolean m_bForceNoCheckBoxHandling = false;

    @Override
    public boolean isUseIcons() {
        return this.m_bUseIcons;
    }

    @Override
    @Nonnull
    public DefaultBootstrapFormGroupRenderer setUseIcons(boolean bl) {
        this.m_bUseIcons = bl;
        return this;
    }

    public boolean isForceNoCheckBoxHandling() {
        return this.m_bForceNoCheckBoxHandling;
    }

    @Nonnull
    public DefaultBootstrapFormGroupRenderer setForceNoCheckBoxHandling(boolean bl) {
        this.m_bForceNoCheckBoxHandling = bl;
        return this;
    }

    @OverrideOnDemand
    protected void modifyFirstControlIfLabelIsPresent(@Nonnull IHCElementWithChildren<?> iHCElementWithChildren, @Nonnull IHCControl<?> iHCControl) {
        IHCTextArea iHCTextArea;
        if (iHCControl instanceof IHCInput) {
            IHCInput iHCInput = (IHCInput)iHCControl;
            EHCInputType eHCInputType = iHCInput.getType();
            if (eHCInputType != null && eHCInputType.hasPlaceholder() && !iHCInput.hasPlaceholder()) {
                iHCInput.setPlaceholder(BootstrapFormHelper.getDefaultPlaceholderText(iHCElementWithChildren));
            }
        } else if (iHCControl instanceof IHCTextArea && !(iHCTextArea = (IHCTextArea)iHCControl).hasPlaceholder()) {
            iHCTextArea.setPlaceholder(BootstrapFormHelper.getDefaultPlaceholderText(iHCElementWithChildren));
        }
    }

    @Nonnull
    @OverrideOnDemand
    protected IHCElementWithChildren<?> createHelpTextNode(@Nonnull IHCNode iHCNode) {
        return BootstrapFormHelper.createDefaultHelpTextNode(iHCNode);
    }

    @Nullable
    @OverrideOnDemand
    protected IHCElement<?> createSingleErrorNode(@Nonnull IError iError, @Nonnull Locale locale) {
        return BootstrapFormHelper.createDefaultErrorNode(iError, locale);
    }

    @OverrideOnDemand
    protected void modifyFinalNode(@Nonnull IBootstrapFormGroupContainer<?> iBootstrapFormGroupContainer, @Nonnull BootstrapFormGroup bootstrapFormGroup, @Nonnull AbstractHCDiv<?> abstractHCDiv) {
    }

    @Nonnull
    public AbstractHCDiv<?> renderFormGroup(@Nonnull IBootstrapFormGroupContainer<?> iBootstrapFormGroupContainer, @Nonnull BootstrapFormGroup bootstrapFormGroup, @Nonnull Locale locale) {
        boolean bl;
        boolean bl2;
        AbstractHCDiv abstractHCDiv;
        IHCElementWithChildren<?> iHCElementWithChildren2;
        IHCControl iHCControl;
        HCFormLabel hCFormLabel = bootstrapFormGroup.getLabel();
        IHCNode iHCNode = bootstrapFormGroup.getCtrl();
        IHCNode iHCNode2 = bootstrapFormGroup.getHelpText();
        IErrorList iErrorList = bootstrapFormGroup.getErrorList();
        boolean bl3 = iBootstrapFormGroupContainer.getFormType().isInline();
        ICommonsList iCommonsList = HCCtrlHelper.getAllHCControls((IHCNode)iHCNode);
        if (iCommonsList.isNotEmpty()) {
            iHCControl = (IHCControl)iCommonsList.getFirstOrNull();
            BootstrapFormHelper.markAsFormControls((Iterable<? extends IHCNode>)iCommonsList);
            BootstrapFormHelper.connectFormControlsWithLabel(iCommonsList, hCFormLabel);
            BootstrapFormHelper.applyFormControlValidityState(iCommonsList, iErrorList);
        } else {
            iHCControl = null;
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (iErrorList != null) {
            for (IHCElementWithChildren<?> iHCElementWithChildren2 : iErrorList) {
                abstractHCDiv = this.createSingleErrorNode((IError)iHCElementWithChildren2, locale);
                if (iHCControl == null) {
                    abstractHCDiv.addClass(CBootstrapCSS.D_BLOCK);
                }
                commonsArrayList.add(abstractHCDiv);
            }
        }
        BootstrapFormHelper.connectFormControlsWithErrors(iCommonsList, commonsArrayList);
        Iterator iterator = new HCNodeList();
        iterator.addChildren((Iterable)commonsArrayList);
        iHCElementWithChildren2 = null;
        if (iHCNode2 != null && iHCNode != null) {
            iHCElementWithChildren2 = this.createHelpTextNode(iHCNode2);
            if (bl3) {
                iHCElementWithChildren2.addClass(CBootstrapCSS.SR_ONLY);
            }
            BootstrapFormHelper.connectFormControlsWithHelpText(iCommonsList, iHCElementWithChildren2);
        }
        if (this.m_bForceNoCheckBoxHandling || iCommonsList.size() != 1) {
            bl2 = false;
            bl = false;
        } else {
            bl2 = iHCControl instanceof AbstractHCCheckBox;
            bl = iHCControl instanceof AbstractHCRadioButton;
        }
        if (bl2 || bl) {
            iHCControl.addClass(CBootstrapCSS.FORM_CHECK_INPUT);
            HCDiv hCDiv = (HCDiv)((HCDiv)new HCDiv().addClass(CBootstrapCSS.FORM_CHECK)).addChild(iHCNode);
            if (bl3) {
                if (hCFormLabel != null) {
                    hCFormLabel.addClass(CBootstrapCSS.FORM_CHECK_LABEL);
                    hCDiv.addChild((IHCNode)hCFormLabel);
                    this.modifyFirstControlIfLabelIsPresent((IHCElementWithChildren<?>)hCFormLabel, (IHCControl<?>)iHCControl);
                }
                abstractHCDiv = (AbstractHCDiv)((HCDiv)((HCDiv)hCDiv.addClass(CBootstrapCSS.MR_SM_2)).addChild((IHCNode)iterator)).addChild(iHCElementWithChildren2);
            } else {
                if (hCFormLabel != null) {
                    hCFormLabel.addClass(CBootstrapCSS.FORM_CHECK_LABEL);
                    hCDiv.addChild((IHCNode)hCFormLabel);
                    this.modifyFirstControlIfLabelIsPresent((IHCElementWithChildren<?>)hCFormLabel, (IHCControl<?>)iHCControl);
                }
                HCDiv hCDiv2 = (HCDiv)((HCDiv)((HCDiv)new HCDiv().addChild((IHCNode)hCDiv)).addChild((IHCNode)iterator)).addChild(iHCElementWithChildren2);
                if (!bl3) {
                    iBootstrapFormGroupContainer.getLeft().applyOffsetTo(hCDiv2);
                    iBootstrapFormGroupContainer.getRight().applyTo(hCDiv2);
                }
                abstractHCDiv = bl3 ? new HCDiv() : new BootstrapRow();
                ((AbstractHCDiv)abstractHCDiv.addClass(CBootstrapCSS.FORM_GROUP)).addChild((IHCNode)hCDiv2);
            }
        } else if (bl3) {
            if (iHCControl != null) {
                iHCControl.addClass(CBootstrapCSS.MR_SM_2);
            }
            HCDiv hCDiv = (HCDiv)((HCDiv)((HCDiv)new HCDiv().addChild(iHCNode)).addChild((IHCNode)iterator)).addChild(iHCElementWithChildren2);
            if (hCFormLabel == null || hCFormLabel.hasNoChildren()) {
                abstractHCDiv = hCDiv;
            } else {
                hCFormLabel.addClass(CBootstrapCSS.SR_ONLY);
                if (iHCControl != null) {
                    this.modifyFirstControlIfLabelIsPresent((IHCElementWithChildren<?>)hCFormLabel, (IHCControl<?>)iHCControl);
                }
                abstractHCDiv = (AbstractHCDiv)((HCDiv)new HCDiv().addChild((IHCNode)hCFormLabel)).addChild((IHCNode)hCDiv);
            }
        } else {
            abstractHCDiv = (AbstractHCDiv)new BootstrapRow().addClass(CBootstrapCSS.FORM_GROUP);
            HCDiv hCDiv = (HCDiv)((HCDiv)((HCDiv)new HCDiv().addChild(iHCNode)).addChild((IHCNode)iterator)).addChild(iHCElementWithChildren2);
            iBootstrapFormGroupContainer.getRight().applyTo(hCDiv);
            if (hCFormLabel == null || hCFormLabel.hasNoChildren()) {
                if (!bl3) {
                    iBootstrapFormGroupContainer.getLeft().applyOffsetTo(hCDiv);
                }
                abstractHCDiv.addChild((IHCNode)hCDiv);
            } else {
                if (bl3) {
                    hCFormLabel.addClass(CBootstrapCSS.SR_ONLY);
                }
                if (iHCControl != null) {
                    this.modifyFirstControlIfLabelIsPresent((IHCElementWithChildren<?>)hCFormLabel, (IHCControl<?>)iHCControl);
                }
                if (!bl3) {
                    iBootstrapFormGroupContainer.getLeft().applyTo(hCFormLabel);
                }
                ((AbstractHCDiv)abstractHCDiv.addChild((IHCNode)hCFormLabel)).addChild((IHCNode)hCDiv);
            }
        }
        bootstrapFormGroup.applyBasicHTMLTo((IHCElement<?>)abstractHCDiv);
        this.modifyFinalNode(iBootstrapFormGroupContainer, bootstrapFormGroup, abstractHCDiv);
        return abstractHCDiv;
    }
}

