/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.uictrls.ext;

import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.lang.clazz.FactoryNewInstance;
import com.helger.collection.commons.ICommonsMap;
import com.helger.html.css.DefaultCSSClassProvider;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.IHCElement;
import com.helger.html.hc.html.grouping.HCLI;
import com.helger.html.hc.html.grouping.HCUL;
import com.helger.html.hc.html.textlevel.HCA;
import com.helger.html.hc.impl.HCTextNode;
import com.helger.photon.bootstrap4.CBootstrapCSS;
import com.helger.photon.bootstrap4.card.BootstrapCard;
import com.helger.photon.core.execcontext.ILayoutExecutionContext;
import com.helger.photon.core.execcontext.ISimpleWebExecutionContext;
import com.helger.photon.core.menu.IMenuItemDeterminatorCallback;
import com.helger.photon.core.menu.IMenuItemExternal;
import com.helger.photon.core.menu.IMenuItemPage;
import com.helger.photon.core.menu.IMenuSeparator;
import com.helger.photon.core.menu.IMenuTree;
import com.helger.photon.core.menu.MenuItemDeterminatorCallback;
import com.helger.photon.core.menu.ui.AbstractMenuItemRenderer;
import com.helger.photon.core.menu.ui.IMenuItemRenderer;
import com.helger.photon.core.menu.ui.MenuRendererCallback;
import com.helger.tree.withid.DefaultTreeItemWithID;
import com.helger.url.ISimpleURL;
import jakarta.annotation.Nonnull;
import java.util.Locale;
import java.util.function.Supplier;

public class BootstrapMenuItemRenderer
extends AbstractMenuItemRenderer<HCUL> {
    private static final ICSSClassProvider CSS_CLASS_SEPARATOR = DefaultCSSClassProvider.create((String)"menu-separator");

    public BootstrapMenuItemRenderer(@Nonnull Locale locale) {
        super(locale);
    }

    @Nonnull
    public IHCNode renderSeparator(@Nonnull ISimpleWebExecutionContext iSimpleWebExecutionContext, @Nonnull IMenuSeparator iMenuSeparator) {
        return new HCLI().addClass(CSS_CLASS_SEPARATOR);
    }

    @Nonnull
    @OverrideOnDemand
    protected String getMenuItemPageLabel(@Nonnull IMenuItemPage iMenuItemPage, boolean bl, boolean bl2, boolean bl3) {
        return iMenuItemPage.getDisplayText(this.getContentLocale());
    }

    @Nonnull
    public IHCNode renderMenuItemPage(@Nonnull ISimpleWebExecutionContext iSimpleWebExecutionContext, @Nonnull IMenuItemPage iMenuItemPage, boolean bl, boolean bl2, boolean bl3) {
        HCA hCA = new HCA((ISimpleURL)iSimpleWebExecutionContext.getLinkToMenuItem((String)iMenuItemPage.getID()));
        hCA.addClass(CBootstrapCSS.NAV_LINK);
        hCA.addChild(this.getMenuItemPageLabel(iMenuItemPage, bl, bl2, bl3));
        if (bl && !bl3) {
            hCA.addChild((IHCNode)new HCTextNode(" + "));
        }
        return hCA;
    }

    @Nonnull
    @OverrideOnDemand
    protected String getMenuItemExternalLabel(@Nonnull IMenuItemExternal iMenuItemExternal, boolean bl, boolean bl2, boolean bl3) {
        return iMenuItemExternal.getDisplayText(this.getContentLocale());
    }

    @Nonnull
    public IHCNode renderMenuItemExternal(@Nonnull ISimpleWebExecutionContext iSimpleWebExecutionContext, @Nonnull IMenuItemExternal iMenuItemExternal, boolean bl, boolean bl2, boolean bl3) {
        HCA hCA = new HCA(iMenuItemExternal.getURL());
        hCA.setTargetBlank();
        hCA.addClass(CBootstrapCSS.NAV_LINK);
        hCA.addChild(this.getMenuItemExternalLabel(iMenuItemExternal, bl, bl2, bl3));
        if (bl && !bl3) {
            hCA.addChild((IHCNode)new HCTextNode(" + "));
        }
        return hCA;
    }

    public void onLevelDown(@Nonnull HCUL hCUL) {
        ((HCUL)hCUL.addClass(CBootstrapCSS.NAV)).addClass(CBootstrapCSS.FLEX_COLUMN);
    }

    public void onMenuItemPageItem(@Nonnull ISimpleWebExecutionContext iSimpleWebExecutionContext, @Nonnull HCLI hCLI, boolean bl, boolean bl2, boolean bl3) {
        hCLI.addClass(CBootstrapCSS.NAV_ITEM);
        if (bl2 || bl3) {
            hCLI.addClass(CBootstrapCSS.ACTIVE);
        }
    }

    public void onMenuItemExternalItem(@Nonnull ISimpleWebExecutionContext iSimpleWebExecutionContext, @Nonnull HCLI hCLI, boolean bl, boolean bl2, boolean bl3) {
        hCLI.addClass(CBootstrapCSS.NAV_ITEM);
        if (bl2 || bl3) {
            hCLI.addClass(CBootstrapCSS.ACTIVE);
        }
    }

    @Nonnull
    public static IHCElement<?> createSideBarMenu(@Nonnull ILayoutExecutionContext iLayoutExecutionContext) {
        IMenuTree iMenuTree = iLayoutExecutionContext.getMenuTree();
        return BootstrapMenuItemRenderer.createSideBarMenu(iLayoutExecutionContext, new MenuItemDeterminatorCallback(iMenuTree, iLayoutExecutionContext.getSelectedMenuItemID()));
    }

    @Nonnull
    public static IHCElement<?> createSideBarMenu(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull MenuItemDeterminatorCallback menuItemDeterminatorCallback) {
        return BootstrapMenuItemRenderer.createSideBarMenu(iLayoutExecutionContext, iLayoutExecutionContext.getMenuTree(), menuItemDeterminatorCallback);
    }

    @Nonnull
    public static IHCElement<?> createSideBarMenu(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull IMenuTree iMenuTree, @Nonnull MenuItemDeterminatorCallback menuItemDeterminatorCallback) {
        return BootstrapMenuItemRenderer.createSideBarMenu(iLayoutExecutionContext, iMenuTree, (IMenuItemDeterminatorCallback)menuItemDeterminatorCallback, new BootstrapMenuItemRenderer(iLayoutExecutionContext.getDisplayLocale()));
    }

    @Nonnull
    public static IHCElement<?> createSideBarMenu(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull IMenuTree iMenuTree, @Nonnull IMenuItemDeterminatorCallback iMenuItemDeterminatorCallback, @Nonnull BootstrapMenuItemRenderer bootstrapMenuItemRenderer) {
        ICommonsMap iCommonsMap = MenuItemDeterminatorCallback.getAllDisplayMenuItemIDs((IMenuItemDeterminatorCallback)iMenuItemDeterminatorCallback);
        HCUL hCUL = (HCUL)((HCUL)((HCUL)MenuRendererCallback.createRenderedMenu((ILayoutExecutionContext)iLayoutExecutionContext, (Supplier)FactoryNewInstance.create(HCUL.class), (DefaultTreeItemWithID)((DefaultTreeItemWithID)iMenuTree.getRootItem()), (IMenuItemRenderer)bootstrapMenuItemRenderer, (ICommonsMap)iCommonsMap)).addClass(CBootstrapCSS.NAV)).addClass(CBootstrapCSS.FLEX_COLUMN);
        BootstrapCard bootstrapCard = new BootstrapCard();
        bootstrapCard.createAndAddBody().addChild((IHCNode)hCUL);
        return bootstrapCard;
    }
}

