/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.uictrls.ext;

import com.helger.annotation.Nonempty;
import com.helger.annotation.misc.Translatable;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringReplace;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCHasID;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.IHCElement;
import com.helger.html.hc.html.forms.HCEditFile;
import com.helger.html.hc.html.forms.HCLabel;
import com.helger.html.hc.html.grouping.AbstractHCDiv;
import com.helger.html.hc.html.metadata.HCStyle;
import com.helger.html.jquery.JQuery;
import com.helger.html.jquery.JQueryInvocation;
import com.helger.html.js.EJSEvent;
import com.helger.html.js.IHasJSCode;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSExpr;
import com.helger.photon.bootstrap4.CBootstrapCSS;
import com.helger.text.IHasText;
import com.helger.text.IMultilingualText;
import com.helger.text.display.IHasDisplayTextWithArgs;
import com.helger.text.resolve.DefaultTextResolver;
import com.helger.text.util.TextHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

public class BootstrapFileUpload
extends AbstractHCDiv<BootstrapFileUpload> {
    private final String m_sFieldName;
    private final Locale m_aDisplayLocale;
    private final HCEditFile m_aEditFile;
    private String m_sCustomPlaceholder;
    private String m_sCustomButtonText;

    public BootstrapFileUpload(@Nonnull @Nonempty String string, @Nonnull Locale locale) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        ValueEnforcer.notNull((Object)locale, (String)"DisplayLocale");
        this.m_sFieldName = string;
        this.m_aDisplayLocale = locale;
        this.m_aEditFile = new HCEditFile(this.m_sFieldName);
        this.m_aEditFile.addClass(CBootstrapCSS.CUSTOM_FILE_INPUT);
        this.m_aEditFile.ensureID();
    }

    @Nonnull
    @Nonempty
    public final String getFieldName() {
        return this.m_sFieldName;
    }

    @Nonnull
    public final HCEditFile getEditFile() {
        return this.m_aEditFile;
    }

    @Nullable
    public final String getCustomPlaceholder() {
        return this.m_sCustomPlaceholder;
    }

    @Nonnull
    public final BootstrapFileUpload setCustomPlaceholder(@Nullable String string) {
        this.m_sCustomPlaceholder = string;
        return this;
    }

    @Nullable
    public final String getCustomButtonText() {
        return this.m_sCustomButtonText;
    }

    @Nonnull
    public final BootstrapFileUpload setCustomButtonText(@Nullable String string) {
        this.m_sCustomButtonText = string;
        return this;
    }

    @Nonnull
    @OverrideOnDemand
    protected IHCElement<?> createPlaceholderNode(@Nonnull String string) {
        HCLabel hCLabel = new HCLabel();
        hCLabel.setFor((IHCHasID)this.m_aEditFile);
        hCLabel.addClass(CBootstrapCSS.CUSTOM_FILE_LABEL);
        hCLabel.addChild(string);
        return hCLabel;
    }

    protected void onFinalizeNodeState(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
        super.onFinalizeNodeState(iHCConversionSettingsToNode, iHCHasChildrenMutable);
        this.addClass(CBootstrapCSS.CUSTOM_FILE);
        this.addChild((IHCNode)this.m_aEditFile);
        String string = this.m_sCustomPlaceholder;
        if (StringHelper.isEmpty((String)string)) {
            string = EText.BROWSE_LABEL.getDisplayText(this.m_aDisplayLocale);
        }
        IHCElement<?> iHCElement = this.createPlaceholderNode(string);
        this.addChild((IHCNode)iHCElement);
        String string2 = this.m_sCustomButtonText;
        if (StringHelper.isEmpty((String)string2)) {
            string2 = EText.BUTTON_BROWSE.getDisplayText(this.m_aDisplayLocale);
        }
        this.addChild((IHCNode)new HCStyle(".custom-file-label::after { content: \"" + StringReplace.replaceAll((String)string2, (String)"\"", (CharSequence)"\\\"") + "\";  }"));
        this.m_aEditFile.addEventHandler(EJSEvent.CHANGE, (IHasJSCode)((JQueryInvocation)JQuery.idRef(iHCElement).empty()).append((IJSExpression)JSExpr.THIS.ref("files").component0().ref("name")));
    }

    @Translatable
    public static enum EText implements IHasDisplayTextWithArgs
    {
        BUTTON_BROWSE("Durchsuchen", "Browse"),
        BROWSE_LABEL("W\u00e4hlen Sie eine Datei von Ihrem Rechner aus", "Select a file from your local machine");

        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

