/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.uictrls.ext;

import com.helger.annotation.style.OverrideOnDemand;
import com.helger.html.css.DefaultCSSClassProvider;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.IHCElement;
import com.helger.html.hc.html.grouping.HCDiv;
import com.helger.html.hc.html.textlevel.HCA;
import com.helger.html.resource.css.ICSSPathProvider;
import com.helger.photon.app.html.PhotonCSS;
import com.helger.photon.bootstrap4.CBootstrapCSS;
import com.helger.photon.bootstrap4.base.AbstractBootstrapDiv;
import com.helger.photon.bootstrap4.card.BootstrapCardBody;
import com.helger.photon.bootstrap4.card.BootstrapCardHeader;
import com.helger.photon.bootstrap4.uictrls.EBootstrapUICtrlsCSSPathProvider;
import com.helger.photon.icon.fontawesome.EFontAwesome4Icon;
import com.helger.url.ISimpleURL;
import com.helger.url.SimpleURL;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class BootstrapCardCollapsible
extends AbstractBootstrapDiv<BootstrapCardCollapsible> {
    public static final ICSSClassProvider CSS_CLASS_CARD_COLLAPSIBLE = DefaultCSSClassProvider.create((String)"card-collapsible");
    public static final ICSSClassProvider CSS_CLASS_COLLAPSED = DefaultCSSClassProvider.create((String)"collapsed");
    private final IHCNode m_aHeaderText;
    private final boolean m_bIsOpen;
    private final BootstrapCardHeader m_aHeader;
    private final HCDiv m_aCollapseDiv;
    private final BootstrapCardBody m_aBody;

    public BootstrapCardCollapsible(@Nullable IHCNode iHCNode) {
        this(iHCNode, true);
    }

    public BootstrapCardCollapsible(@Nullable IHCNode iHCNode, boolean bl) {
        this.m_aHeaderText = iHCNode;
        this.m_bIsOpen = bl;
        this.m_aHeader = (BootstrapCardHeader)this.addAndReturnChild((IHCNode)new BootstrapCardHeader());
        this.m_aCollapseDiv = (HCDiv)this.addAndReturnChild((IHCNode)((HCDiv)((HCDiv)new HCDiv().ensureID()).addClass(CBootstrapCSS.COLLAPSE)));
        if (bl) {
            this.m_aCollapseDiv.addClass(CBootstrapCSS.SHOW);
        }
        this.m_aCollapseDiv.customAttrs().setAriaLabeledBy((IHCElement)this.m_aHeader);
        this.m_aBody = (BootstrapCardBody)this.m_aCollapseDiv.addAndReturnChild((IHCNode)new BootstrapCardBody());
    }

    @Nonnull
    public final IHCNode getHeaderText() {
        return this.m_aHeaderText;
    }

    public final boolean isOpen() {
        return this.m_bIsOpen;
    }

    @Nonnull
    public final BootstrapCardHeader getHeader() {
        return this.m_aHeader;
    }

    @Nonnull
    public final HCDiv getCollapseDiv() {
        return this.m_aCollapseDiv;
    }

    @Nonnull
    public final BootstrapCardBody getBody() {
        return this.m_aBody;
    }

    @Nonnull
    @OverrideOnDemand
    protected IHCNode createCloseIcon() {
        return EFontAwesome4Icon.CHEVRON_DOWN.getAsNode();
    }

    @Nonnull
    @OverrideOnDemand
    protected HCA createToggle() {
        HCA hCA = (HCA)((HCA)((HCA)new HCA().setHref((ISimpleURL)new SimpleURL("#" + this.m_aCollapseDiv.getID()))).addClass(CBootstrapCSS.D_FLEX)).addClass(CBootstrapCSS.JUSTIFY_CONTENT_BETWEEN);
        hCA.customAttrs().setDataAttr("toggle", "collapse");
        hCA.customAttrs().setAriaExpanded(this.m_bIsOpen);
        hCA.customAttrs().setAriaControls(this.m_aCollapseDiv.getID());
        hCA.addChild(this.m_aHeaderText);
        hCA.addChild(this.createCloseIcon());
        if (!this.m_bIsOpen) {
            hCA.addClass(CSS_CLASS_COLLAPSED);
        }
        return hCA;
    }

    protected void onFinalizeNodeState(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
        super.onFinalizeNodeState(iHCConversionSettingsToNode, iHCHasChildrenMutable);
        this.addClass(CBootstrapCSS.CARD);
        this.addClass(CSS_CLASS_CARD_COLLAPSIBLE);
        HCA hCA = this.createToggle();
        this.m_aHeader.addChild((IHCNode)hCA);
    }

    protected void onRegisterExternalResources(IHCConversionSettingsToNode iHCConversionSettingsToNode, boolean bl) {
        super.onRegisterExternalResources(iHCConversionSettingsToNode, bl);
        EFontAwesome4Icon.registerResourcesForThisRequest();
        PhotonCSS.registerCSSIncludeForThisRequest((ICSSPathProvider)EBootstrapUICtrlsCSSPathProvider.BOOTSTRAP_EXT);
    }
}

