/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.uictrls.datetimepicker;

import com.helger.annotation.Nonnegative;
import jakarta.annotation.Nullable;
import java.time.DayOfWeek;

public enum EDateTimePickerDayOfWeek {
    MONDAY(1),
    TUESDAY(2),
    WEDNESDAY(3),
    THURSDAY(4),
    FRIDAY(5),
    SATURDAY(6),
    SUNDAY(7);

    private final int m_nJSValue;

    private EDateTimePickerDayOfWeek(int n2) {
        this.m_nJSValue = n2;
    }

    @Nonnegative
    public int getJSValue() {
        return this.m_nJSValue;
    }

    @Nullable
    public static EDateTimePickerDayOfWeek getFromJavaTimeValueOrNull(int n) {
        if (n == DayOfWeek.MONDAY.getValue()) {
            return MONDAY;
        }
        if (n == DayOfWeek.TUESDAY.getValue()) {
            return TUESDAY;
        }
        if (n == DayOfWeek.WEDNESDAY.getValue()) {
            return WEDNESDAY;
        }
        if (n == DayOfWeek.THURSDAY.getValue()) {
            return THURSDAY;
        }
        if (n == DayOfWeek.FRIDAY.getValue()) {
            return FRIDAY;
        }
        if (n == DayOfWeek.SATURDAY.getValue()) {
            return SATURDAY;
        }
        if (n == DayOfWeek.SUNDAY.getValue()) {
            return SUNDAY;
        }
        return null;
    }

    @Nullable
    public static EDateTimePickerDayOfWeek getFromJavaCalendarValueOrNull(int n) {
        switch (n) {
            case 2: {
                return MONDAY;
            }
            case 3: {
                return TUESDAY;
            }
            case 4: {
                return WEDNESDAY;
            }
            case 5: {
                return THURSDAY;
            }
            case 6: {
                return FRIDAY;
            }
            case 7: {
                return SATURDAY;
            }
            case 1: {
                return SUNDAY;
            }
        }
        return null;
    }
}

