/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.uictrls.datetimepicker;

import com.helger.datetime.format.PDTFormatPatterns;
import com.helger.photon.bootstrap4.uictrls.datetimepicker.Bootstrap4DateTimePickerFormatBuilder;
import jakarta.annotation.Nonnull;
import java.util.Locale;
import java.util.function.Function;

public enum EBootstrap4DateTimePickerMode {
    TIME(PDTFormatPatterns::getDefaultPatternTime),
    DATE(PDTFormatPatterns::getDefaultPatternDate),
    DATE_TIME(PDTFormatPatterns::getDefaultPatternDateTime);

    public static final EBootstrap4DateTimePickerMode DEFAULT;
    private final Function<Locale, String> m_aJavaFormatSupplier;

    private EBootstrap4DateTimePickerMode(Function<Locale, String> function) {
        this.m_aJavaFormatSupplier = function;
    }

    public boolean isTimeContained() {
        return this == TIME || this == DATE_TIME;
    }

    public boolean isDateContained() {
        return this == DATE || this == DATE_TIME;
    }

    @Nonnull
    public String getJSFormat(@Nonnull Locale locale) {
        String string = this.m_aJavaFormatSupplier.apply(locale);
        return Bootstrap4DateTimePickerFormatBuilder.fromJavaPattern(string).getJSCalendarFormatString();
    }

    static {
        DEFAULT = DATE;
    }
}

