/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.uictrls.datetimepicker;

import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ETriState;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.datetime.format.PDTToString;
import com.helger.datetime.helper.PDTFactory;
import com.helger.html.css.DefaultCSSClassProvider;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCHasID;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.forms.HCEdit;
import com.helger.html.hc.html.grouping.HCDiv;
import com.helger.html.jquery.JQuery;
import com.helger.html.jquery.JQueryInvocation;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSAssocArray;
import com.helger.html.jscode.JSInvocation;
import com.helger.html.request.IHCRequestField;
import com.helger.html.resource.css.ICSSPathProvider;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.json.IJson;
import com.helger.json.JsonObject;
import com.helger.photon.app.html.PhotonCSS;
import com.helger.photon.app.html.PhotonJS;
import com.helger.photon.bootstrap4.form.BootstrapFormHelper;
import com.helger.photon.bootstrap4.inputgroup.BootstrapInputGroup;
import com.helger.photon.bootstrap4.uictrls.EBootstrapUICtrlsCSSPathProvider;
import com.helger.photon.bootstrap4.uictrls.EBootstrapUICtrlsJSPathProvider;
import com.helger.photon.bootstrap4.uictrls.datetimepicker.Bootstrap4DateTimePickerJS;
import com.helger.photon.bootstrap4.uictrls.datetimepicker.EBootstrap4DateTimePickerMode;
import com.helger.photon.bootstrap4.uictrls.datetimepicker.EBootstrap4DateTimePickerTexts;
import com.helger.photon.bootstrap4.uictrls.datetimepicker.EBootstrap4DateTimePickerViewModeType;
import com.helger.photon.core.form.RequestField;
import com.helger.photon.icon.fontawesome.EFontAwesome4Icon;
import com.helger.photon.uicore.EUICoreJSPathProvider;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public class BootstrapDateTimePicker
extends BootstrapInputGroup {
    public static final ICSSClassProvider CSS_CLASS_DATE = DefaultCSSClassProvider.create((String)"date");
    public static final ICSSClassProvider CSS_CLASS_DATETIMEPICKER_INPUT = DefaultCSSClassProvider.create((String)"datetimepicker-input");
    public static final String EVENT_SUFFIX = ".datetimepicker";
    public static final String EVENT_NAME_CHANGE = "change.datetimepicker";
    public static final EBootstrap4DateTimePickerViewModeType DEFAULT_VIEW_MODE = EBootstrap4DateTimePickerViewModeType.DAYS;
    public static final IHCNode DEFAULT_PREPEND_ICON = EFontAwesome4Icon.CALENDAR.getAsNode();
    private static final LocalDate DUMMY_DATE = PDTFactory.createLocalDate((int)2018, (Month)Month.OCTOBER, (int)24);
    private static final LocalTime DUMMY_TIME = PDTFactory.createLocalTime((int)12, (int)10, (int)34);
    private final HCEdit m_aEdit;
    private final Locale m_aDisplayLocale;
    private LocalDateTime m_aInitialDate;
    private ETriState m_eShowCalendarWeeks = ETriState.FALSE;
    private ETriState m_eShowToday = ETriState.TRUE;
    private ETriState m_eShowClear = ETriState.TRUE;
    private ETriState m_eShowClose = ETriState.TRUE;
    private EBootstrap4DateTimePickerMode m_eMode = EBootstrap4DateTimePickerMode.DEFAULT;
    private String m_sFormat;
    private EBootstrap4DateTimePickerViewModeType m_eViewMode;
    private ETriState m_eSideBySide = ETriState.UNDEFINED;
    private LocalDateTime m_aMinDate;
    private LocalDateTime m_aMaxDate;
    private ETriState m_eUseCurrent = ETriState.FALSE;
    private IHCNode m_aPrependIcon = DEFAULT_PREPEND_ICON;
    private final ICommonsOrderedMap<String, String> m_aIcons = new CommonsLinkedHashMap();

    @Nonnull
    public static String getAsModeSpecificISOString(@Nonnull EBootstrap4DateTimePickerMode eBootstrap4DateTimePickerMode, @Nonnull LocalDateTime localDateTime) {
        switch (eBootstrap4DateTimePickerMode) {
            case TIME: {
                return DateTimeFormatter.ISO_TIME.format(localDateTime.toLocalTime());
            }
            case DATE: {
                return DateTimeFormatter.ISO_DATE.format(localDateTime.toLocalDate());
            }
            case DATE_TIME: {
                return DateTimeFormatter.ISO_DATE_TIME.format(localDateTime);
            }
        }
        throw new IllegalStateException("Unsupported mode " + String.valueOf((Object)eBootstrap4DateTimePickerMode));
    }

    @Nullable
    public static String getAsModeSpecificUIString(@Nonnull EBootstrap4DateTimePickerMode eBootstrap4DateTimePickerMode, @Nullable LocalDateTime localDateTime, @Nonnull Locale locale) {
        if (localDateTime == null) {
            return null;
        }
        switch (eBootstrap4DateTimePickerMode) {
            case TIME: {
                return PDTToString.getAsString((LocalTime)localDateTime.toLocalTime(), (Locale)locale);
            }
            case DATE: {
                return PDTToString.getAsString((LocalDate)localDateTime.toLocalDate(), (Locale)locale);
            }
            case DATE_TIME: {
                return PDTToString.getAsString((LocalDateTime)localDateTime, (Locale)locale);
            }
        }
        throw new IllegalStateException("Unsupported mode " + String.valueOf((Object)eBootstrap4DateTimePickerMode));
    }

    protected BootstrapDateTimePicker(@Nonnull String string, @Nullable LocalDateTime localDateTime, @Nonnull Locale locale, @Nonnull EBootstrap4DateTimePickerMode eBootstrap4DateTimePickerMode) {
        ValueEnforcer.notNull((Object)locale, (String)"DisplayLocale");
        ValueEnforcer.notNull((Object)((Object)eBootstrap4DateTimePickerMode), (String)"Mode");
        this.m_aDisplayLocale = locale;
        this.m_aInitialDate = localDateTime;
        this.ensureID();
        this.customAttrs().setDataAttr("target-input", "nearest");
        this.m_aEdit = new HCEdit((IHCRequestField)new RequestField(string, BootstrapDateTimePicker.getAsModeSpecificUIString(eBootstrap4DateTimePickerMode, localDateTime, locale)));
        this.m_aEdit.setPlaceholder("");
        this.m_aEdit.addClass(CSS_CLASS_DATETIMEPICKER_INPUT);
        this.m_aEdit.customAttrs().setDataAttr("toggle", "datetimepicker");
        this.m_aEdit.customAttrs().setDataAttr("target", "#" + this.getID());
        BootstrapFormHelper.markAsFormControl((IHCNode)this.m_aEdit);
        this.addChild((IHCNode)this.m_aEdit);
        this.setMode(eBootstrap4DateTimePickerMode);
        this.m_aIcons.put((Object)"clear", (Object)"fa fa-eraser");
        this.m_aIcons.put((Object)"close", (Object)"fa fa-close");
    }

    @Nonnull
    public final HCEdit getEdit() {
        return this.m_aEdit;
    }

    @Nonnull
    public final BootstrapDateTimePicker setReadOnly(boolean bl) {
        this.m_aEdit.setReadOnly(bl);
        return this;
    }

    @Nonnull
    public final EBootstrap4DateTimePickerMode getMode() {
        return this.m_eMode;
    }

    @Nonnull
    public final BootstrapDateTimePicker setMode(@Nonnull EBootstrap4DateTimePickerMode eBootstrap4DateTimePickerMode) {
        ValueEnforcer.notNull((Object)((Object)eBootstrap4DateTimePickerMode), (String)"Mode");
        this.m_eMode = eBootstrap4DateTimePickerMode;
        return this;
    }

    @Nullable
    public final String getFormat() {
        return this.m_sFormat;
    }

    @Nonnull
    public final BootstrapDateTimePicker setFormat(@Nullable String string) {
        this.m_sFormat = string;
        return this;
    }

    @Nonnull
    public final ETriState getShowCalendarWeeks() {
        return this.m_eShowCalendarWeeks;
    }

    @Nonnull
    public final BootstrapDateTimePicker setShowCalendarWeeks(boolean bl) {
        return this.setShowCalendarWeeks(ETriState.valueOf((boolean)bl));
    }

    @Nonnull
    public final BootstrapDateTimePicker setShowCalendarWeeks(@Nonnull ETriState eTriState) {
        ValueEnforcer.notNull((Object)eTriState, (String)"ShowCalendarWeeks");
        this.m_eShowCalendarWeeks = eTriState;
        return this;
    }

    @Nonnull
    public final ETriState getShowToday() {
        return this.m_eShowToday;
    }

    @Nonnull
    public final BootstrapDateTimePicker setShowToday(boolean bl) {
        return this.setShowToday(ETriState.valueOf((boolean)bl));
    }

    @Nonnull
    public final BootstrapDateTimePicker setShowToday(@Nonnull ETriState eTriState) {
        ValueEnforcer.notNull((Object)eTriState, (String)"ShowToday");
        this.m_eShowToday = eTriState;
        return this;
    }

    @Nonnull
    public final ETriState getShowClear() {
        return this.m_eShowClear;
    }

    @Nonnull
    public final BootstrapDateTimePicker setShowClear(boolean bl) {
        return this.setShowClear(ETriState.valueOf((boolean)bl));
    }

    @Nonnull
    public final BootstrapDateTimePicker setShowClear(@Nonnull ETriState eTriState) {
        ValueEnforcer.notNull((Object)eTriState, (String)"ShowClear");
        this.m_eShowClear = eTriState;
        return this;
    }

    @Nonnull
    public final ETriState getShowClose() {
        return this.m_eShowClose;
    }

    @Nonnull
    public final BootstrapDateTimePicker setShowClose(boolean bl) {
        return this.setShowClose(ETriState.valueOf((boolean)bl));
    }

    @Nonnull
    public final BootstrapDateTimePicker setShowClose(@Nonnull ETriState eTriState) {
        ValueEnforcer.notNull((Object)eTriState, (String)"ShowClose");
        this.m_eShowClose = eTriState;
        return this;
    }

    @Nullable
    public final EBootstrap4DateTimePickerViewModeType getViewMode() {
        return this.m_eViewMode;
    }

    @Nonnull
    public final BootstrapDateTimePicker setViewMode(@Nullable EBootstrap4DateTimePickerViewModeType eBootstrap4DateTimePickerViewModeType) {
        this.m_eViewMode = eBootstrap4DateTimePickerViewModeType;
        return this;
    }

    @Nonnull
    public final ETriState getSideBySide() {
        return this.m_eSideBySide;
    }

    @Nonnull
    public final BootstrapDateTimePicker setSideBySide(boolean bl) {
        this.m_eSideBySide = ETriState.valueOf((boolean)bl);
        return this;
    }

    @Nullable
    public final LocalDateTime getInitialDate() {
        return this.m_aInitialDate;
    }

    @Nonnull
    public final BootstrapDateTimePicker setInitialDate(@Nullable LocalTime localTime) {
        ValueEnforcer.isTrue((this.m_eMode == EBootstrap4DateTimePickerMode.TIME ? 1 : 0) != 0, (String)"Current action mode is not TIME");
        this.m_aInitialDate = localTime == null ? null : DUMMY_DATE.atTime(localTime);
        return this;
    }

    @Nonnull
    public final BootstrapDateTimePicker setInitialDate(@Nullable LocalDate localDate) {
        ValueEnforcer.isTrue((this.m_eMode == EBootstrap4DateTimePickerMode.DATE ? 1 : 0) != 0, (String)"Current action mode is not DATE");
        this.m_aInitialDate = localDate == null ? null : localDate.atTime(DUMMY_TIME);
        return this;
    }

    @Nonnull
    public final BootstrapDateTimePicker setInitialDate(@Nullable LocalDateTime localDateTime) {
        ValueEnforcer.isTrue((this.m_eMode == EBootstrap4DateTimePickerMode.DATE_TIME ? 1 : 0) != 0, (String)"Current action mode is not DATE_TIME");
        this.m_aInitialDate = localDateTime;
        return this;
    }

    @Nullable
    public final LocalDateTime getMinDate() {
        return this.m_aMinDate;
    }

    @Nonnull
    public final BootstrapDateTimePicker setMinDate(@Nullable LocalTime localTime) {
        ValueEnforcer.isTrue((this.m_eMode == EBootstrap4DateTimePickerMode.TIME ? 1 : 0) != 0, (String)"Current action mode is not TIME");
        this.m_aMinDate = localTime == null ? null : DUMMY_DATE.atTime(localTime);
        return this;
    }

    @Nonnull
    public final BootstrapDateTimePicker setMinDate(@Nullable LocalDate localDate) {
        ValueEnforcer.isTrue((this.m_eMode == EBootstrap4DateTimePickerMode.DATE ? 1 : 0) != 0, (String)"Current action mode is not DATE");
        this.m_aMinDate = localDate == null ? null : localDate.atTime(DUMMY_TIME);
        return this;
    }

    @Nonnull
    public final BootstrapDateTimePicker setMinDate(@Nullable LocalDateTime localDateTime) {
        ValueEnforcer.isTrue((this.m_eMode == EBootstrap4DateTimePickerMode.DATE_TIME ? 1 : 0) != 0, (String)"Current action mode is not DATE_TIME");
        this.m_aMinDate = localDateTime;
        return this;
    }

    @Nullable
    public final LocalDateTime getMaxDate() {
        return this.m_aMaxDate;
    }

    @Nonnull
    public final BootstrapDateTimePicker setMaxDate(@Nullable LocalTime localTime) {
        ValueEnforcer.isTrue((this.m_eMode == EBootstrap4DateTimePickerMode.TIME ? 1 : 0) != 0, (String)"Current action mode is not TIME");
        this.m_aMaxDate = localTime == null ? null : DUMMY_DATE.atTime(localTime);
        return this;
    }

    @Nonnull
    public final BootstrapDateTimePicker setMaxDate(@Nullable LocalDate localDate) {
        ValueEnforcer.isTrue((this.m_eMode == EBootstrap4DateTimePickerMode.DATE ? 1 : 0) != 0, (String)"Current action mode is not DATE");
        this.m_aMaxDate = localDate == null ? null : localDate.atTime(DUMMY_TIME);
        return this;
    }

    @Nonnull
    public final BootstrapDateTimePicker setMaxDate(@Nullable LocalDateTime localDateTime) {
        ValueEnforcer.isTrue((this.m_eMode == EBootstrap4DateTimePickerMode.DATE_TIME ? 1 : 0) != 0, (String)"Current action mode is not DATE_TIME");
        this.m_aMaxDate = localDateTime;
        return this;
    }

    @Nonnull
    public final ETriState getUseCurrent() {
        return this.m_eUseCurrent;
    }

    @Nonnull
    public final BootstrapDateTimePicker setUseCurrent(boolean bl) {
        return this.setUseCurrent(ETriState.valueOf((boolean)bl));
    }

    @Nonnull
    public final BootstrapDateTimePicker setUseCurrent(@Nonnull ETriState eTriState) {
        ValueEnforcer.notNull((Object)eTriState, (String)"UseCurrent");
        this.m_eUseCurrent = eTriState;
        return this;
    }

    @Nullable
    public final IHCNode getPrependIcon() {
        return this.m_aPrependIcon;
    }

    @Nonnull
    public final BootstrapDateTimePicker setPrependIcon(@Nullable IHCNode iHCNode) {
        this.m_aPrependIcon = iHCNode;
        return this;
    }

    @Nonnull
    @ReturnsMutableObject
    public final ICommonsOrderedMap<String, String> icons() {
        return this.m_aIcons;
    }

    @Nonnull
    public static JSInvocation invoke(@Nonnull JQueryInvocation jQueryInvocation) {
        return jQueryInvocation.invoke("datetimepicker");
    }

    @Nonnull
    public final JSInvocation invoke() {
        return BootstrapDateTimePicker.invoke(JQuery.idRef((IHCHasID)this));
    }

    @Nonnull
    public static JSInvocation invoke(@Nonnull JQueryInvocation jQueryInvocation, @Nonnull JSAssocArray jSAssocArray) {
        return (JSInvocation)BootstrapDateTimePicker.invoke(jQueryInvocation).arg((IJSExpression)jSAssocArray);
    }

    @Nonnull
    public final JSInvocation invoke(@Nonnull JSAssocArray jSAssocArray) {
        return (JSInvocation)this.invoke().arg((IJSExpression)jSAssocArray);
    }

    private void _add(@Nonnull JSAssocArray jSAssocArray, @Nonnull String string, @Nonnull EBootstrap4DateTimePickerTexts eBootstrap4DateTimePickerTexts) {
        String string2 = eBootstrap4DateTimePickerTexts.getDisplayText(this.m_aDisplayLocale);
        if (StringHelper.isNotEmpty((String)string2)) {
            jSAssocArray.add(string, string2);
        }
    }

    @Nonnull
    public JSAssocArray getJSTooltipTexts() {
        JSAssocArray jSAssocArray = new JSAssocArray();
        this._add(jSAssocArray, "today", EBootstrap4DateTimePickerTexts.TODAY);
        this._add(jSAssocArray, "clear", EBootstrap4DateTimePickerTexts.CLEAR);
        this._add(jSAssocArray, "close", EBootstrap4DateTimePickerTexts.CLOSE);
        this._add(jSAssocArray, "selectMonth", EBootstrap4DateTimePickerTexts.SELECTMONTH);
        this._add(jSAssocArray, "prevMonth", EBootstrap4DateTimePickerTexts.PREVMONTH);
        this._add(jSAssocArray, "nextMonth", EBootstrap4DateTimePickerTexts.NEXTMONTH);
        this._add(jSAssocArray, "selectYear", EBootstrap4DateTimePickerTexts.SELECTYEAR);
        this._add(jSAssocArray, "prevYear", EBootstrap4DateTimePickerTexts.PREVYEAR);
        this._add(jSAssocArray, "nextYear", EBootstrap4DateTimePickerTexts.NEXTYEAR);
        this._add(jSAssocArray, "selectDecade", EBootstrap4DateTimePickerTexts.SELECTDECADE);
        this._add(jSAssocArray, "prevDecade", EBootstrap4DateTimePickerTexts.PREVDECADE);
        this._add(jSAssocArray, "nextDecade", EBootstrap4DateTimePickerTexts.NEXTDECADE);
        this._add(jSAssocArray, "prevCentury", EBootstrap4DateTimePickerTexts.PREVCENTURY);
        this._add(jSAssocArray, "nextCentury", EBootstrap4DateTimePickerTexts.NEXTCENTURY);
        this._add(jSAssocArray, "incrementHour", EBootstrap4DateTimePickerTexts.INCREMENTHOUR);
        this._add(jSAssocArray, "pickHour", EBootstrap4DateTimePickerTexts.PICKHOUR);
        this._add(jSAssocArray, "decrementHour", EBootstrap4DateTimePickerTexts.DECREMENTHOUR);
        this._add(jSAssocArray, "incrementMinute", EBootstrap4DateTimePickerTexts.INCREMENTMINUTE);
        this._add(jSAssocArray, "pickMinute", EBootstrap4DateTimePickerTexts.PICKMINUTE);
        this._add(jSAssocArray, "decrementMinute", EBootstrap4DateTimePickerTexts.DECREMENTMINUTE);
        this._add(jSAssocArray, "incrementSecond", EBootstrap4DateTimePickerTexts.INCREMENTSECOND);
        this._add(jSAssocArray, "pickSecond", EBootstrap4DateTimePickerTexts.PICKSECOND);
        this._add(jSAssocArray, "decrementSecond", EBootstrap4DateTimePickerTexts.DECREMENTSECOND);
        return jSAssocArray;
    }

    @Nonnull
    public JSAssocArray getJSOptions() {
        JsonObject jsonObject;
        JSAssocArray jSAssocArray = new JSAssocArray();
        jSAssocArray.add("locale", this.m_aDisplayLocale.toString());
        if (this.m_eViewMode != null) {
            jSAssocArray.add("viewMode", this.m_eViewMode.getJSValueString());
        }
        if (this.m_eShowCalendarWeeks.isDefined()) {
            jSAssocArray.add("calendarWeeks", this.m_eShowCalendarWeeks.getAsBooleanValue());
        }
        if (this.m_eShowToday.isDefined() || this.m_eShowClose.isDefined() || this.m_eShowClear.isDefined()) {
            jsonObject = new JsonObject();
            if (this.m_eShowToday.isDefined()) {
                jsonObject.add((Object)"showToday", this.m_eShowToday.getAsBooleanValue());
            }
            if (this.m_eShowClear.isDefined()) {
                jsonObject.add((Object)"showClear", this.m_eShowClear.getAsBooleanValue());
            }
            if (this.m_eShowClose.isDefined()) {
                jsonObject.add((Object)"showClose", this.m_eShowClose.getAsBooleanValue());
            }
            jSAssocArray.add("buttons", (IJson)jsonObject);
        }
        if ((jsonObject = this.getJSTooltipTexts()).isNotEmpty()) {
            jSAssocArray.add("tooltips", (IJSExpression)jsonObject);
        }
        if (this.m_eSideBySide.isDefined()) {
            jSAssocArray.add("sideBySide", this.m_eSideBySide.getAsBooleanValue());
        }
        jSAssocArray.add("format", StringHelper.isNotEmpty((String)this.m_sFormat) ? this.m_sFormat : this.m_eMode.getJSFormat(this.m_aDisplayLocale));
        if (this.m_eUseCurrent.isDefined()) {
            jSAssocArray.add("useCurrent", this.m_eUseCurrent.getAsBooleanValue());
        }
        if (this.m_aMinDate != null) {
            jSAssocArray.add("minDate", BootstrapDateTimePicker.getAsModeSpecificISOString(this.m_eMode, this.m_aMinDate));
        }
        if (this.m_aMaxDate != null) {
            jSAssocArray.add("maxDate", BootstrapDateTimePicker.getAsModeSpecificISOString(this.m_eMode, this.m_aMaxDate));
        }
        if (this.m_aInitialDate != null) {
            jSAssocArray.add("date", BootstrapDateTimePicker.getAsModeSpecificISOString(this.m_eMode, this.m_aInitialDate));
        }
        if (this.m_aIcons.isNotEmpty()) {
            jSAssocArray.add("icons", (IJson)new JsonObject().addAllAny(this.m_aIcons));
        }
        return jSAssocArray;
    }

    @Nonnull
    @OverrideOnDemand
    public HCDiv createGroupPrepend() {
        HCDiv hCDiv = super.createGroupPrepend();
        hCDiv.customAttrs().setDataAttr("toggle", "datetimepicker");
        hCDiv.customAttrs().setDataAttr("target", "#" + this.getID());
        return hCDiv;
    }

    protected void onFinalizeNodeState(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
        if (this.m_aPrependIcon != null) {
            this.getOrCreateGroupPrepend().addChildAt(0, BootstrapDateTimePicker.getWrapped((IHCNode)this.m_aPrependIcon));
        }
        super.onFinalizeNodeState(iHCConversionSettingsToNode, iHCHasChildrenMutable);
        this.addClass(CSS_CLASS_DATE);
        if (!this.m_aEdit.isReadOnly()) {
            this.addChild((IHCNode)new Bootstrap4DateTimePickerJS(this));
        }
    }

    protected void onRegisterExternalResources(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, boolean bl) {
        super.onRegisterExternalResources(iHCConversionSettingsToNode, bl);
        BootstrapDateTimePicker.registerResourcesForThisRequest();
    }

    public static void registerResourcesForThisRequest() {
        PhotonJS.registerJSIncludeForThisRequest((IJSPathProvider)EUICoreJSPathProvider.JQUERY_3);
        PhotonJS.registerJSIncludeForThisRequest((IJSPathProvider)EUICoreJSPathProvider.MOMENT_WITH_LOCALES);
        PhotonJS.registerJSIncludeForThisRequest((IJSPathProvider)EBootstrapUICtrlsJSPathProvider.DATETIMEPICKER);
        EFontAwesome4Icon.registerResourcesForThisRequest();
        PhotonCSS.registerCSSIncludeForThisRequest((ICSSPathProvider)EBootstrapUICtrlsCSSPathProvider.DATETIMEPICKER);
    }

    @Nonnull
    public static BootstrapDateTimePicker create(@Nonnull String string, @Nullable LocalDate localDate, @Nonnull Locale locale) {
        return new BootstrapDateTimePicker(string, localDate == null ? null : localDate.atTime(DUMMY_TIME), locale, EBootstrap4DateTimePickerMode.DATE);
    }

    @Nonnull
    public static BootstrapDateTimePicker create(@Nonnull String string, @Nullable LocalTime localTime, @Nonnull Locale locale) {
        return new BootstrapDateTimePicker(string, localTime == null ? null : DUMMY_DATE.atTime(localTime), locale, EBootstrap4DateTimePickerMode.TIME);
    }

    @Nonnull
    public static BootstrapDateTimePicker create(@Nonnull String string, @Nullable LocalDateTime localDateTime, @Nonnull Locale locale) {
        return new BootstrapDateTimePicker(string, localDateTime, locale, EBootstrap4DateTimePickerMode.DATE_TIME);
    }

    @Nonnull
    public static BootstrapDateTimePicker create(@Nonnull String string, @Nonnull Locale locale, @Nonnull EBootstrap4DateTimePickerMode eBootstrap4DateTimePickerMode) {
        return new BootstrapDateTimePicker(string, null, locale, eBootstrap4DateTimePickerMode);
    }
}

