/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.uictrls.datetimepicker;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.cache.impl.Cache;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsMap;
import com.helger.datetime.format.PDTFromString;
import com.helger.photon.bootstrap4.uictrls.datetimepicker.EMomentsDateTimePickerFormatToken;
import com.helger.photon.uicore.datetime.IDateFormatBuilder;
import com.helger.text.compare.ComparatorHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Comparator;
import java.util.Map;

public class Bootstrap4DateTimePickerFormatBuilder
implements IDateFormatBuilder {
    private final ICommonsList<Object> m_aList = new CommonsArrayList();
    private static final PatternCache CACHE = new PatternCache();

    @Nonnull
    public Bootstrap4DateTimePickerFormatBuilder append(@Nonnull EMomentsDateTimePickerFormatToken eMomentsDateTimePickerFormatToken) {
        ValueEnforcer.notNull((Object)((Object)eMomentsDateTimePickerFormatToken), (String)"Token");
        this.m_aList.add((Object)eMomentsDateTimePickerFormatToken);
        return this;
    }

    @Nonnull
    public Bootstrap4DateTimePickerFormatBuilder append(char c) {
        this.m_aList.add((Object)Character.valueOf(c));
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Object> getAllInternalObjects() {
        return (ICommonsList)this.m_aList.getClone();
    }

    @Nonnull
    public String getJSCalendarFormatString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object e : this.m_aList) {
            if (e instanceof EMomentsDateTimePickerFormatToken) {
                stringBuilder.append(((EMomentsDateTimePickerFormatToken)((Object)e)).getJSToken());
                continue;
            }
            stringBuilder.append(((Character)e).charValue());
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public String getJavaFormatString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object e : this.m_aList) {
            if (e instanceof EMomentsDateTimePickerFormatToken) {
                stringBuilder.append(((EMomentsDateTimePickerFormatToken)((Object)e)).getJavaToken());
                continue;
            }
            stringBuilder.append(((Character)e).charValue());
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public LocalDate getDateFormatted(@Nullable String string) {
        return PDTFromString.getLocalDateFromString((String)string, (String)this.getJavaFormatString());
    }

    @Nonnull
    public LocalTime getTimeFormatted(@Nullable String string) {
        return PDTFromString.getLocalTimeFromString((String)string, (String)this.getJavaFormatString());
    }

    @Nonnull
    public LocalDateTime getLocalDateTimeFormatted(@Nullable String string) {
        return PDTFromString.getLocalDateTimeFromString((String)string, (String)this.getJavaFormatString());
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("list", this.m_aList).getToString();
    }

    @Nonnull
    public static IDateFormatBuilder fromJavaPattern(@Nonnull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"JavaPattern");
        return (IDateFormatBuilder)CACHE.getFromCache(string);
    }

    private static final class PatternCache
    extends Cache<String, Bootstrap4DateTimePickerFormatBuilder> {
        public PatternCache() {
            super(string -> {
                ValueEnforcer.notNull((Object)string, (String)"JavaPattern");
                Bootstrap4DateTimePickerFormatBuilder bootstrap4DateTimePickerFormatBuilder = new Bootstrap4DateTimePickerFormatBuilder();
                Searcher searcher = new Searcher((String)string);
                while (searcher.hasMore()) {
                    EMomentsDateTimePickerFormatToken eMomentsDateTimePickerFormatToken = searcher.getNextToken();
                    if (eMomentsDateTimePickerFormatToken != null) {
                        bootstrap4DateTimePickerFormatBuilder.append(eMomentsDateTimePickerFormatToken);
                        continue;
                    }
                    bootstrap4DateTimePickerFormatBuilder.append(searcher.getNextChar());
                }
                return bootstrap4DateTimePickerFormatBuilder;
            }, -1, "BootstrapDateTimePickerFormatBuilder.PatternCache");
        }
    }

    private static final class Searcher {
        private String m_sRest;
        private final ICommonsMap<String, EMomentsDateTimePickerFormatToken> m_aAllMatching = new CommonsHashMap();
        private final Comparator<String> m_aComp = ComparatorHelper.getComparatorStringLongestFirst();

        public Searcher(@Nonnull String string) {
            ValueEnforcer.notNull((Object)string, (String)"Rest");
            this.m_sRest = string;
        }

        public boolean hasMore() {
            return this.m_sRest.length() > 0;
        }

        @Nullable
        public EMomentsDateTimePickerFormatToken getNextToken() {
            this.m_aAllMatching.clear();
            for (EMomentsDateTimePickerFormatToken eMomentsDateTimePickerFormatToken : EMomentsDateTimePickerFormatToken.values()) {
                String string = eMomentsDateTimePickerFormatToken.getJavaToken();
                if (!this.m_sRest.startsWith(string)) continue;
                this.m_aAllMatching.put((Object)string, (Object)eMomentsDateTimePickerFormatToken);
            }
            if (this.m_aAllMatching.isEmpty()) {
                return null;
            }
            Map.Entry entry = this.m_aAllMatching.size() == 1 ? this.m_aAllMatching.getFirstEntry() : this.m_aAllMatching.getSortedByKey(this.m_aComp).getFirstEntry();
            this.m_sRest = this.m_sRest.substring(((String)entry.getKey()).length());
            return (EMomentsDateTimePickerFormatToken)((Object)entry.getValue());
        }

        public char getNextChar() {
            char c = this.m_sRest.charAt(0);
            this.m_sRest = this.m_sRest.substring(1);
            return c;
        }
    }
}

