/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.uictrls.datatables;

import com.helger.html.annotation.OutOfBandNode;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.html.tabular.AbstractHCTable;
import com.helger.html.hc.html.tabular.IHCTable;
import com.helger.html.resource.css.ICSSPathProvider;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.photon.app.html.PhotonCSS;
import com.helger.photon.app.html.PhotonJS;
import com.helger.photon.bootstrap4.CBootstrapCSS;
import com.helger.photon.bootstrap4.uictrls.datatables.BootstrapDataTablesDom;
import com.helger.photon.bootstrap4.uictrls.datatables.IBootstrapDataTablesConfigurator;
import com.helger.photon.core.execcontext.ILayoutExecutionContext;
import com.helger.photon.uictrls.datatables.DataTables;
import com.helger.photon.uictrls.datatables.EDataTablesB4CSSPathProvider;
import com.helger.photon.uictrls.datatables.EDataTablesB4JSPathProvider;
import com.helger.photon.uictrls.datatables.EDataTablesCSSPathProvider;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@OutOfBandNode
public class BootstrapDataTables
extends DataTables {
    private static IBootstrapDataTablesConfigurator s_aConfigurator;

    public BootstrapDataTables(@Nonnull IHCTable<?> iHCTable) {
        super(iHCTable);
        this.setDom(new BootstrapDataTablesDom());
    }

    protected void onRegisterExternalResources(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, boolean bl) {
        super.onRegisterExternalResources(iHCConversionSettingsToNode, bl);
        PhotonJS.registerJSIncludeForThisRequest((IJSPathProvider)EDataTablesB4JSPathProvider.DATATABLES_BOOTSTRAP4);
        PhotonCSS.unregisterCSSIncludeFromThisRequest((ICSSPathProvider)EDataTablesCSSPathProvider.DATATABLES);
        PhotonCSS.registerCSSIncludeForThisRequest((ICSSPathProvider)EDataTablesB4CSSPathProvider.DATATABLES_BOOTSTRAP4);
        PhotonCSS.registerCSSIncludeForThisRequest((ICSSPathProvider)EDataTablesCSSPathProvider.BOOTSTRAP4_DATATABLES_PH);
    }

    @Nullable
    public static IBootstrapDataTablesConfigurator getConfigurator() {
        return s_aConfigurator;
    }

    public static void setConfigurator(@Nullable IBootstrapDataTablesConfigurator iBootstrapDataTablesConfigurator) {
        s_aConfigurator = iBootstrapDataTablesConfigurator;
    }

    @Nonnull
    public static BootstrapDataTables createDefaultDataTables(@Nonnull ILayoutExecutionContext iLayoutExecutionContext, @Nonnull IHCTable<?> iHCTable) {
        ((IHCTable)((IHCTable)iHCTable.addClass(CBootstrapCSS.TABLE)).addClass(CBootstrapCSS.TABLE_STRIPED)).addClass(CBootstrapCSS.TABLE_SM);
        BootstrapDataTables bootstrapDataTables = new BootstrapDataTables(iHCTable);
        bootstrapDataTables.setDisplayLocale(iLayoutExecutionContext.getDisplayLocale());
        bootstrapDataTables.addAllColumns(iHCTable);
        if (s_aConfigurator != null) {
            s_aConfigurator.configure(iLayoutExecutionContext, iHCTable, bootstrapDataTables);
        }
        if (iHCTable instanceof AbstractHCTable) {
            ((AbstractHCTable)iHCTable).setRenderColGroupIfPresent(false);
        }
        return bootstrapDataTables;
    }
}

