/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.stub.init;

import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.photon.ajax.servlet.PhotonAjaxServlet;
import com.helger.photon.api.servlet.PhotonAPIServlet;
import com.helger.photon.bootstrap4.stub.PhotonStubServletContextListener;
import com.helger.photon.core.go.GoServlet;
import com.helger.photon.core.resource.ResourceBundleServlet;
import com.helger.photon.core.servlet.LogoutServlet;
import com.helger.photon.core.servlet.StreamServlet;
import com.helger.photon.core.userdata.UserStreamServlet;
import com.helger.photon.core.userdata.UserUploadServlet;
import com.helger.servlet.filter.CharacterEncodingFilter;
import jakarta.annotation.Nonnull;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.ServletContext;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class PhotonStubServletInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhotonStubServletInitializer.class);
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean(false);
    private static final PhotonStubServletInitializer INSTANCE = new PhotonStubServletInitializer();

    private PhotonStubServletInitializer() {
    }

    public static boolean areServletsRegistered() {
        return INITIALIZED.get();
    }

    public static void registerServlets(@Nonnull ServletContext servletContext) {
        ValueEnforcer.notNull((Object)servletContext, (String)"ServletContext");
        if (INITIALIZED.compareAndSet(false, true)) {
            if (servletContext.getMajorVersion() < 3) {
                throw new IllegalStateException("At least servlet version 3 is required! Currently running version " + servletContext.getMajorVersion() + "." + servletContext.getMinorVersion());
            }
            LOGGER.info("Registering default ph-oton listeners and servlets");
            FilterRegistration.Dynamic dynamic = servletContext.addFilter("CharacterEncodingFilter", CharacterEncodingFilter.class);
            if (dynamic != null) {
                dynamic.setAsyncSupported(true);
                dynamic.setInitParameter("encoding", StandardCharsets.UTF_8.name());
                dynamic.setInitParameter("forceEncoding", Boolean.TRUE.toString());
                dynamic.addMappingForUrlPatterns(null, false, new String[]{"/*"});
            }
            if ((dynamic = servletContext.addServlet("PhotonAjaxServlet", PhotonAjaxServlet.class)) != null) {
                dynamic.setAsyncSupported(true);
                dynamic.addMapping(new String[]{"/ajax/*"});
            }
            if ((dynamic = servletContext.addServlet("PhotonAPIServlet", PhotonAPIServlet.class)) != null) {
                dynamic.setAsyncSupported(true);
                dynamic.addMapping(new String[]{"/api/*"});
            }
            if ((dynamic = servletContext.addServlet("StreamServlet", StreamServlet.class)) != null) {
                dynamic.setAsyncSupported(true);
                dynamic.setInitParameter("allowedExtensions", "$web-default$");
                dynamic.addMapping(new String[]{"/stream/*"});
            }
            if ((dynamic = servletContext.addServlet("UserStreamServlet", UserStreamServlet.class)) != null) {
                dynamic.setAsyncSupported(true);
                dynamic.setInitParameter("allowedExtensions", "$web-default$");
                dynamic.addMapping(new String[]{"/user/*"});
            }
            if ((dynamic = servletContext.addServlet("UserUploadServlet", UserUploadServlet.class)) != null) {
                dynamic.setAsyncSupported(true);
                dynamic.addMapping(new String[]{"/userUpload/*"});
            }
            if ((dynamic = servletContext.addServlet("LogoutServlet", LogoutServlet.class)) != null) {
                dynamic.setAsyncSupported(true);
                dynamic.addMapping(new String[]{"/logout/*"});
            }
            if ((dynamic = servletContext.addServlet("ResourceBundleServlet", ResourceBundleServlet.class)) != null) {
                dynamic.setAsyncSupported(true);
                dynamic.setInitParameter("allowedExtensions", "js,css");
                dynamic.addMapping(new String[]{ResourceBundleServlet.SERVLET_DEFAULT_PATH + "/*"});
            }
            if ((dynamic = servletContext.addServlet("GoServlet", GoServlet.class)) != null) {
                dynamic.setAsyncSupported(true);
                dynamic.addMapping(new String[]{"/go/*"});
            }
            servletContext.addListener(PhotonStubServletContextListener.class);
            LOGGER.info("Finished registering default ph-oton listeners and servlets");
        }
    }
}

