/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.stub.init;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.debug.GlobalDebug;
import com.helger.base.system.SystemProperties;
import com.helger.html.CHTMLCharset;
import com.helger.html.hc.IHCCustomizer;
import com.helger.html.hc.config.HCConversionSettings;
import com.helger.html.hc.config.HCSettings;
import com.helger.html.hc.ext.HCCustomizerAutoFocusFirstCtrl;
import com.helger.html.hc.impl.HCCustomizerList;
import com.helger.html.jscode.customize.HCCustomizerExternalizeAttrJS;
import com.helger.html.meta.EStandardMetaElement;
import com.helger.html.meta.IMetaElement;
import com.helger.html.meta.MetaElement;
import com.helger.html.resource.css.ICSSPathProvider;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.io.resource.ClassPathResource;
import com.helger.io.resource.IReadableResource;
import com.helger.photon.app.html.PhotonCSS;
import com.helger.photon.app.html.PhotonJS;
import com.helger.photon.app.html.PhotonMetaElements;
import com.helger.photon.bootstrap4.BootstrapCustomConfig;
import com.helger.photon.core.appid.PhotonGlobalState;
import com.helger.photon.uicore.EUICoreCSSPathProvider;
import com.helger.photon.uicore.EUICoreJSPathProvider;
import com.helger.photon.uicore.icon.DefaultIcons;
import com.helger.photon.uictrls.autonumeric.AbstractHCAutoNumeric;
import com.helger.photon.uictrls.famfam.EFamFamFlagIcon;
import com.helger.photon.uictrls.famfam.EFamFamIcon;
import com.helger.xservlet.requesttrack.RequestTrackerSettings;
import java.nio.charset.Charset;
import org.slf4j.bridge.SLF4JBridgeHandler;

@Immutable
public final class PhotonStubInitializer {
    private PhotonStubInitializer() {
    }

    public static void registerDefaultResources() {
        for (ICSSPathProvider iCSSPathProvider : BootstrapCustomConfig.getAllBootstrapCSS()) {
            PhotonCSS.registerCSSIncludeForGlobal((ICSSPathProvider)iCSSPathProvider);
        }
        EFamFamIcon.registerResourcesForGlobal();
        EFamFamFlagIcon.registerResourcesForGlobal();
        PhotonCSS.registerCSSIncludeForGlobal((ICSSPathProvider)EUICoreCSSPathProvider.UICORE);
        PhotonJS.registerJSIncludeForGlobal((IJSPathProvider)EUICoreJSPathProvider.JQUERY_3);
        PhotonJS.registerJSIncludeForGlobal((IJSPathProvider)EUICoreJSPathProvider.UICORE_JQUERY);
        PhotonJS.registerJSIncludeForGlobal((IJSPathProvider)EUICoreJSPathProvider.UICORE_FORM);
        for (ICSSPathProvider iCSSPathProvider : BootstrapCustomConfig.getAllBootstrapJS()) {
            PhotonJS.registerJSIncludeForGlobal((IJSPathProvider)iCSSPathProvider);
        }
        PhotonMetaElements.registerMetaElementForGlobal((IMetaElement)MetaElement.createMetaCharset((Charset)CHTMLCharset.CHARSET_HTML_OBJ));
        PhotonMetaElements.registerMetaElementForGlobal((IMetaElement)EStandardMetaElement.GENERATOR.getAsMetaElement("ph-oton stack - https://github.com/phax/ph-oton"));
        PhotonMetaElements.registerMetaElementForGlobal((IMetaElement)EStandardMetaElement.VIEWPORT.getAsMetaElement("width=device-width, initial-scale=1, shrink-to-fit=no"));
        PhotonCSS.readCSSIncludesForGlobal((IReadableResource)new ClassPathResource("html/css.xml"));
        PhotonJS.readJSIncludesForGlobal((IReadableResource)new ClassPathResource("html/js.xml"));
        PhotonMetaElements.readMetaElementsForGlobal((IReadableResource)new ClassPathResource("html/metatags.xml"));
    }

    public static void onContextInitialized() {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        if (GlobalDebug.isDebugMode()) {
            SystemProperties.setPropertyValue((String)"sun.io.serialization.extendedDebugInfo", (String)"true");
            RequestTrackerSettings.setLongRunningRequestsCheckEnabled((boolean)false);
            RequestTrackerSettings.setParallelRunningRequestsCheckEnabled((boolean)false);
        }
        if (HCConversionSettings.isDefaultCustomizer((IHCCustomizer)HCSettings.getConversionSettings().getCustomizer())) {
            HCSettings.getMutableConversionSettings().setCustomizer((IHCCustomizer)new HCCustomizerList(new IHCCustomizer[]{new HCCustomizerAutoFocusFirstCtrl(), new HCCustomizerExternalizeAttrJS()}));
        }
        if (!DefaultIcons.areDefined()) {
            EFamFamIcon.setAsDefault();
        }
        AbstractHCAutoNumeric.setDefaultThousandSeparator((String)"");
        if (!PhotonGlobalState.containsAnyApplicationServletPathMapping()) {
            PhotonGlobalState.state((String)"public").setServletPath("/public");
            PhotonGlobalState.state((String)"secure").setServletPath("/secure");
        }
        if (!PhotonGlobalState.getInstance().hasDefaultApplicationID()) {
            PhotonGlobalState.getInstance().setDefaultApplicationID("public");
        }
    }
}

