/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app.url;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.url.URLHelper;
import com.helger.io.resource.ClassPathResource;
import com.helger.io.resource.IReadableResource;
import com.helger.io.resource.URLResource;
import com.helger.photon.app.url.IWebURIToURLConverter;
import com.helger.photon.app.url.LinkHelper;
import com.helger.photon.io.WebFileIO;
import com.helger.url.SimpleURL;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamOrLocalURIToURLConverter
implements IWebURIToURLConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamOrLocalURIToURLConverter.class);

    public static final boolean isProjectRelativeURI(@Nonnull @Nonempty String string) {
        return StringHelper.startsWith((CharSequence)string, (char)'/');
    }

    @Override
    @Nonnull
    public IReadableResource getAsResource(@Nonnull @Nonempty String string) {
        return StreamOrLocalURIToURLConverter.getAsResourceStatic(string);
    }

    @Nonnull
    public static IReadableResource getAsResourceStatic(@Nonnull @Nonempty String string) {
        Object object;
        ValueEnforcer.notEmpty((CharSequence)string, (String)"URI");
        if (LinkHelper.hasKnownProtocol(string)) {
            LOGGER.info("Opening '" + string + "' via a URLResource");
            object = new URLResource(URLHelper.getAsURL((String)string));
        } else {
            object = StreamOrLocalURIToURLConverter.isProjectRelativeURI(string) ? WebFileIO.getServletContextIO().getResource(string.substring(1)) : new ClassPathResource(string);
        }
        return object;
    }

    @Override
    @Nonnull
    public SimpleURL getAsURL(@Nonnull @Nonempty String string) {
        return StreamOrLocalURIToURLConverter.getAsURLStatic(string);
    }

    @Nonnull
    public static SimpleURL getAsURLStatic(@Nonnull @Nonempty String string) {
        SimpleURL simpleURL;
        ValueEnforcer.notEmpty((CharSequence)string, (String)"URI");
        if (LinkHelper.hasKnownProtocol(string)) {
            simpleURL = new SimpleURL(string);
        } else if (StreamOrLocalURIToURLConverter.isProjectRelativeURI(string)) {
            simpleURL = LinkHelper.getURLWithContext(string);
        } else {
            Object object = LinkHelper.getStreamServletPath();
            if (!StringHelper.startsWith((CharSequence)string, (char)'/')) {
                object = (String)object + "/";
            }
            simpleURL = LinkHelper.getURLWithContext((String)object + string);
        }
        return simpleURL;
    }

    @Override
    @Nonnull
    public SimpleURL getAsURL(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull @Nonempty String string) {
        return StreamOrLocalURIToURLConverter.getAsURLStatic(iRequestWebScopeWithoutResponse, string);
    }

    @Nonnull
    public static SimpleURL getAsURLStatic(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull @Nonempty String string) {
        ValueEnforcer.notNull((Object)iRequestWebScopeWithoutResponse, (String)"RequestScope");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"URI");
        SimpleURL simpleURL = LinkHelper.hasKnownProtocol(string) ? new SimpleURL(string) : (StreamOrLocalURIToURLConverter.isProjectRelativeURI(string) ? LinkHelper.getURLWithContext(iRequestWebScopeWithoutResponse, string) : LinkHelper.getStreamURL(iRequestWebScopeWithoutResponse, string));
        return simpleURL;
    }
}

