/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app.resource;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.debug.GlobalDebug;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.photon.app.resource.EWebSiteResourceType;
import com.helger.photon.app.resource.WebSiteResource;
import jakarta.annotation.Nonnull;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class WebSiteResourceCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSiteResourceCache.class);
    private static final AtomicBoolean SILENT_MODE = new AtomicBoolean(true);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bCacheEnabled = !GlobalDebug.isDebugMode();
    @GuardedBy(value="RW_LOCK")
    private static final ICommonsMap<String, WebSiteResource> s_aMap = new CommonsHashMap();
    private static final WebSiteResourceCache INSTANCE = new WebSiteResourceCache();

    private WebSiteResourceCache() {
    }

    public static boolean isSilentMode() {
        return SILENT_MODE.get();
    }

    public static boolean setSilentMode(boolean bl) {
        return SILENT_MODE.getAndSet(bl);
    }

    public static boolean isCacheEnabled() {
        return RW_LOCK.readLockedBoolean(() -> s_bCacheEnabled);
    }

    public static void setCacheEnabled(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bCacheEnabled = bl;
        });
        if (!WebSiteResourceCache.isSilentMode()) {
            LOGGER.info("WebSiteResourceCache is now: " + (bl ? "enabled" : "disabled"));
        }
    }

    @Nonnull
    public static WebSiteResource getOrCreateResource(@Nonnull EWebSiteResourceType eWebSiteResourceType, @Nonnull @Nonempty String string, @Nonnull Charset charset) {
        ValueEnforcer.notNull((Object)((Object)eWebSiteResourceType), (String)"ResourceType");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Path");
        ValueEnforcer.notNull((Object)charset, (String)"Charset");
        if (!WebSiteResourceCache.isCacheEnabled()) {
            WebSiteResource webSiteResource = new WebSiteResource(eWebSiteResourceType, string, charset);
            if (!webSiteResource.isExisting()) {
                throw new IllegalArgumentException("WebSiteResource '" + string + "' of type " + String.valueOf((Object)eWebSiteResourceType) + " does not exist");
            }
            return webSiteResource;
        }
        String string2 = eWebSiteResourceType.getID() + "-" + string;
        WebSiteResource webSiteResource = (WebSiteResource)RW_LOCK.readLockedGet(() -> (WebSiteResource)s_aMap.get((Object)string2));
        if (webSiteResource != null) {
            return webSiteResource;
        }
        return (WebSiteResource)RW_LOCK.writeLockedGet(() -> (WebSiteResource)s_aMap.computeIfAbsent((Object)string2, string2 -> new WebSiteResource(eWebSiteResourceType, string, charset)));
    }

    @Nonnull
    public static EChange removeFromCache(@Nonnull EWebSiteResourceType eWebSiteResourceType, @Nonnull @Nonempty String string) {
        ValueEnforcer.notNull((Object)((Object)eWebSiteResourceType), (String)"Type");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Path");
        String string2 = eWebSiteResourceType.getID() + "-" + string;
        return (EChange)RW_LOCK.writeLockedGet(() -> s_aMap.removeObject((Object)string2));
    }

    @Nonnull
    public static EChange clearCache() {
        return (EChange)RW_LOCK.writeLockedGet(() -> s_aMap.removeAll());
    }
}

