/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app.resource;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.charset.CharsetHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.id.factory.GlobalIDFactory;
import com.helger.base.state.EChange;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringParser;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsMap;
import com.helger.css.media.CSSMediaList;
import com.helger.css.media.ECSSMedium;
import com.helger.css.media.ICSSMediaList;
import com.helger.dao.DAOException;
import com.helger.io.file.FileOperationManager;
import com.helger.io.file.FileSystemIterator;
import com.helger.photon.app.resource.EWebSiteResourceType;
import com.helger.photon.app.resource.IWebSiteResourceBundleProvider;
import com.helger.photon.app.resource.WebSiteResource;
import com.helger.photon.app.resource.WebSiteResourceBundle;
import com.helger.photon.app.resource.WebSiteResourceBundleSerialized;
import com.helger.photon.app.resource.WebSiteResourceWithCondition;
import com.helger.photon.io.WebFileIO;
import com.helger.photon.io.dao.AbstractPhotonSimpleDAO;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroDocument;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebSiteResourceBundleManager
extends AbstractPhotonSimpleDAO
implements IWebSiteResourceBundleProvider {
    private static final String ELEMENT_RESOURCE_BUNDLES = "resource-bundles";
    private static final String ELEMENT_RESOURCE_BUNDLE = "resource-bundle";
    private static final String ATTR_ID = "id";
    private static final String ATTR_CREATIONDT = "creationdt";
    private static final String ATTR_CONDITIONAL_COMMENT = "conditionalcomment";
    private static final String ATTR_IS_BUNDLABLE = "canbebundled";
    private static final String ELEMENT_MEDIUM = "medium";
    private static final String ELEMENT_RESOURCE = "resource";
    private static final String ATTR_RESOURCE_TYPE = "resourcetype";
    private static final String ATTR_PATH = "path";
    private static final String ATTR_URL = "url";
    private static final String ATTR_CONTENT_HASH = "contenthash";
    private static final String ATTR_CHARSET = "charset";
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSiteResourceBundleManager.class);
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<WebSiteResourceBundle, String> m_aMapToData = new CommonsHashMap();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, WebSiteResourceBundleSerialized> m_aMapToBundle = new CommonsHashMap();

    public WebSiteResourceBundleManager(@Nullable String string) throws DAOException {
        super(string);
        this.initialRead();
    }

    @Nonnull
    protected EChange onRead(@Nonnull IMicroDocument iMicroDocument) {
        boolean bl = false;
        for (Object object : iMicroDocument.getDocumentElement().getAllChildElements(ELEMENT_RESOURCE_BUNDLE)) {
            Object object2;
            Object object3;
            Object object42;
            boolean bl2 = false;
            String string = object.getAttributeValue(ATTR_ID);
            LocalDateTime localDateTime = (LocalDateTime)object.getAttributeValueWithConversion(ATTR_CREATIONDT, LocalDateTime.class);
            String string2 = object.getAttributeValue(ATTR_CONDITIONAL_COMMENT);
            String string3 = object.getAttributeValue(ATTR_IS_BUNDLABLE);
            boolean bl3 = StringParser.parseBool((String)string3, (boolean)true);
            CSSMediaList cSSMediaList = new CSSMediaList();
            for (Object object42 : object.getAllChildElements(ELEMENT_MEDIUM)) {
                object3 = object42.getTextContentTrimmed();
                object2 = ECSSMedium.getFromNameOrNull((String)object3);
                if (object2 == null) {
                    throw new IllegalStateException("Failed to resolve CSS medium '" + (String)object3 + "'");
                }
                cSSMediaList.addMedium(object2);
            }
            Iterator iterator = new CommonsArrayList();
            if (!WebSiteResourceBundleSerialized.getResource(string).exists()) {
                LOGGER.warn("No serialized bundle with ID '" + string + "' exists.");
                bl2 = true;
            } else {
                object42 = object.getAllChildElements(ELEMENT_RESOURCE).iterator();
                while (object42.hasNext()) {
                    object3 = (IMicroElement)object42.next();
                    object2 = object3.getAttributeValue(ATTR_RESOURCE_TYPE);
                    EWebSiteResourceType eWebSiteResourceType = EWebSiteResourceType.getFromIDOrNull((String)object2);
                    if (eWebSiteResourceType == null) {
                        LOGGER.warn("No such resource type: " + (String)object2);
                        bl2 = true;
                        continue;
                    }
                    String string4 = object3.getAttributeValue(ATTR_PATH);
                    String string5 = object3.getAttributeValue(ATTR_URL);
                    String string6 = object3.getAttributeValue(ATTR_CONTENT_HASH);
                    String string7 = object3.getAttributeValue(ATTR_CHARSET);
                    Charset charset = string7 == null ? WebSiteResource.DEFAULT_CHARSET : CharsetHelper.getCharsetFromName((String)string7);
                    WebSiteResource webSiteResource = new WebSiteResource(eWebSiteResourceType, string4, charset);
                    if (!webSiteResource.isExisting()) {
                        LOGGER.info("Skipping resource bundle '" + string + "' skipping because resource '" + string4 + "' does not exist");
                        bl2 = true;
                        continue;
                    }
                    if (!webSiteResource.getContentHashAsString().equals(string6)) {
                        LOGGER.info("Skipping resource bundle '" + string + "' skipping because resource '" + string4 + "' changed (hash mismatch)");
                        bl2 = true;
                        continue;
                    }
                    iterator.add(new WebSiteResourceWithCondition(webSiteResource, string2, bl3, (ICSSMediaList)cSSMediaList));
                }
            }
            if (bl2) {
                bl = true;
                continue;
            }
            object42 = new WebSiteResourceBundle((List<WebSiteResourceWithCondition>)((Object)iterator), string2, bl3, (ICSSMediaList)cSSMediaList);
            object3 = new WebSiteResourceBundleSerialized(string, (WebSiteResourceBundle)object42, localDateTime);
            this.m_aMapToData.put(object42, (Object)string);
            this.m_aMapToBundle.put((Object)string, object3);
        }
        File file = WebFileIO.getDataIO().getFile("resource-bundles/");
        for (File file2 : new FileSystemIterator(file)) {
            if (this.containsResourceBundleOfID(file2.getName()) || !FileOperationManager.INSTANCE.deleteFile(file2).isSuccess()) continue;
            LOGGER.info("Successfully deleted the unused resource bundle file " + file2.getAbsolutePath());
        }
        LOGGER.info("Successfully read " + this.m_aMapToBundle.size() + " resource bundles");
        return bl ? EChange.CHANGED : EChange.UNCHANGED;
    }

    @Nonnull
    protected IMicroDocument createWriteData() {
        MicroDocument microDocument = new MicroDocument();
        IMicroElement iMicroElement = microDocument.addElement(ELEMENT_RESOURCE_BUNDLES);
        for (WebSiteResourceBundleSerialized webSiteResourceBundleSerialized : this.m_aMapToBundle.getSortedByKey(Comparator.naturalOrder()).values()) {
            IMicroElement iMicroElement2 = iMicroElement.addElement(ELEMENT_RESOURCE_BUNDLE);
            iMicroElement2.setAttribute(ATTR_ID, webSiteResourceBundleSerialized.getBundleID());
            iMicroElement2.setAttributeWithConversion(ATTR_CREATIONDT, (Object)webSiteResourceBundleSerialized.getCreationDT());
            WebSiteResourceBundle webSiteResourceBundle = webSiteResourceBundleSerialized.getBundle();
            iMicroElement2.setAttribute(ATTR_CONDITIONAL_COMMENT, webSiteResourceBundle.getConditionalComment());
            iMicroElement2.setAttribute(ATTR_IS_BUNDLABLE, Boolean.toString(webSiteResourceBundle.isBundlable()));
            if (webSiteResourceBundle.hasMediaList()) {
                for (WebSiteResource webSiteResource : webSiteResourceBundle.getMediaList().getAllMedia()) {
                    iMicroElement2.addElement(ELEMENT_MEDIUM).addText((CharSequence)webSiteResource.getName());
                }
            }
            for (WebSiteResource webSiteResource : webSiteResourceBundle.getAllResources()) {
                IMicroElement iMicroElement3 = iMicroElement2.addElement(ELEMENT_RESOURCE);
                iMicroElement3.setAttribute(ATTR_RESOURCE_TYPE, webSiteResource.getResourceType().getID());
                iMicroElement3.setAttribute(ATTR_PATH, webSiteResource.getPath());
                iMicroElement3.setAttribute(ATTR_URL, webSiteResource.getAsURLString());
                iMicroElement3.setAttribute(ATTR_CONTENT_HASH, webSiteResource.getContentHashAsString());
                iMicroElement3.setAttribute(ATTR_CHARSET, webSiteResource.getCharset().name());
            }
        }
        return microDocument;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, WebSiteResourceBundleSerialized> getAllResourceBundles() {
        return (ICommonsMap)this.m_aRWLock.readLockedGet(() -> this.m_aMapToBundle.getClone());
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<WebSiteResourceBundleSerialized> getAllResourceBundlesSerialized() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> this.m_aMapToBundle.copyOfValues());
    }

    @Nullable
    public WebSiteResourceBundleSerialized getResourceBundleOfID(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        return (WebSiteResourceBundleSerialized)this.m_aRWLock.readLockedGet(() -> (WebSiteResourceBundleSerialized)this.m_aMapToBundle.get((Object)string));
    }

    public boolean containsResourceBundleOfID(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return false;
        }
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aMapToBundle.containsKey((Object)string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<WebSiteResourceBundleSerialized> getResourceBundles(@Nonnull @Nonempty ICommonsList<WebSiteResourceWithCondition> iCommonsList, boolean bl) {
        ValueEnforcer.notEmptyNoNullValue(iCommonsList, (String)"List");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        boolean bl2 = false;
        CommonsArrayList commonsArrayList2 = new CommonsArrayList(iCommonsList);
        while (commonsArrayList2.isNotEmpty()) {
            WebSiteResourceBundleSerialized webSiteResourceBundleSerialized;
            String string;
            Object object;
            WebSiteResourceWithCondition webSiteResourceWithCondition = (WebSiteResourceWithCondition)commonsArrayList2.removeFirstOrNull();
            CommonsArrayList commonsArrayList3 = new CommonsArrayList((Object)webSiteResourceWithCondition);
            while (commonsArrayList2.isNotEmpty() && webSiteResourceWithCondition.canBeBundledWith((WebSiteResourceWithCondition)(object = (WebSiteResourceWithCondition)commonsArrayList2.getFirstOrNull()))) {
                commonsArrayList3.add(object);
                commonsArrayList2.removeFirstOrNull();
            }
            object = new WebSiteResourceBundle((List<WebSiteResourceWithCondition>)commonsArrayList3, webSiteResourceWithCondition.getConditionalComment(), commonsArrayList3.size() != 1 || webSiteResourceWithCondition.isBundlable(), webSiteResourceWithCondition.getMediaList());
            this.m_aRWLock.readLock().lock();
            try {
                string = (String)this.m_aMapToData.get(object);
                webSiteResourceBundleSerialized = (WebSiteResourceBundleSerialized)this.m_aMapToBundle.get((Object)string);
            }
            finally {
                this.m_aRWLock.readLock().unlock();
            }
            if (webSiteResourceBundleSerialized == null) {
                this.m_aRWLock.writeLock().lock();
                try {
                    string = (String)this.m_aMapToData.get(object);
                    if (string == null) {
                        string = GlobalIDFactory.getNewPersistentStringID();
                        this.m_aMapToData.put(object, (Object)string);
                        webSiteResourceBundleSerialized = new WebSiteResourceBundleSerialized(string, (WebSiteResourceBundle)object, bl);
                        this.m_aMapToBundle.put((Object)string, (Object)webSiteResourceBundleSerialized);
                        bl2 = true;
                    } else {
                        webSiteResourceBundleSerialized = (WebSiteResourceBundleSerialized)this.m_aMapToBundle.get((Object)string);
                    }
                }
                finally {
                    this.m_aRWLock.writeLock().unlock();
                }
            }
            commonsArrayList.add((Object)webSiteResourceBundleSerialized);
        }
        if (bl2) {
            this.m_aRWLock.writeLocked(() -> this.markAsChanged());
        }
        return commonsArrayList;
    }
}

