/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app.resource;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.CGlobal;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringHex;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.decl.visit.AbstractModifyingCSSUrlVisitor;
import com.helger.css.decl.visit.CSSVisitor;
import com.helger.css.decl.visit.ICSSUrlVisitor;
import com.helger.css.reader.CSSReader;
import com.helger.css.reader.CSSReaderSettings;
import com.helger.css.writer.CSSWriter;
import com.helger.io.file.FilenameHelper;
import com.helger.io.resource.IReadableResource;
import com.helger.io.resource.URLResource;
import com.helger.photon.app.PhotonAppSettings;
import com.helger.photon.app.resource.EWebSiteResourceType;
import com.helger.photon.app.url.LinkHelper;
import com.helger.security.messagedigest.EMessageDigestAlgorithm;
import com.helger.security.messagedigest.MessageDigestValue;
import com.helger.url.ISimpleURL;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class WebSiteResource {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSiteResource.class);
    private final EWebSiteResourceType m_eResourceType;
    private final String m_sPath;
    private final Charset m_aCharset;
    private final IReadableResource m_aResource;
    private final boolean m_bResourceExists;
    private final byte[] m_aContentHash;
    private final String m_sContentHash;
    private int m_nHashCode = 0;

    public WebSiteResource(@Nonnull EWebSiteResourceType eWebSiteResourceType, @Nonnull @Nonempty String string, @Nonnull Charset charset) {
        this.m_eResourceType = (EWebSiteResourceType)((Object)ValueEnforcer.notNull((Object)((Object)eWebSiteResourceType), (String)"ResourceType"));
        this.m_sPath = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"Path");
        this.m_aCharset = (Charset)ValueEnforcer.notNull((Object)charset, (String)"Charset");
        this.m_aResource = PhotonAppSettings.getURIToURLConverter().getAsResource(string);
        this.m_bResourceExists = this.m_aResource.exists();
        if (this.m_bResourceExists && !(this.m_aResource instanceof URLResource)) {
            byte[] byArray = CGlobal.EMPTY_BYTE_ARRAY;
            try {
                InputStream inputStream = this.m_aResource.getInputStream();
                if (inputStream != null) {
                    byArray = MessageDigestValue.create((InputStream)inputStream, (EMessageDigestAlgorithm)EMessageDigestAlgorithm.SHA_512).bytes();
                }
            }
            catch (IOException | NullPointerException exception) {
                LOGGER.error("Failed to create message digest of " + this.m_aResource.getPath(), (Throwable)exception);
            }
            this.m_aContentHash = byArray;
            this.m_sContentHash = StringHex.getHexEncoded((byte[])byArray);
        } else {
            this.m_aContentHash = CGlobal.EMPTY_BYTE_ARRAY;
            this.m_sContentHash = "";
        }
    }

    @Nonnull
    public final EWebSiteResourceType getResourceType() {
        return this.m_eResourceType;
    }

    @Nonnull
    @Nonempty
    public final String getPath() {
        return this.m_sPath;
    }

    @Nonnull
    public final IReadableResource getResource() {
        return this.m_aResource;
    }

    @Nonnull
    public final Charset getCharset() {
        return this.m_aCharset;
    }

    @Nonnull
    private String _readAndParseCSS(@Nonnull IHasInputStream iHasInputStream, final @Nonnull @Nonempty String string, boolean bl) {
        CascadingStyleSheet cascadingStyleSheet = CSSReader.readFromStream((IHasInputStream)iHasInputStream, (CSSReaderSettings)new CSSReaderSettings().setFallbackCharset(this.m_aCharset));
        if (cascadingStyleSheet == null) {
            LOGGER.error("Failed to parse CSS. Returning 'as-is'");
            return StreamHelper.getAllBytesAsString((IHasInputStream)iHasInputStream, (Charset)this.m_aCharset);
        }
        CSSVisitor.visitCSSUrl((CascadingStyleSheet)cascadingStyleSheet, (ICSSUrlVisitor)new AbstractModifyingCSSUrlVisitor(){

            protected String getModifiedURI(@Nonnull String string2) {
                if (LinkHelper.hasKnownProtocol(string2)) {
                    return string2;
                }
                return FilenameHelper.getCleanConcatenatedUrlPath((String)string, (String)string2);
            }
        });
        return new CSSWriter(!bl).setWriteHeaderText(false).setWriteFooterText(false).getCSSAsString(cascadingStyleSheet);
    }

    @Nullable
    public String getContent(boolean bl) {
        if (!this.m_bResourceExists) {
            return null;
        }
        switch (this.m_eResourceType) {
            case JS: {
                return StreamHelper.getAllBytesAsString((IHasInputStream)this.m_aResource, (Charset)this.m_aCharset);
            }
            case CSS: {
                String string = FilenameHelper.getPath((String)PhotonAppSettings.getURIToURLConverter().getAsURL(this.m_sPath).getAsString());
                return this._readAndParseCSS((IHasInputStream)this.m_aResource, string, bl);
            }
        }
        throw new IllegalStateException("Unsupported resource type " + String.valueOf((Object)this.m_eResourceType));
    }

    public boolean isExisting() {
        return this.m_bResourceExists;
    }

    @Nullable
    public String getAsURLString() {
        URL uRL = this.m_aResource.getAsURL();
        if (uRL == null) {
            return null;
        }
        return uRL.toExternalForm();
    }

    @Nonnull
    @ReturnsMutableCopy
    public byte[] getContentHashBytes() {
        return ArrayHelper.getCopy((byte[])this.m_aContentHash);
    }

    @Nonnull
    public String getContentHashAsString() {
        return this.m_sContentHash;
    }

    @Nonnull
    public ISimpleURL getAsURL(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        String string = this.m_sContentHash.length() >= 16 ? this.m_sContentHash.substring(0, 16) : "";
        return PhotonAppSettings.getURIToURLConverter().getAsURL(iRequestWebScopeWithoutResponse, this.m_sPath).addIf("version", string, StringHelper::isNotEmpty);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        WebSiteResource webSiteResource = (WebSiteResource)object;
        return this.m_eResourceType.equals((Object)webSiteResource.m_eResourceType) && this.m_sPath.equals(webSiteResource.m_sPath) && this.m_aCharset.equals(webSiteResource.m_aCharset);
    }

    public int hashCode() {
        int n = this.m_nHashCode;
        if (n == 0) {
            n = this.m_nHashCode = new HashCodeGenerator((Object)this).append((Object)this.m_eResourceType).append((Object)this.m_sPath).append((Object)this.m_aCharset).getHashCode();
        }
        return n;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ResourceType", (Enum)this.m_eResourceType).append("Path", (Object)this.m_sPath).append("Charset", (Object)this.m_aCharset).getToString();
    }
}

