/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app.mock;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.stack.NonBlockingStack;
import com.helger.dao.AbstractDAO;
import com.helger.io.file.FileOperationManager;
import com.helger.photon.app.mock.PhotonAppTestInit;
import com.helger.photon.io.WebFileIO;
import com.helger.scope.mock.ScopeTestRule;
import com.helger.servlet.ServletContextPathHolder;
import com.helger.web.scope.mock.WebScopeTestRule;
import jakarta.annotation.Nonnull;
import java.io.File;

public class PhotonAppWebTestRule
extends WebScopeTestRule {
    private final File m_aDataPath;
    private final String m_sServletContextPath;
    private boolean m_bDeleteAllData = false;
    private boolean m_bOldDAOSilentMode;
    private boolean m_bOldWebFileIOSilentMode;
    private boolean m_bOldSCCtxHolderSilentMode;
    private NonBlockingStack<Runnable> m_aCleansingRules;

    public PhotonAppWebTestRule() {
        this(ScopeTestRule.STORAGE_PATH);
    }

    public PhotonAppWebTestRule(@Nonnull File file) {
        this(file, file.getAbsolutePath());
    }

    public PhotonAppWebTestRule(@Nonnull File file, @Nonnull @Nonempty String string) {
        ValueEnforcer.notNull((Object)file, (String)"DataPath");
        ValueEnforcer.notNull((Object)string, (String)"ServletContextPath");
        this.m_aDataPath = file.getAbsoluteFile();
        this.m_sServletContextPath = string;
    }

    @Nonnull
    public final File getDataPath() {
        return this.m_aDataPath;
    }

    @Nonnull
    @Nonempty
    public final String getServletContextPath() {
        return this.m_sServletContextPath;
    }

    @Nonnull
    public final PhotonAppWebTestRule setDeleteAllData(boolean bl) {
        this.m_bDeleteAllData = bl;
        return this;
    }

    public void before() {
        this.m_bOldDAOSilentMode = AbstractDAO.setSilentMode((boolean)true);
        this.m_bOldWebFileIOSilentMode = WebFileIO.setSilentMode((boolean)true);
        this.m_bOldSCCtxHolderSilentMode = ServletContextPathHolder.setSilentMode((boolean)true);
        super.before();
        this.m_aCleansingRules = PhotonAppTestInit.init(this.m_aDataPath, this.m_sServletContextPath);
        if (this.m_bDeleteAllData) {
            FileOperationManager.INSTANCE.deleteDirRecursiveIfExisting(WebFileIO.getDataIO().getBasePathFile());
            FileOperationManager.INSTANCE.createDir(WebFileIO.getDataIO().getBasePathFile());
        }
    }

    public void after() {
        if (this.m_aCleansingRules != null) {
            while (this.m_aCleansingRules.isNotEmpty()) {
                Runnable runnable = (Runnable)this.m_aCleansingRules.pop();
                runnable.run();
            }
        }
        super.after();
        ServletContextPathHolder.setSilentMode((boolean)this.m_bOldSCCtxHolderSilentMode);
        WebFileIO.setSilentMode((boolean)this.m_bOldWebFileIOSilentMode);
        AbstractDAO.setSilentMode((boolean)this.m_bOldDAOSilentMode);
    }
}

