/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app.html;

import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsLinkedHashSet;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.html.resource.js.ConstantJSPathProvider;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.io.resource.IReadableResource;
import com.helger.photon.app.PhotonAppSettings;
import com.helger.photon.app.html.JSResourceSet;
import com.helger.web.scope.IRequestWebScope;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.web.scope.mgr.WebScopeManager;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.serialize.MicroReader;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class PhotonJS {
    public static final String DEFAULT_FILENAME = "html/js.xml";
    private static final String REQUEST_ATTR_JSRESOURCES = PhotonJS.class.getName();
    private static final Logger LOGGER = LoggerFactory.getLogger(PhotonJS.class);
    private static final JSResourceSet GLOBAL = new JSResourceSet();
    private static final SimpleLock LOCK = new SimpleLock();

    private PhotonJS() {
    }

    public static void _readJSIncludes(@Nonnull IReadableResource iReadableResource, @Nonnull JSResourceSet jSResourceSet) {
        IMicroDocument iMicroDocument;
        ValueEnforcer.notNull((Object)iReadableResource, (String)"Res");
        ValueEnforcer.notNull((Object)jSResourceSet, (String)"Target");
        IMicroDocument iMicroDocument2 = iMicroDocument = iReadableResource.exists() ? MicroReader.readMicroXML((IReadableResource)iReadableResource) : null;
        if (iMicroDocument != null) {
            for (IMicroElement iMicroElement : iMicroDocument.getDocumentElement().getAllChildElements("js")) {
                String string = iMicroElement.getAttributeValue("path");
                if (StringHelper.isEmpty((String)string)) {
                    LOGGER.error("Found JS item without a path in " + iReadableResource.getPath());
                    continue;
                }
                IReadableResource iReadableResource2 = PhotonAppSettings.getURIToURLConverter().getAsResource(string);
                if (!iReadableResource2.exists()) {
                    throw new IllegalStateException("The provided global JS resource '" + string + "' resolved to '" + String.valueOf(iReadableResource2) + "' does NOT exist!");
                }
                String string2 = iMicroElement.getAttributeValue("condcomment");
                jSResourceSet.addItem((IJSPathProvider)ConstantJSPathProvider.builder().path(string).minifiedPathFromPath().conditionalComment(string2).build());
            }
        }
    }

    public static void readJSIncludesForGlobal(@Nonnull IReadableResource iReadableResource) {
        PhotonJS._readJSIncludes(iReadableResource, GLOBAL);
    }

    public static void registerJSIncludeForGlobal(@Nonnull IJSPathProvider iJSPathProvider) {
        GLOBAL.addItem(iJSPathProvider);
    }

    public static void registerJSIncludeForGlobal(int n, @Nonnull IJSPathProvider iJSPathProvider) {
        GLOBAL.addItem(n, iJSPathProvider);
    }

    public static void unregisterJSIncludeForGlobal(@Nonnull IJSPathProvider iJSPathProvider) {
        GLOBAL.removeItem(iJSPathProvider);
    }

    public static void unregisterAllJSIncludesFromGlobal() {
        GLOBAL.removeAll();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsOrderedSet<IJSPathProvider> getAllRegisteredJSIncludesForGlobal() {
        return GLOBAL.getAllItems();
    }

    public static void getAllRegisteredJSIncludesForGlobal(@Nonnull Collection<? super IJSPathProvider> collection) {
        GLOBAL.getAllItems(collection);
    }

    public static boolean hasRegisteredJSIncludesForGlobal() {
        return GLOBAL.isNotEmpty();
    }

    @Nullable
    private static JSResourceSet _getPerRequestSet(boolean bl) {
        IRequestWebScope iRequestWebScope = WebScopeManager.getRequestScope();
        return (JSResourceSet)LOCK.lockedGet(() -> PhotonJS.lambda$_getPerRequestSet$0((IRequestWebScopeWithoutResponse)iRequestWebScope, bl));
    }

    public static void registerJSIncludeForThisRequest(@Nonnull IJSPathProvider iJSPathProvider) {
        PhotonJS._getPerRequestSet(true).addItem(iJSPathProvider);
    }

    public static void unregisterJSIncludeFromThisRequest(@Nonnull IJSPathProvider iJSPathProvider) {
        JSResourceSet jSResourceSet = PhotonJS._getPerRequestSet(false);
        if (jSResourceSet != null) {
            jSResourceSet.removeItem(iJSPathProvider);
        }
    }

    public static void unregisterAllJSIncludesFromThisRequest() {
        JSResourceSet jSResourceSet = PhotonJS._getPerRequestSet(false);
        if (jSResourceSet != null) {
            jSResourceSet.removeAll();
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsOrderedSet<IJSPathProvider> getAllRegisteredJSIncludesForThisRequest() {
        JSResourceSet jSResourceSet = PhotonJS._getPerRequestSet(false);
        if (jSResourceSet == null) {
            return new CommonsLinkedHashSet();
        }
        jSResourceSet.markAsCollected();
        return jSResourceSet.getAllItems();
    }

    public static void getAllRegisteredJSIncludesForThisRequest(@Nonnull Collection<? super IJSPathProvider> collection) {
        JSResourceSet jSResourceSet = PhotonJS._getPerRequestSet(false);
        if (jSResourceSet != null) {
            jSResourceSet.markAsCollected();
            jSResourceSet.getAllItems(collection);
        }
    }

    public static boolean hasRegisteredJSIncludesForThisRequest() {
        JSResourceSet jSResourceSet = PhotonJS._getPerRequestSet(false);
        return jSResourceSet != null && jSResourceSet.isNotEmpty();
    }

    private static /* synthetic */ JSResourceSet lambda$_getPerRequestSet$0(IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, boolean bl) {
        JSResourceSet jSResourceSet = (JSResourceSet)iRequestWebScopeWithoutResponse.attrs().getCastedValue((Object)REQUEST_ATTR_JSRESOURCES);
        if (jSResourceSet == null && bl) {
            jSResourceSet = new JSResourceSet();
            iRequestWebScopeWithoutResponse.attrs().putIn((Object)REQUEST_ATTR_JSRESOURCES, (Object)jSResourceSet);
        }
        return jSResourceSet;
    }
}

