/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app.html;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.EChange;
import com.helger.base.state.IChangeIndicator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsLinkedHashSet;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.collection.commons.ICommonsSet;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.photon.app.html.IWebResourceSet;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class JSResourceSet
implements IWebResourceSet<IJSPathProvider> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSResourceSet.class);
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsList<IJSPathProvider> m_aList = new CommonsArrayList();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsSet<IJSPathProvider> m_aItems = new CommonsLinkedHashSet();
    @GuardedBy(value="m_aRWLock")
    private boolean m_bIsCollected = false;

    public JSResourceSet() {
    }

    public JSResourceSet(@Nonnull JSResourceSet jSResourceSet) {
        ValueEnforcer.notNull((Object)jSResourceSet, (String)"Other");
        Iterator<IJSPathProvider> iterator = jSResourceSet.iterator();
        while (iterator.hasNext()) {
            IJSPathProvider iJSPathProvider = iterator.next();
            this.addItem(iJSPathProvider);
        }
    }

    public JSResourceSet(@Nonnull Collection<? extends IJSPathProvider> collection) {
        ValueEnforcer.notEmptyNoNullValue(collection, (String)"Other");
        for (IJSPathProvider iJSPathProvider : collection) {
            this.addItem(iJSPathProvider);
        }
    }

    public JSResourceSet(IJSPathProvider ... iJSPathProviderArray) {
        ValueEnforcer.notEmptyNoNullValue((Object[])iJSPathProviderArray, (String)"Other");
        for (IJSPathProvider iJSPathProvider : iJSPathProviderArray) {
            this.addItem(iJSPathProvider);
        }
    }

    private static void _collectWarn(@Nonnull String string) {
        LOGGER.warn(string);
    }

    @Override
    @Nonnull
    public EChange addItem(@Nonnull IJSPathProvider iJSPathProvider) {
        return this.addItem(-1, iJSPathProvider);
    }

    @Override
    @Nonnull
    public EChange addItem(int n, @Nonnull IJSPathProvider iJSPathProvider) {
        ValueEnforcer.notNull((Object)iJSPathProvider, (String)"JSPathProvider");
        return (EChange)this.m_aRWLock.writeLockedGet(() -> {
            if (!this.m_aItems.add((Object)iJSPathProvider)) {
                return EChange.UNCHANGED;
            }
            if (n >= 0) {
                this.m_aList.add(n, (Object)iJSPathProvider);
            } else {
                this.m_aList.add((Object)iJSPathProvider);
            }
            if (this.m_bIsCollected) {
                JSResourceSet._collectWarn("Adding item " + String.valueOf(iJSPathProvider) + " after collection!");
            }
            return EChange.CHANGED;
        });
    }

    @Override
    @Nonnull
    public EChange addItems(@Nonnull IWebResourceSet<? extends IJSPathProvider> iWebResourceSet) {
        ValueEnforcer.notNull(iWebResourceSet, (String)"Items");
        EChange eChange = EChange.UNCHANGED;
        Iterator iterator = iWebResourceSet.iterator();
        while (iterator.hasNext()) {
            IJSPathProvider iJSPathProvider = (IJSPathProvider)iterator.next();
            eChange = eChange.or((IChangeIndicator)this.addItem(iJSPathProvider));
        }
        return eChange;
    }

    @Override
    @Nonnull
    public EChange addItems(int n, @Nonnull IWebResourceSet<? extends IJSPathProvider> iWebResourceSet) {
        ValueEnforcer.notNull(iWebResourceSet, (String)"Items");
        if (n < 0) {
            return this.addItems(iWebResourceSet);
        }
        EChange eChange = EChange.UNCHANGED;
        int n2 = n;
        Iterator iterator = iWebResourceSet.iterator();
        while (iterator.hasNext()) {
            IJSPathProvider iJSPathProvider = (IJSPathProvider)iterator.next();
            if (!this.addItem(n2, iJSPathProvider).isChanged()) continue;
            eChange = EChange.CHANGED;
            ++n2;
        }
        return eChange;
    }

    @Override
    @Nonnull
    public EChange removeItem(@Nonnull IJSPathProvider iJSPathProvider) {
        ValueEnforcer.notNull((Object)iJSPathProvider, (String)"JSPathProvider");
        return (EChange)this.m_aRWLock.writeLockedGet(() -> {
            if (!this.m_aItems.remove((Object)iJSPathProvider)) {
                return EChange.UNCHANGED;
            }
            this.m_aList.remove((Object)iJSPathProvider);
            if (this.m_bIsCollected) {
                JSResourceSet._collectWarn("Removed item " + String.valueOf(iJSPathProvider) + " after collection!");
            }
            return EChange.CHANGED;
        });
    }

    @Override
    @Nonnull
    public EChange removeAll() {
        return (EChange)this.m_aRWLock.writeLockedGet(() -> {
            if (this.m_aItems.isEmpty()) {
                return EChange.UNCHANGED;
            }
            this.m_aItems.clear();
            this.m_aList.clear();
            if (this.m_bIsCollected) {
                JSResourceSet._collectWarn("Removed all items after collection!");
            }
            return EChange.CHANGED;
        });
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<IJSPathProvider> getAllItems() {
        return (ICommonsOrderedSet)this.m_aRWLock.readLockedGet(() -> new CommonsLinkedHashSet(this.m_aList));
    }

    @Override
    public void getAllItems(@Nonnull Collection<? super IJSPathProvider> collection) {
        ValueEnforcer.notNull(collection, (String)"Target");
        this.m_aRWLock.readLockedBoolean(() -> collection.addAll((Collection<? super IJSPathProvider>)this.m_aList));
    }

    @Override
    public boolean isEmpty() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aList.isEmpty());
    }

    @Override
    public boolean isNotEmpty() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aList.isNotEmpty());
    }

    @Nonnegative
    public int size() {
        return this.m_aRWLock.readLockedInt(() -> this.m_aList.size());
    }

    @Nonnull
    public Iterator<IJSPathProvider> iterator() {
        return (Iterator)this.m_aRWLock.readLockedGet(() -> this.m_aList.iterator());
    }

    public boolean isCollected() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_bIsCollected);
    }

    @Override
    public void markAsCollected() {
        this.m_aRWLock.writeLocked(() -> {
            if (this.m_bIsCollected) {
                JSResourceSet._collectWarn("Resource set was already collected before!");
            }
            this.m_bIsCollected = true;
        });
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JSResourceSet jSResourceSet = (JSResourceSet)object;
        return this.m_aList.equals(jSResourceSet.m_aList);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aList).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("list", this.m_aList).getToString();
    }
}

