/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app.csrf;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.UsedViaReflection;
import com.helger.base.codec.base64.Base64;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.ICommonsSet;
import com.helger.web.scope.singleton.AbstractGlobalWebSingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class CSRFManager
extends AbstractGlobalWebSingleton {
    public static final int NONCE_BYTES = 32;
    private static final Logger LOGGER = LoggerFactory.getLogger(CSRFManager.class);
    @GuardedBy(value="m_aRWLock")
    private final ICommonsSet<String> m_aNoncesBase64 = new CommonsHashSet();

    @Deprecated(forRemoval=false)
    @UsedViaReflection
    public CSRFManager() {
    }

    @Nonnull
    public static CSRFManager getInstance() {
        return (CSRFManager)CSRFManager.getGlobalSingleton(CSRFManager.class);
    }

    @Nullable
    public static CSRFManager getInstanceIfInstantiated() {
        return (CSRFManager)CSRFManager.getGlobalSingletonIfInstantiated(CSRFManager.class);
    }

    @Nonnull
    @Nonempty
    public String createNewNonce() {
        return (String)this.m_aRWLock.writeLockedGet(() -> {
            String string;
            int n = 0;
            ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
            do {
                byte[] byArray = new byte[32];
                threadLocalRandom.nextBytes(byArray);
                string = Base64.encodeBytes((byte[])byArray);
                if (++n <= 100) continue;
                throw new IllegalStateException("Failed to create a unique nonce after " + n + " tries!");
            } while (!this.m_aNoncesBase64.add((Object)string));
            return string;
        });
    }

    public void removeNonce(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Nonce");
        this.m_aRWLock.writeLocked(() -> {
            if (!this.m_aNoncesBase64.remove((Object)string)) {
                LOGGER.error("Failed to remove nonce '" + string + "'");
            }
        });
    }

    public boolean isValidNonce(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return false;
        }
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aNoncesBase64.contains((Object)string));
    }

    @Nonnegative
    public int getNonceCount() {
        return this.m_aRWLock.readLockedInt(() -> this.m_aNoncesBase64.size());
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<String> getAllNonces() {
        return (ICommonsSet)this.m_aRWLock.readLockedGet(() -> this.m_aNoncesBase64.getClone());
    }
}

