/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.debug.GlobalDebug;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.html.hc.config.HCSettings;
import com.helger.html.resource.css.ICSSPathProvider;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.photon.app.url.IWebURIToURLConverter;
import com.helger.photon.app.url.StreamOrLocalURIToURLConverter;
import com.helger.url.ISimpleURL;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class PhotonAppSettings {
    public static final String DEFAULT_RESOURCE_BUNDLE_SERVLET_NAME = "resbundle";
    private static final Logger LOGGER = LoggerFactory.getLogger(PhotonAppSettings.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static IWebURIToURLConverter s_aURIToURLConverter = new StreamOrLocalURIToURLConverter();
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bMergeCSSResources = GlobalDebug.isProductionMode();
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bMergeJSResources = GlobalDebug.isProductionMode();
    @GuardedBy(value="RW_LOCK")
    private static String s_sResourceBundleServletName = "resbundle";

    private PhotonAppSettings() {
    }

    @Nonnull
    public static IWebURIToURLConverter getURIToURLConverter() {
        return (IWebURIToURLConverter)RW_LOCK.readLockedGet(() -> s_aURIToURLConverter);
    }

    public static void setURIToURLConverter(@Nonnull IWebURIToURLConverter iWebURIToURLConverter) {
        ValueEnforcer.notNull((Object)iWebURIToURLConverter, (String)"URIToURLConverter");
        RW_LOCK.writeLocked(() -> {
            s_aURIToURLConverter = iWebURIToURLConverter;
        });
    }

    @Nonnull
    public static ISimpleURL getCSSPath(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull ICSSPathProvider iCSSPathProvider, boolean bl) {
        String string = iCSSPathProvider.getCSSItemPath(bl);
        return PhotonAppSettings.getURIToURLConverter().getAsURL(iRequestWebScopeWithoutResponse, string);
    }

    @Nonnull
    public static ISimpleURL getJSPath(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull IJSPathProvider iJSPathProvider, boolean bl) {
        String string = iJSPathProvider.getJSItemPath(bl);
        return PhotonAppSettings.getURIToURLConverter().getAsURL(iRequestWebScopeWithoutResponse, string);
    }

    public static boolean isMergeCSSResources() {
        return RW_LOCK.readLockedBoolean(() -> s_bMergeCSSResources);
    }

    public static void setMergeCSSResources(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bMergeCSSResources = bl;
        });
        if (!HCSettings.isSilentMode()) {
            LOGGER.info(bl ? "Merging CSS resources" : "Using separate CSS resources");
        }
    }

    public static boolean isMergeJSResources() {
        return RW_LOCK.readLockedBoolean(() -> s_bMergeJSResources);
    }

    public static void setMergeJSResources(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bMergeJSResources = bl;
        });
        if (!HCSettings.isSilentMode()) {
            LOGGER.info(bl ? "Merging JS resources" : "Using separate JS resources");
        }
    }

    @Nonnull
    @Nonempty
    public static String getResourceBundleServletName() {
        return (String)RW_LOCK.readLockedGet(() -> s_sResourceBundleServletName);
    }

    public static void setResourceBundleServletName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ResourceBundleServletName");
        RW_LOCK.writeLocked(() -> {
            s_sResourceBundleServletName = string;
        });
        if (!HCSettings.isSilentMode()) {
            LOGGER.info("Using ResourceBundleServlet name '" + string + "'");
        }
    }
}

